<?php if (!function_exists('avatar_img')) { @include_once '../../helpers.php'; } ?>
<div class="grid" style="margin-top:40px;max-width:480px;margin-left:auto;margin-right:auto">
  <?php if($m = flash('error')): ?>
    <div class="alert alert-error">
      <i class="fas fa-exclamation-circle"></i>
      <div><?php echo h($m); ?></div>
    </div>
  <?php endif; ?>
  
  <form class="card" method="post">
<?= csrf_field() ?>

    <h2 style="margin-top:0"><i class="fas fa-key"></i> Nueva contraseña</h2>
    <div class="muted" style="margin-bottom:16px">Crea una nueva contraseña para tu cuenta.</div>
    
    <div class="grid">
      <div>
        <label for="password" style="display:block;margin-bottom:8px;font-weight:500">Nueva contraseña</label>
        <input id="password" type="password" name="password" placeholder="Mínimo 8 caracteres" required minlength="8">
        <div class="muted" style="font-size:0.8rem;margin-top:4px">Debe contener mayúsculas, minúsculas y números</div>
      </div>
      
      <div>
        <label for="password_confirm" style="display:block;margin-bottom:8px;font-weight:500">Confirmar contraseña</label>
        <input id="password_confirm" type="password" name="password_confirm" placeholder="Repite tu contraseña" required>
      </div>
      
      <button class="btn primary" type="submit"><i class="fas fa-save"></i> Guardar nueva contraseña</button>
    </div>
  </form>
</div>

<script>
document.querySelector('form').addEventListener('submit', function(e) {
  const password = document.getElementById('password');
  const passwordConfirm = document.getElementById('password_confirm');
  
  if (password.value !== passwordConfirm.value) {
    e.preventDefault();
    alert('Las contraseñas no coinciden');
    password.focus();
    return false;
  }
  
  if (password.value.length < 8) {
    e.preventDefault();
    alert('La contraseña debe tener al menos 8 caracteres');
    password.focus();
    return false;
  }
  
  return true;
});
</script>