<?php if (!function_exists('avatar_img')) { @include_once '../../helpers.php'; } ?>


<!-- Restored Admin Styles -->
<style>

        :root {
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --secondary: #6c757d;
            --success: #28a745;
            --danger: #dc3545;
            --warning: #ffc107;
            --info: #17a2b8;
            --light: #f8f9fa;
            --dark: #343a40;
            --bg-main: #f5f7f9;
            --bg-card: #ffffff;
            --text-main: #212529;
            --text-muted: #6c757d;
            --border: #dee2e6;
            --radius: 8px;
            --radius-sm: 4px;
            --shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background-color: var(--bg-main);
            color: var(--text-main);
            line-height: 1.6;
            padding: 20px;
        }

        .admin-container {
            max-width: 1400px;
            margin: 0 auto;
        }

        .admin-header {
            display: flex;
            align-items: center;
            margin-bottom: 24px;
            gap: 16px;
        }

        .back-button {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: var(--bg-card);
            color: var(--primary);
            border: 1px solid var(--border);
            cursor: pointer;
            transition: var(--transition);
            text-decoration: none;
        }

        .back-button:hover {
            background: var(--primary);
            color: white;
        }

        .admin-header h1 {
            font-size: 28px;
            font-weight: 700;
            color: var(--dark);
            margin-bottom: 0;
        }

        .admin-header p {
            color: var(--text-muted);
            font-size: 16px;
        }

        .admin-stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .stat-card {
            background: var(--bg-card);
            border-radius: var(--radius);
            padding: 20px;
            box-shadow: var(--shadow);
            transition: var(--transition);
        }

        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
        }

        .stat-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 16px;
        }

        .stat-title {
            font-size: 14px;
            font-weight: 600;
            color: var(--text-muted);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .stat-icon {
            width: 48px;
            height: 48px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
        }

        .stat-icon.users {
            background: rgba(67, 97, 238, 0.1);
            color: var(--primary);
        }

        .stat-icon.posts {
            background: rgba(40, 167, 69, 0.1);
            color: var(--success);
        }

        .stat-icon.comments {
            background: rgba(23, 162, 184, 0.1);
            color: var(--info);
        }

        .stat-icon.reports {
            background: rgba(255, 193, 7, 0.1);
            color: var(--warning);
        }

        .stat-value {
            font-size: 32px;
            font-weight: 700;
            margin-bottom: 12px;
            color: var(--dark);
        }

        .stat-desc {
            font-size: 14px;
            color: var(--text-muted);
            margin-bottom: 16px;
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .trend {
            font-size: 12px;
            font-weight: 600;
            padding: 4px 8px;
            border-radius: 20px;
            display: inline-flex;
            align-items: center;
            gap: 4px;
        }

        .trend.positive {
            background: rgba(40, 199, 111, 0.2);
            color: #28c76f;
        }

        .trend.negative {
            background: rgba(255, 77, 77, 0.2);
            color: #ff4d4d;
        }

        .stat-action .btn {
            width: 100%;
            text-align: center;
            padding: 8px 16px;
            border-radius: var(--radius-sm);
            font-size: 14px;
            font-weight: 600;
            text-decoration: none;
            display: block;
            transition: var(--transition);
        }

        .btn-primary {
            background: var(--primary);
            color: white;
            border: none;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
        }

        .btn-warning {
            background: var(--warning);
            color: var(--dark);
            border: none;
        }

        .btn-warning:hover {
            background: #e0a800;
        }

        .btn-danger {
            background: var(--danger);
            color: white;
            border: none;
        }

        .btn-danger:hover {
            background: #c82333;
        }

        .btn-success {
            background: var(--success);
            color: white;
            border: none;
        }

        .btn-success:hover {
            background: #218838;
        }

        .filters {
            background: var(--bg-card);
            border-radius: var(--radius);
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: var(--shadow);
        }

        .filter-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-bottom: 15px;
        }

        .filter-group {
            display: flex;
            flex-direction: column;
        }

        .filter-label {
            font-size: 14px;
            font-weight: 600;
            margin-bottom: 8px;
            color: var(--text-muted);
        }

        .filter-input, .filter-select {
            padding: 10px 12px;
            border: 1px solid var(--border);
            border-radius: var(--radius-sm);
            font-size: 14px;
            transition: var(--transition);
        }

        .filter-input:focus, .filter-select:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.1);
        }

        .filter-actions {
            display: flex;
            gap: 10px;
            justify-content: flex-end;
        }

        .btn-sm {
            padding: 8px 16px;
            font-size: 14px;
            border-radius: var(--radius-sm);
            cursor: pointer;
            transition: var(--transition);
        }

        .btn-outline {
            background: transparent;
            border: 1px solid var(--border);
            color: var(--text-muted);
        }

        .btn-outline:hover {
            background: var(--bg-main);
        }

        .users-table {
            width: 100%;
            background: var(--bg-card);
            border-radius: var(--radius);
            overflow: hidden;
            box-shadow: var(--shadow);
            margin-bottom: 20px;
        }

        .users-table table {
            width: 100%;
            border-collapse: collapse;
        }

        .users-table th {
            background: var(--bg-main);
            padding: 16px;
            text-align: left;
            font-weight: 600;
            color: var(--text-muted);
            font-size: 14px;
        }

        .users-table td {
            padding: 16px;
            border-top: 1px solid var(--border);
        }

        .users-table tr:hover {
            background: var(--bg-main);
        }

        .user-info {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 16px;
        }

        .user-details {
            display: flex;
            flex-direction: column;
        }

        .user-name {
            font-weight: 600;
            margin-bottom: 4px;
        }

        .user-email {
            font-size: 14px;
            color: var(--text-muted);
        }

        .badge {
            padding: 4px 8px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            display: inline-block;
        }

        .badge-success {
            background: rgba(40, 167, 69, 0.1);
            color: var(--success);
        }

        .badge-warning {
            background: rgba(255, 193, 7, 0.1);
            color: var(--warning);
        }

        .badge-danger {
            background: rgba(220, 53, 69, 0.1);
            color: var(--danger);
        }

        .badge-info {
            background: rgba(23, 162, 184, 0.1);
            color: var(--info);
        }

        .badge-secondary {
            background: rgba(108, 117, 125, 0.1);
            color: var(--secondary);
        }

        .action-buttons {
            display: flex;
            gap: 8px;
        }

        .btn-icon {
            width: 32px;
            height: 32px;
            border-radius: var(--radius-sm);
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: var(--transition);
        }

        .btn-view {
            background: rgba(23, 162, 184, 0.1);
            color: var(--info);
        }

        .btn-view:hover {
            background: rgba(23, 162, 184, 0.2);
        }

        .btn-edit {
            background: rgba(255, 193, 7, 0.1);
            color: var(--warning);
        }

        .btn-edit:hover {
            background: rgba(255, 193, 7, 0.2);
        }

        .btn-ban {
            background: rgba(220, 53, 69, 0.1);
            color: var(--danger);
        }

        .btn-ban:hover {
            background: rgba(220, 53, 69, 0.2);
        }

        .btn-unban {
            background: rgba(40, 167, 69, 0.1);
            color: var(--success);
        }

        .btn-unban:hover {
            background: rgba(40, 167, 69, 0.2);
        }

        .pagination {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 12px;
            margin-top: 20px;
        }

        .pagination-info {
            font-size: 14px;
            color: var(--text-muted);
        }

        .pagination-button {
            padding: 8px 16px;
            border: 1px solid var(--border);
            border-radius: var(--radius-sm);
            background: var(--bg-card);
            color: var(--text-main);
            cursor: pointer;
            transition: var(--transition);
        }

        .pagination-button:hover:not(:disabled) {
            background: var(--bg-main);
        }

        .pagination-button:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }

        .pagination-active {
            background: var(--primary);
            color: white;
            border-color: var(--primary);
        }

        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 1000;
            align-items: center;
            justify-content: center;
        }

        .modal-content {
            background: var(--bg-card);
            border-radius: var(--radius);
            width: 100%;
            max-width: 500px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
            overflow: hidden;
        }

        .modal-header {
            padding: 20px;
            border-bottom: 1px solid var(--border);
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: var(--bg-main);
        }

        .modal-title {
            font-size: 18px;
            font-weight: 600;
        }

        .modal-close {
            background: none;
            border: none;
            font-size: 20px;
            cursor: pointer;
            color: var(--text-muted);
        }

        .modal-body {
            padding: 20px;
        }

        .modal-form-group {
            margin-bottom: 16px;
        }

        .modal-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            font-size: 14px;
        }

        .modal-input, .modal-select, .modal-textarea {
            width: 100%;
            padding: 10px 12px;
            border: 1px solid var(--border);
            border-radius: var(--radius-sm);
            font-size: 14px;
            transition: var(--transition);
        }

        .modal-input:focus, .modal-select:focus, .modal-textarea:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.1);
        }

        .modal-textarea {
            min-height: 100px;
            resize: vertical;
        }

        .modal-footer {
            padding: 20px;
            border-top: 1px solid var(--border);
            display: flex;
            justify-content: flex-end;
            gap: 12px;
            background: var(--bg-main);
        }

        .admin-logs {
            margin-top: 30px;
            background: var(--bg-card);
            border-radius: var(--radius);
            padding: 20px;
            box-shadow: var(--shadow);
        }

        .logs-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 16px;
        }

        .logs-title {
            font-size: 18px;
            font-weight: 600;
        }

        .logs-table {
            width: 100%;
            border-collapse: collapse;
        }

        .logs-table th {
            background: var(--bg-main);
            padding: 12px;
            text-align: left;
            font-weight: 600;
            color: var(--text-muted);
            font-size: 14px;
        }

        .logs-table td {
            padding: 12px;
            border-top: 1px solid var(--border);
            font-size: 14px;
        }

        .logs-table tr:hover {
            background: var(--bg-main);
        }

        .log-reason {
            max-width: 200px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
            cursor: pointer;
        }

        .log-reason.expanded {
            white-space: normal;
            overflow: visible;
            max-width: none;
        }

        .locked-until {
            font-size: 12px;
            color: var(--text-muted);
            margin-top: 4px;
        }

        /* Responsive */
        @media (max-width: 1024px) {
            .users-table, .logs-table {
                overflow-x: auto;
            }
            
            .users-table table, .logs-table table {
                min-width: 900px;
            }
            
            .filter-row {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 768px) {
            .admin-stats {
                grid-template-columns: 1fr;
            }
            
            .action-buttons {
                flex-direction: column;
            }
            
            .btn-icon {
                width: 28px;
                height: 28px;
            }
            
            .admin-header {
                flex-direction: column;
                align-items: flex-start;
                gap: 10px;
            }
            
            .modal-content {
                margin: 20px;
                width: calc(100% - 40px);
            }
        }
    
</style>
<div class="admin-container">
        <div class="admin-header">
            <a href="./?r=admin/dashboard" class="back-button" title="Volver al dashboard">
                <i class="fas fa-arrow-left"></i>
            </a>
            <div>
                <h1>Gestión de Usuarios</h1>
                <p>Administra los usuarios del sistema y sus permisos</p>
            </div>
        </div>

        <div class="admin-stats">
            <div class="stat-card">
                <div class="stat-header">
                    <div class="stat-title">Usuarios Totales</div>
                    <div class="stat-icon users">
                        <i class="fas fa-users"></i>
                    </div>
                </div>
                <div class="stat-value"><?= h($stats['total_users']) ?></div>
                <div class="stat-desc">
                    <span class="trend positive"><i class="fas fa-arrow-up"></i> 12%</span>
                    vs mes anterior
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-header">
                    <div class="stat-title">Usuarios Activos</div>
                    <div class="stat-icon posts">
                        <i class="fas fa-user-check"></i>
                    </div>
                </div>
                <div class="stat-value"><?= h($stats['total_users'] - 2) ?></div>
                <div class="stat-desc">
                    <span class="trend positive"><i class="fas fa-arrow-up"></i> 8%</span>
                    usuarios en línea
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-header">
                    <div class="stat-title">Usuarios Bloqueados</div>
                    <div class="stat-icon comments">
                        <i class="fas fa-user-lock"></i>
                    </div>
                </div>
                <div class="stat-value"><?= h($stats['locked_attempts']) ?></div>
                <div class="stat-desc">
                    <span class="trend negative"><i class="fas fa-arrow-up"></i> 5%</span>
                    necesita revisión
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-header">
                    <div class="stat-title">Administradores</div>
                    <div class="stat-icon reports">
                        <i class="fas fa-crown"></i>
                    </div>
                </div>
                <div class="stat-value">1</div>
                <div class="stat-desc">
                    <span class="trend positive"><i class="fas fa-arrow-up"></i> 0%</span>
                    sin cambios
                </div>
            </div>
        </div>

        <div class="filters">
            <form method="GET" action="./?r=admin/users">
                <input type="hidden" name="r" value="admin/users">
                
                <div class="filter-row">
                    <div class="filter-group">
                        <label class="filter-label">Buscar usuario</label>
                        <input type="text" name="q" class="filter-input" placeholder="Nombre o email" value="<?= h($_GET['q'] ?? '') ?>">
                    </div>
                    
                    <div class="filter-group">
                        <label class="filter-label">Rol</label>
                        <select name="role" class="filter-select">
                            <option value="">Todos los roles</option>
                            <option value="user" <?= (!empty($_GET['role']) && $_GET['role'] === 'user') ? 'selected' : '' ?>>Usuario</option>
                            <option value="moderator" <?= (!empty($_GET['role']) && $_GET['role'] === 'moderator') ? 'selected' : '' ?>>Moderador</option>
                            <option value="admin" <?= (!empty($_GET['role']) && $_GET['role'] === 'admin') ? 'selected' : '' ?>>Administrador</option>
                        </select>
                    </div>
                    
                    <div class="filter-group">
                        <label class="filter-label">Estado</label>
                        <select name="status" class="filter-select">
                            <option value="">Todos los estados</option>
                            <option value="active" <?= (!empty($_GET['status']) && $_GET['status'] === 'active') ? 'selected' : '' ?>>Activo</option>
                            <option value="locked" <?= (!empty($_GET['status']) && $_GET['status'] === 'locked') ? 'selected' : '' ?>>Bloqueado</option>
                        </select>
                    </div>
                </div>
                
                <div class="filter-actions">
                    <button type="submit" class="btn-sm btn-primary">
                        <i class="fas fa-filter"></i> Aplicar Filtros
                    </button>
                    <a href="./?r=admin/users" class="btn-sm btn-outline">
                        <i class="fas fa-times"></i> Limpiar
                    </a>
                </div>
            </form>
        </div>

        <div class="users-table">
            <table>
                <thead>
                    <tr>
                        <th>Usuario</th>
                        <th>Email</th>
                        <th>Rol</th>
                        <th>Estado</th>
                        <th>Registro</th>
                        <th>Último acceso</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($users as $user): ?>
                    <tr>
                        <td>
                            <div class="user-info">
                                <div class="user-avatar" style="overflow:hidden;border-radius:50%;padding:0;background:none;">
                                    <?= strtoupper(substr($user['username'], 0, 1)) ?>
                                </div>
                                <div class="user-details">
                                    <div class="user-name"><?= h($user['username']) ?></div>
                                    <div class="user-id">ID: <?= h(substr($user['id'], 0, 8)) ?>...</div>
                                </div>
                            </div>
                        </td>
                        <td><?= h($user['email']) ?></td>
                        <td>
                            <?php if ($user['role'] === 'admin'): ?>
                                <span class="badge badge-danger">Administrador</span>
                            <?php elseif ($user['role'] === 'moderator'): ?>
                                <span class="badge badge-warning">Moderador</span>
                            <?php else: ?>
                                <span class="badge badge-secondary">Usuario</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($user['locked_until'] && strtotime($user['locked_until']) > time()): ?>
                                <span class="badge badge-danger">Bloqueado</span>
                                <div class="locked-until">Hasta: <?= h(fdt($user['locked_until'], 'd/m/Y H:i')) ?></div>
                            <?php elseif ($user['email_verified']): ?>
                                <span class="badge badge-success">Verificado</span>
                            <?php else: ?>
                                <span class="badge badge-warning">No verificado</span>
                            <?php endif; ?>
                        </td>
                        <td><?= h(fdt($user['created_at'], 'd/m/Y')) ?></td>
                        <td>
                            <?php if ($user['last_login']): ?>
                                <?= h(time_elapsed_string($user['last_login'])) ?>
                            <?php else: ?>
                                <span class="muted">Nunca</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="action-buttons">
                                <button class="btn-icon btn-view" title="Ver perfil" onclick="viewUser('<?= h($user['id']) ?>')">
                                    <i class="fas fa-eye"></i>
                                </button>
                                <button class="btn-icon btn-edit" title="Editar usuario" onclick="editUser('<?= h($user['id']) ?>', '<?= h($user['username']) ?>', '<?= h($user['role']) ?>', <?= h($user['email_verified']) ? 'true' : 'false' ?>)">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <?php if ($user['id'] !== $_SESSION['user']['id']): ?>
                                    <?php if ($user['locked_until'] && strtotime($user['locked_until']) > time()): ?>
                                        <button class="btn-icon btn-unban" title="Desbloquear usuario" onclick="unbanUser('<?= h($user['id']) ?>', '<?= h($user['username']) ?>')">
                                            <i class="fas fa-unlock"></i>
                                        </button>
                                    <?php else: ?>
                                        <button class="btn-icon btn-ban" title="Bloquear usuario" onclick="banUser('<?= h($user['id']) ?>', '<?= h($user['username']) ?>')">
                                            <i class="fas fa-ban"></i>
                                        </button>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="pagination">
            <button class="pagination-button" <?= $pagination['page'] <= 1 ? 'disabled' : '' ?> onclick="changePage(<?= $pagination['page'] - 1 ?>)">
                <i class="fas fa-chevron-left"></i> Anterior
            </button>
            
            <span class="pagination-info">
                Página <?= $pagination['page'] ?> de <?= $pagination['totalPages'] ?>
            </span>
            
            <button class="pagination-button" <?= $pagination['page'] >= $pagination['totalPages'] ? 'disabled' : '' ?> onclick="changePage(<?= $pagination['page'] + 1 ?>)">
                Siguiente <i class="fas fa-chevron-right"></i>
            </button>
        </div>

        <div class="admin-logs">
            <div class="logs-header">
                <h3 class="logs-title">Registro de Actividad de Administración</h3>
                <button class="btn-sm btn-outline" onclick="refreshLogs()">
                    <i class="fas fa-sync-alt"></i> Actualizar
                </button>
            </div>
            
            <div class="logs-table">
                <table>
                    <thead>
                        <tr>
                            <th>Fecha</th>
                            <th>Administrador</th>
                            <th>Acción</th>
                            <th>Usuario afectado</th>
                            <th>Detalles</th>
                            <th>Motivo</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($admin_logs)): ?>
                            <?php foreach ($admin_logs as $log): ?>
                            <tr>
                                <td><?= h(fdt($log['created_at'], 'd/m/Y H:i')) ?></td>
                                <td><?= h($log['admin_username']) ?></td>
                                <td>
                                    <span class="badge 
                                        <?= strpos($log['action'], 'delete') !== false ? 'badge-danger' : 
                                           (strpos($log['action'], 'block') !== false ? 'badge-warning' : 'badge-info') ?>">
                                        <?= h(ucfirst(str_replace('_', ' ', $log['action']))) ?>
                                    </span>
                                </td>
                                <td><?= h($log['target_username']) ?></td>
                                <td><?= h($log['details']) ?></td>
                                <td class="log-reason" onclick="this.classList.toggle('expanded')" title="Haz clic para expandir">
                                    <?= h($log['admin_reason']) ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="6" style="text-align: center; padding: 20px; color: var(--text-muted);">
                                    No hay registros de actividad recientes
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Modal para bloquear usuario -->
    <div class="modal" id="banModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title">Bloquear Usuario</h3>
                <button class="modal-close" onclick="closeModal('banModal')">&times;</button>
            </div>
            <form method="POST" action="./?r=admin/block-user">
<?= csrf_field() ?>

                <input type="hidden" name="user_id" id="banUserId">
                
                <div class="modal-body">
                    <div class="modal-form-group">
                        <label class="modal-label">Usuario</label>
                        <input type="text" id="banUserName" class="modal-input" readonly>
                    </div>
                    
                    <div class="modal-form-group">
                        <label class="modal-label">Duración del bloqueo</label>
                        <select name="duration" class="modal-select" required>
                            <option value="60">1 hora</option>
                            <option value="1440">1 día</option>
                            <option value="10080">1 semana</option>
                            <option value="43200">1 mes</option>
                            <option value="525600">Permanente</option>
                        </select>
                    </div>
                    
                    <div class="modal-form-group">
                        <label class="modal-label">Motivo (obligatorio para registro)</label>
                        <textarea name="reason" class="modal-textarea" placeholder="Razón del bloqueo..." required></textarea>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn-sm btn-outline" onclick="closeModal('banModal')">Cancelar</button>
                    <button type="submit" class="btn-sm btn-danger">Confirmar Bloqueo</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Modal para desbloquear usuario -->
    <div class="modal" id="unbanModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title">Desbloquear Usuario</h3>
                <button class="modal-close" onclick="closeModal('unbanModal')">&times;</button>
            </div>
            <form method="POST" action="./?r=admin/unblock-user">
<?= csrf_field() ?>

                <input type="hidden" name="user_id" id="unbanUserId">
                
                <div class="modal-body">
                    <div class="modal-form-group">
                        <label class="modal-label">Usuario</label>
                        <input type="text" id="unbanUserName" class="modal-input" readonly>
                    </div>
                    
                    <div class="modal-form-group">
                        <label class="modal-label">Motivo (obligatorio para registro)</label>
                        <textarea name="reason" class="modal-textarea" placeholder="Razón del desbloqueo..." required></textarea>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn-sm btn-outline" onclick="closeModal('unbanModal')">Cancelar</button>
                    <button type="submit" class="btn-sm btn-success">Confirmar Desbloqueo</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Modal para editar usuario -->
    <div class="modal" id="editModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title">Editar Usuario</h3>
                <button class="modal-close" onclick="closeModal('editModal')">&times;</button>
            </div>
            <form method="POST" action="./?r=admin/update-user">
<?= csrf_field() ?>

                <input type="hidden" name="user_id" id="editUserId">
                
                <div class="modal-body">
                    <div class="modal-form-group">
                        <label class="modal-label">ID de Usuario</label>
                        <input type="text" id="editUserID" class="modal-input" readonly>
                    </div>
                    
                    <div class="modal-form-group">
                        <label class="modal-label">Nombre de usuario</label>
                        <input type="text" id="editUserName" class="modal-input" readonly>
                    </div>
                    
                    <div class="modal-form-group">
                        <label class="modal-label">Rol de usuario</label>
                        <select name="role" class="modal-select" id="editUserRole" required>
                            <option value="user">Usuario</option>
                            <option value="moderator">Moderador</option>
                            <option value="admin">Administrador</option>
                        </select>
                    </div>
                    
                    <div class="modal-form-group">
                        <label class="modal-label">Estado de verificación</label>
                        <select name="email_verified" class="modal-select" id="editUserVerified" required>
                            <option value="0">No verificado</option>
                            <option value="1">Verificado</option>
                        </select>
                    </div>
                    
                    <div class="modal-form-group">
                        <label class="modal-label">Motivo del cambio (obligatorio para registro)</label>
                        <textarea name="reason" class="modal-textarea" placeholder="Razón del cambio..." required></textarea>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn-sm btn-outline" onclick="closeModal('editModal')">Cancelar</button>
                    <button type="submit" class="btn-sm btn-primary">Guardar Cambios</button>
                </div>
            </form>
        </div>
    </div>

    <script>
        function changePage(page) {
            const url = new URL(window.location.href);
            url.searchParams.set('page', page);
            window.location.href = url.toString();
        }
        
        function banUser(userId, userName) {
            document.getElementById('banUserId').value = userId;
            document.getElementById('banUserName').value = userName;
            document.getElementById('banModal').style.display = 'flex';
        }
        
        function unbanUser(userId, userName) {
            document.getElementById('unbanUserId').value = userId;
            document.getElementById('unbanUserName').value = userName;
            document.getElementById('unbanModal').style.display = 'flex';
        }
        
        function editUser(userId, userName, userRole, userVerified) {
            document.getElementById('editUserId').value = userId;
            document.getElementById('editUserID').value = userId;
            document.getElementById('editUserName').value = userName;
            document.getElementById('editUserRole').value = userRole;
            document.getElementById('editUserVerified').value = userVerified ? '1' : '0';
            document.getElementById('editModal').style.display = 'flex';
        }
        
        function viewUser(userId) {
            window.open('./?r=profile/friend&id=' + userId, '_blank');
        }
        
        function refreshLogs() {
            window.location.reload();
        }
        
        function closeModal(modalId) {
            document.getElementById(modalId).style.display = 'none';
        }
        
        // Cerrar modal al hacer clic fuera del contenido
        window.onclick = function(event) {
            const modals = document.getElementsByClassName('modal');
            for (let modal of modals) {
                if (event.target === modal) {
                    modal.style.display = 'none';
                }
            }
        };
    </script>
