<?php if (!function_exists('avatar_img')) { @include_once '../../../helpers.php'; } ?>


<!-- Restored Admin Styles -->
<style>

        :root {
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --secondary: #6c757d;
            --success: #28a745;
            --danger: #dc3545;
            --warning: #ffc107;
            --info: #17a2b8;
            --light: #f8f9fa;
            --dark: #343a40;
            --bg-main: #f5f7f9;
            --bg-card: #ffffff;
            --text-main: #212529;
            --text-muted: #6c757d;
            --border: #dee2e6;
            --radius: 12px;
            --radius-sm: 8px;
            --shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background-color: var(--bg-main);
            color: var(--text-main);
            line-height: 1.6;
            padding: 20px;
        }

        .settings-container {
            max-width: 1000px;
            margin: 0 auto;
        }

        .settings-header {
            background: var(--bg-card);
            border-radius: var(--radius);
            padding: 25px;
            margin-bottom: 24px;
            box-shadow: var(--shadow);
        }

        .settings-header h1 {
            font-size: 28px;
            font-weight: 700;
            color: var(--dark);
            margin-bottom: 8px;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .settings-header p {
            color: var(--text-muted);
            font-size: 16px;
        }

        .settings-card {
            background: var(--bg-card);
            border-radius: var(--radius);
            padding: 30px;
            margin-bottom: 24px;
            box-shadow: var(--shadow);
        }

        .card-title {
            font-size: 20px;
            font-weight: 600;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 2px solid var(--border);
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: var(--dark);
        }

        .form-help {
            font-size: 0.85rem;
            color: var(--text-muted);
            margin-top: 5px;
        }

        .form-control {
            width: 100%;
            padding: 12px 16px;
            border: 1px solid var(--border);
            border-radius: var(--radius-sm);
            font-size: 16px;
            transition: var(--transition);
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.1);
        }

        .form-select {
            width: 100%;
            padding: 12px 16px;
            border: 1px solid var(--border);
            border-radius: var(--radius-sm);
            font-size: 16px;
            background: white;
        }

        .form-textarea {
            min-height: 120px;
            resize: vertical;
        }

        .checkbox-group {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .checkbox {
            width: 18px;
            height: 18px;
        }

        .btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 12px 24px;
            border-radius: var(--radius-sm);
            text-decoration: none;
            font-weight: 600;
            transition: var(--transition);
            border: none;
            cursor: pointer;
            font-size: 16px;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
        }

        .btn-secondary {
            background: var(--secondary);
            color: white;
        }

        .btn-secondary:hover {
            background: #5a6268;
            transform: translateY(-2px);
        }

        .settings-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
        }

        @media (max-width: 768px) {
            .settings-grid {
                grid-template-columns: 1fr;
            }
            
            .settings-header h1 {
                font-size: 24px;
            }
        }

        .time-unit {
            color: var(--text-muted);
            font-size: 0.9rem;
            margin-left: 5px;
        }

        .current-value {
            background: var(--light);
            padding: 8px 12px;
            border-radius: var(--radius-sm);
            font-family: monospace;
            font-size: 0.9rem;
            margin-top: 5px;
        }
    
</style>
<div class="settings-container">
        <!-- Header -->
        <div class="settings-header">
            <h1>
                <i class="fas fa-cogs"></i>
                Configuración del Sistema
            </h1>
            <p>Ajusta los parámetros generales de la plataforma Thirty</p>
        </div>

        <form method="post">
            <?= csrf_field() ?>
            
            <!-- Información del Sitio -->
            <div class="settings-card">
                <div class="card-title">
                    <i class="fas fa-info-circle"></i>
                    Información del Sitio
                </div>
                
                <div class="form-group">
                    <label class="form-label" for="site_name">Nombre del Sitio</label>
                    <input type="text" class="form-control" id="site_name" name="site_name" 
                           value="<?= h($config['site_name'] ?? 'Thirty') ?>" required>
                    <div class="form-help">Este nombre aparecerá en el título y cabecera del sitio</div>
                </div>

                <div class="form-group">
                    <label class="form-label" for="site_description">Descripción del Sitio</label>
                    <textarea class="form-control form-textarea" id="site_description" name="site_description"><?= h($config['site_description'] ?? 'La red social de tus amigos de verdad') ?></textarea>
                    <div class="form-help">Breve descripción que aparecerá en metaetiquetas y sobre el sitio</div>
                </div>
            </div>

            <!-- Configuración de Seguridad -->
            <div class="settings-card">
                <div class="card-title">
                    <i class="fas fa-shield-alt"></i>
                    Configuración de Seguridad
                </div>
                
                <div class="settings-grid">
                    <div class="form-group">
                        <label class="form-label" for="max_login_attempts">Máximo de Intentos de Login</label>
                        <input type="number" class="form-control" id="max_login_attempts" name="max_login_attempts" 
                               value="<?= h($config['max_login_attempts'] ?? 5) ?>" min="1" max="20" required>
                        <div class="form-help">Número de intentos fallidos antes de bloquear la cuenta</div>
                    </div>

                    <div class="form-group">
                        <label class="form-label" for="session_timeout">Tiempo de Sesión (segundos)</label>
                        <input type="number" class="form-control" id="session_timeout" name="session_timeout" 
                               value="<?= h($config['session_timeout'] ?? 7200) ?>" min="300" max="86400" required>
                        <div class="form-help">Tiempo de inactividad antes de cerrar sesión automáticamente</div>
                        <div class="current-value">Actual: <?= h($config['session_timeout'] ?? 7200) ?> segundos (<?= round(($config['session_timeout'] ?? 7200)/3600, 1) ?> horas)</div>
                    </div>
                </div>
            </div>

            <!-- Configuración de Cookies -->
            <div class="settings-card">
                <div class="card-title">
                    <i class="fas fa-cookie"></i>
                    Configuración de Cookies
                </div>
                
                <div class="settings-grid">
                    <div class="form-group">
                        <label class="form-label" for="cookie_lifetime">Duración de Cookies de Sesión</label>
                        <input type="number" class="form-control" id="cookie_lifetime" name="cookie_lifetime" 
                               value="<?= h($config['cookie_lifetime'] ?? 86400) ?>" min="3600" max="31536000" required>
                        <div class="form-help">Tiempo de vida de las cookies de sesión en segundos</div>
                        <div class="current-value">Actual: <?= h($config['cookie_lifetime'] ?? 86400) ?> segundos (<?= round(($config['cookie_lifetime'] ?? 86400)/86400, 1) ?> días)</div>
                    </div>

                    <div class="form-group">
                        <label class="form-label" for="ad_cookie_duration">Duración Cookie Anuncios</label>
                        <input type="number" class="form-control" id="ad_cookie_duration" name="ad_cookie_duration" 
                               value="<?= h($config['ad_cookie_duration'] ?? 86400) ?>" min="3600" max="604800" required>
                        <div class="form-help">Tiempo que se recuerda la preferencia de ocultar anuncios</div>
                        <div class="current-value">Actual: <?= h($config['ad_cookie_duration'] ?? 86400) ?> segundos (<?= round(($config['ad_cookie_duration'] ?? 86400)/86400, 1) ?> días)</div>
                    </div>

                    <div class="form-group">
                        <label class="form-label" for="birthday_panel_duration">Duración Panel Cumpleaños</label>
                        <input type="number" class="form-control" id="birthday_panel_duration" name="birthday_panel_duration" 
                               value="<?= h($config['birthday_panel_duration'] ?? 3600) ?>" min="600" max="86400" required>
                        <div class="form-help">Tiempo que se oculta el panel de cumpleaños después de cerrarlo</div>
                        <div class="current-value">Actual: <?= h($config['birthday_panel_duration'] ?? 3600) ?> segundos (<?= round(($config['birthday_panel_duration'] ?? 3600)/3600, 1) ?> horas)</div>
                    </div>
                </div>
            </div>

            <!-- Configuración de Registros -->
            <div class="settings-card">
                <div class="card-title">
                    <i class="fas fa-user-plus"></i>
                    Configuración de Registros
                </div>
                
                <div class="form-group">
                    <div class="checkbox-group">
                        <input type="checkbox" class="checkbox" id="allow_registrations" name="allow_registrations" 
                               <?= ($config['allow_registrations'] ?? 1) ? 'checked' : '' ?>>
                        <label class="form-label" for="allow_registrations" style="margin: 0;">
                            Permitir nuevos registros
                        </label>
                    </div>
                    <div class="form-help">Cuando está desactivado, los nuevos usuarios no podrán registrarse en el sitio</div>
                </div>
            </div>

            <!-- Botones de Acción -->
            <div class="settings-card">
                <div style="display: flex; gap: 15px; flex-wrap: wrap;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Guardar Configuración
                    </button>
                    <a href="./?r=admin/control-panel" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Volver al Panel
                    </a>
                    <button type="reset" class="btn btn-secondary">
                        <i class="fas fa-undo"></i> Restablecer
                    </button>
                </div>
            </div>
        </form>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Conversión automática de segundos a unidades legibles
            const timeInputs = document.querySelectorAll('input[type="number"]');
            timeInputs.forEach(input => {
                input.addEventListener('change', function() {
                    const seconds = parseInt(this.value);
                    let readable = '';
                    
                    if (seconds < 60) {
                        readable = seconds + ' segundos';
                    } else if (seconds < 3600) {
                        readable = (seconds / 60).toFixed(1) + ' minutos';
                    } else if (seconds < 86400) {
                        readable = (seconds / 3600).toFixed(1) + ' horas';
                    } else {
                        readable = (seconds / 86400).toFixed(1) + ' días';
                    }
                    
                    // Actualizar el display
                    const currentValue = this.parentNode.querySelector('.current-value');
                    if (currentValue) {
                        currentValue.textContent = `Nuevo: ${seconds} segundos (${readable})`;
                    }
                });
            });

            // Validación de formulario
            const form = document.querySelector('form');
            form.addEventListener('submit', function(e) {
                let valid = true;
                const required = this.querySelectorAll('[required]');
                
                required.forEach(field => {
                    if (!field.value.trim()) {
                        valid = false;
                        field.style.borderColor = 'var(--danger)';
                    } else {
                        field.style.borderColor = '';
                    }
                });

                if (!valid) {
                    e.preventDefault();
                    alert('Por favor, completa todos los campos obligatorios.');
                }
            });
        });
    </script>
