<?php if (!function_exists('avatar_img')) { @include_once '../../helpers.php'; } ?>


<!-- Restored Admin Styles -->
<style>

        :root {
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --secondary: #6c757d;
            --success: #28a745;
            --danger: #dc3545;
            --warning: #ffc107;
            --info: #17a2b8;
            --light: #f8f9fa;
            --dark: #343a40;
            --bg-main: #f5f7f9;
            --bg-card: #ffffff;
            --text-main: #212529;
            --text-muted: #6c757d;
            --border: #dee2e6;
            --radius: 8px;
            --radius-sm: 4px;
            --shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background-color: var(--bg-main);
            color: var(--text-main);
            line-height: 1.6;
            padding: 20px;
        }

        .admin-container {
            max-width: 1400px;
            margin: 0 auto;
        }

        .admin-header {
            margin-bottom: 24px;
        }

        .admin-header h1 {
            font-size: 28px;
            font-weight: 700;
            color: var(--dark);
            margin-bottom: 8px;
        }

        .admin-header p {
            color: var(--text-muted);
            font-size: 16px;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .stat-card {
            background: var(--bg-card);
            border-radius: var(--radius);
            padding: 20px;
            box-shadow: var(--shadow);
            transition: var(--transition);
            text-align: center;
        }

        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
        }

        .stat-icon {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            margin: 0 auto 15px;
        }

        .stat-icon.pending {
            background: rgba(255, 193, 7, 0.1);
            color: var(--warning);
        }

        .stat-icon.today {
            background: rgba(23, 162, 184, 0.1);
            color: var(--info);
        }

        .stat-icon.resolved {
            background: rgba(40, 167, 69, 0.1);
            color: var(--success);
        }

        .stat-icon.total {
            background: rgba(108, 117, 125, 0.1);
            color: var(--secondary);
        }

        .stat-value {
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 8px;
            color: var(--dark);
        }

        .stat-label {
            font-size: 14px;
            color: var(--text-muted);
        }

        .filters-card {
            background: var(--bg-card);
            border-radius: var(--radius);
            padding: 20px;
            box-shadow: var(--shadow);
            margin-bottom: 24px;
        }

        .filters-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        .filters-title {
            font-size: 18px;
            font-weight: 600;
        }

        .filters-form {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
        }

        .form-group {
            margin-bottom: 15px;
        }

        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: var(--text-muted);
            font-size: 14px;
        }

        .form-control {
            width: 100%;
            padding: 10px 12px;
            border: 1px solid var(--border);
            border-radius: var(--radius-sm);
            font-size: 14px;
            transition: var(--transition);
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.2);
        }

        .btn {
            padding: 10px 16px;
            border-radius: var(--radius-sm);
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            border: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
        }

        .btn-secondary {
            background: var(--secondary);
            color: white;
        }

        .btn-secondary:hover {
            background: #5a6268;
        }

        .btn-success {
            background: var(--success);
            color: white;
        }

        .btn-success:hover {
            background: #218838;
        }

        .btn-danger {
            background: var(--danger);
            color: white;
        }

        .btn-danger:hover {
            background: #c82333;
        }

        .btn-warning {
            background: var(--warning);
            color: var(--dark);
        }

        .btn-warning:hover {
            background: #e0a800;
        }

        .btn-sm {
            padding: 6px 12px;
            font-size: 12px;
        }

        .reports-table {
            width: 100%;
            border-collapse: collapse;
            background: var(--bg-card);
            border-radius: var(--radius);
            overflow: hidden;
            box-shadow: var(--shadow);
        }

        .reports-table th,
        .reports-table td {
            padding: 16px;
            text-align: left;
            border-bottom: 1px solid var(--border);
        }

        .reports-table th {
            background-color: #f8f9fa;
            font-weight: 600;
            color: var(--text-muted);
            font-size: 14px;
        }

        .reports-table tr:last-child td {
            border-bottom: none;
        }

        .reports-table tr:hover {
            background-color: #f8f9fa;
        }

        .badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            display: inline-block;
        }

        .badge-pending {
            background: rgba(255, 193, 7, 0.1);
            color: var(--warning);
        }

        .badge-resolved {
            background: rgba(40, 167, 69, 0.1);
            color: var(--success);
        }

        .badge-dismissed {
            background: rgba(108, 117, 125, 0.1);
            color: var(--secondary);
        }

        .badge-investigating {
            background: rgba(23, 162, 184, 0.1);
            color: var(--info);
        }

        .type-badge {
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 11px;
            font-weight: 600;
            text-transform: uppercase;
        }

        .type-user {
            background: rgba(67, 97, 238, 0.1);
            color: var(--primary);
        }

        .type-post {
            background: rgba(40, 167, 69, 0.1);
            color: var(--success);
        }

        .type-comment {
            background: rgba(255, 193, 7, 0.1);
            color: var(--warning);
        }

        .action-buttons {
            display: flex;
            gap: 8px;
            flex-wrap: wrap;
        }

        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 30px;
            gap: 8px;
        }

        .page-item {
            display: inline-flex;
        }

        .page-link {
            padding: 8px 12px;
            border: 1px solid var(--border);
            border-radius: var(--radius-sm);
            color: var(--primary);
            text-decoration: none;
            transition: var(--transition);
        }

        .page-link:hover {
            background: var(--primary);
            color: white;
            border-color: var(--primary);
        }

        .page-item.active .page-link {
            background: var(--primary);
            color: white;
            border-color: var(--primary);
        }

        .page-item.disabled .page-link {
            color: var(--text-muted);
            pointer-events: none;
            background: var(--light);
        }

        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: var(--text-muted);
        }

        .empty-state i {
            font-size: 48px;
            margin-bottom: 16px;
            opacity: 0.5;
        }

        .empty-state p {
            margin-bottom: 20px;
        }

        /* Modal styles */
        .modal-backdrop {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 1000;
            padding: 20px;
        }

        .modal {
            background: var(--bg-card);
            border-radius: var(--radius);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            width: 100%;
            max-width: 600px;
            max-height: 90vh;
            overflow-y: auto;
        }

        .modal-header {
            padding: 20px;
            border-bottom: 1px solid var(--border);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .modal-title {
            font-size: 18px;
            font-weight: 600;
        }

        .modal-close {
            background: none;
            border: none;
            font-size: 20px;
            cursor: pointer;
            color: var(--text-muted);
        }

        .modal-body {
            padding: 20px;
        }

        .modal-footer {
            padding: 20px;
            border-top: 1px solid var(--border);
            display: flex;
            justify-content: flex-end;
            gap: 10px;
        }

        .form-textarea {
            width: 100%;
            padding: 12px;
            border: 1px solid var(--border);
            border-radius: var(--radius-sm);
            font-size: 14px;
            resize: vertical;
            min-height: 100px;
            font-family: inherit;
        }

        .form-textarea:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.2);
        }

        /* Responsive */
        @media (max-width: 992px) {
            .reports-table {
                display: block;
                overflow-x: auto;
            }
            
            .filters-form {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 768px) {
            .stats-grid {
                grid-template-columns: repeat(2, 1fr);
            }
            
            .action-buttons {
                flex-direction: column;
            }
        }

        @media (max-width: 576px) {
            .stats-grid {
                grid-template-columns: 1fr;
            }
            
            .pagination {
                flex-wrap: wrap;
            }
        }
    
</style>
<div class="admin-container">
        <div class="admin-header">
            <h1><?= h($pageTitle) ?></h1>
            <p><?= h($pageSubtitle) ?></p>
        </div>

        <!-- Estadísticas de reportes -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon pending">
                    <i class="fas fa-flag"></i>
                </div>
                <div class="stat-value"><?= h($pending_count) ?></div>
                <div class="stat-label">Pendientes</div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon today">
                    <i class="fas fa-calendar-day"></i>
                </div>
                <div class="stat-value"><?= h($today_count) ?></div>
                <div class="stat-label">Hoy</div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon resolved">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="stat-value"><?= h($resolved_week_count) ?></div>
                <div class="stat-label">Resueltos (7 días)</div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon total">
                    <i class="fas fa-database"></i>
                </div>
                <div class="stat-value"><?= h($totalReports) ?></div>
                <div class="stat-label">Total de Reportes</div>
            </div>
        </div>

        <!-- Filtros -->
        <div class="filters-card">
            <div class="filters-header">
                <div class="filters-title">Filtros y Búsqueda</div>
            </div>
            
            <form method="GET" action="./?r=admin/reports" class="filters-form">
                <input type="hidden" name="r" value="admin/reports">
                
                <div class="form-group">
                    <label class="form-label">Estado</label>
                    <select name="status" class="form-control">
                        <option value="">Todos los estados</option>
                        <option value="pending" <?= isset($filters['status']) && $filters['status'] === 'pending' ? 'selected' : '' ?>>Pendiente</option>
                        <option value="resolved" <?= isset($filters['status']) && $filters['status'] === 'resolved' ? 'selected' : '' ?>>Resuelto</option>
                        <option value="dismissed" <?= isset($filters['status']) && $filters['status'] === 'dismissed' ? 'selected' : '' ?>>Desestimado</option>
                        <option value="investigating" <?= isset($filters['status']) && $filters['status'] === 'investigating' ? 'selected' : '' ?>>En investigación</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Tipo</label>
                    <select name="type" class="form-control">
                        <option value="">Todos los tipos</option>
                        <option value="user" <?= isset($filters['type']) && $filters['type'] === 'user' ? 'selected' : '' ?>>Usuario</option>
                        <option value="post" <?= isset($filters['type']) && $filters['type'] === 'post' ? 'selected' : '' ?>>Publicación</option>
                        <option value="comment" <?= isset($filters['type']) && $filters['type'] === 'comment' ? 'selected' : '' ?>>Comentario</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Motivo</label>
                    <select name="reason" class="form-control">
                        <option value="">Todos los motivos</option>
                        <option value="spam" <?= isset($filters['reason']) && $filters['reason'] === 'spam' ? 'selected' : '' ?>>Spam</option>
                        <option value="harassment" <?= isset($filters['reason']) && $filters['reason'] === 'harassment' ? 'selected' : '' ?>>Acoso</option>
                        <option value="inappropriate" <?= isset($filters['reason']) && $filters['reason'] === 'inappropriate' ? 'selected' : '' ?>>Contenido inapropiado</option>
                        <option value="copyright" <?= isset($filters['reason']) && $filters['reason'] === 'copyright' ? 'selected' : '' ?>>Violación de copyright</option>
                        <option value="other" <?= isset($filters['reason']) && $filters['reason'] === 'other' ? 'selected' : '' ?>>Otro</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Búsqueda</label>
                    <input type="text" name="q" class="form-control" placeholder="ID, usuario..." value="<?= isset($filters['q']) ? h($filters['q']) : '' ?>">
                </div>
                
                <div class="form-group" style="display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-filter"></i> Aplicar Filtros
                    </button>
                    <a href="./?r=admin/reports" class="btn btn-secondary" style="margin-left: 10px;">
                        <i class="fas fa-times"></i> Limpiar
                    </a>
                </div>
            </form>
        </div>

        <!-- Tabla de reportes -->
        <div class="card">
            <div class="card-header" style="display: flex; justify-content: space-between; align-items: center; padding: 20px; border-bottom: 1px solid var(--border);">
                <h3 style="margin: 0;">Lista de Reportes</h3>
                <div style="font-size: 14px; color: var(--text-muted);">
                    Mostrando <?= count($reports) ?> de <?= $totalReports ?> reportes
                </div>
            </div>
            
            <?php if (!empty($reports)): ?>
            <table class="reports-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Reportador</th>
                        <th>Tipo</th>
                        <th>Motivo</th>
                        <th>Estado</th>
                        <th>Fecha</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($reports as $report): ?>
                    <tr>
                        <td>#<?= h($report['id']) ?></td>
                        <td>
                            <div style="font-weight: 500;"><?= h($report['reporter_username'] ?? 'Usuario eliminado') ?></div>
                            <div style="font-size: 12px; color: var(--text-muted);">ID: <?= h($report['reporter_id']) ?></div>
                        </td>
                        <td>
                            <span class="type-badge type-<?= h($report['target_type']) ?>">
                                <?= h($report['target_type']) ?>
                            </span>
                        </td>
                        <td>
                            <div style="font-weight: 500;"><?= h(ucfirst($report['reason'])) ?></div>
                            <?php if (!empty($report['notes'])): ?>
                            <div style="font-size: 12px; color: var(--text-muted); margin-top: 4px;">
                                <?= h(limit_text($report['notes'], 50)) ?>
                            </div>
                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="badge badge-<?= h($report['status']) ?>">
                                <?= h(ucfirst($report['status'])) ?>
                            </span>
                        </td>
                        <td>
                            <div style="font-size: 14px;"><?= h(fdt($report['created_at'], 'd/m/Y')) ?></div>
                            <div style="font-size: 12px; color: var(--text-muted);"><?= h(fdt($report['created_at'], 'H:i')) ?></div>
                        </td>
                        <td>
                            <div class="action-buttons">
                                <a href="./?r=admin/report-detail&id=<?= h($report['id']) ?>" class="btn btn-primary btn-sm">
                                    <i class="fas fa-eye"></i> Ver
                                </a>
                                
                                <?php if ($report['status'] === 'pending'): ?>
                                <button class="btn btn-success btn-sm resolve-btn" data-id="<?= h($report['id']) ?>">
                                    <i class="fas fa-check"></i> Resolver
                                </button>
                                <?php endif; ?>
                                
                                <button class="btn btn-warning btn-sm update-btn" data-id="<?= h($report['id']) ?>" data-status="<?= h($report['status']) ?>">
                                    <i class="fas fa-edit"></i> Editar
                                </button>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php else: ?>
            <div class="empty-state">
                <i class="fas fa-flag"></i>
                <p>No se encontraron reportes</p>
                <a href="./?r=admin/reports" class="btn btn-primary">
                    <i class="fas fa-refresh"></i> Recargar
                </a>
            </div>
            <?php endif; ?>
        </div>

        <!-- Paginación -->
        <?php if ($pagination['totalPages'] > 1): ?>
        <div class="pagination">
            <?php if ($pagination['page'] > 1): ?>
            <div class="page-item">
                <a class="page-link" href="?r=admin/reports&page=<?= $pagination['page'] - 1 ?><?= !empty($queryString) ? '&' . $queryString : '' ?>">
                    <i class="fas fa-chevron-left"></i>
                </a>
            </div>
            <?php endif; ?>
            
            <?php for ($i = 1; $i <= $pagination['totalPages']; $i++): ?>
            <div class="page-item <?= $i == $pagination['page'] ? 'active' : '' ?>">
                <a class="page-link" href="?r=admin/reports&page=<?= $i ?><?= !empty($queryString) ? '&' . $queryString : '' ?>"><?= $i ?></a>
            </div>
            <?php endfor; ?>
            
            <?php if ($pagination['page'] < $pagination['totalPages']): ?>
            <div class="page-item">
                <a class="page-link" href="?r=admin/reports&page=<?= $pagination['page'] + 1 ?><?= !empty($queryString) ? '&' . $queryString : '' ?>">
                    <i class="fas fa-chevron-right"></i>
                </a>
            </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    </div>

    <!-- Modal para actualizar reporte -->
    <div id="updateModal" class="modal-backdrop" style="display: none;">
        <div class="modal">
            <div class="modal-header">
                <h3 class="modal-title">Actualizar Reporte</h3>
                <button class="modal-close" id="closeModal">&times;</button>
            </div>
            <form id="updateForm" method="POST" action="./?r=admin/update-report">
<?= csrf_field() ?>

                <div class="modal-body">
                    <input type="hidden" name="report_id" id="reportId">
                    
                    <div class="form-group">
                        <label class="form-label">Estado</label>
                        <select name="status" id="reportStatus" class="form-control" required>
                            <option value="pending">Pendiente</option>
                            <option value="resolved">Resuelto</option>
                            <option value="dismissed">Desestimado</option>
                            <option value="investigating">En investigación</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">Notas</label>
                        <textarea name="notes" class="form-textarea" placeholder="Agregar notas sobre este reporte..."></textarea>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">Motivo de la acción <span style="color: var(--danger);">*</span></label>
                        <textarea name="reason" class="form-textarea" placeholder="Explicar por qué se toma esta acción..." required></textarea>
                        <div style="font-size: 12px; color: var(--text-muted); margin-top: 5px;">
                            Este motivo se registrará en los logs de seguridad.
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" id="cancelUpdate">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar Cambios</button>
                </div>
            </form>
        </div>
    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Modal functionality
        const updateModal = document.getElementById('updateModal');
        const updateButtons = document.querySelectorAll('.update-btn, .resolve-btn');
        const closeModal = document.getElementById('closeModal');
        const cancelUpdate = document.getElementById('cancelUpdate');
        const reportIdInput = document.getElementById('reportId');
        const reportStatusSelect = document.getElementById('reportStatus');
        const updateForm = document.getElementById('updateForm');
        
        // Open modal
        updateButtons.forEach(button => {
            button.addEventListener('click', function() {
                const reportId = this.getAttribute('data-id');
                const currentStatus = this.getAttribute('data-status') || 'pending';
                
                reportIdInput.value = reportId;
                reportStatusSelect.value = this.classList.contains('resolve-btn') ? 'resolved' : currentStatus;
                
                // Disable status field for resolve button
                if (this.classList.contains('resolve-btn')) {
                    reportStatusSelect.disabled = true;
                } else {
                    reportStatusSelect.disabled = false;
                }
                
                updateModal.style.display = 'flex';
            });
        });
        
        // Close modal
        function closeUpdateModal() {
            updateModal.style.display = 'none';
            reportStatusSelect.disabled = false;
        }
        
        closeModal.addEventListener('click', closeUpdateModal);
        cancelUpdate.addEventListener('click', closeUpdateModal);
        
        // Close modal when clicking outside
        updateModal.addEventListener('click', function(e) {
            if (e.target === updateModal) {
                closeUpdateModal();
            }
        });
        
        // Form submission
        updateForm.addEventListener('submit', function(e) {
            const reasonField = this.querySelector('textarea[name="reason"]');
            if (!reasonField.value.trim()) {
                e.preventDefault();
                alert('Por favor, ingresa un motivo para esta acción.');
                reasonField.focus();
            }
        });
        
        // Filter form persistence
        const filterForm = document.querySelector('.filters-form');
        const filterSelects = filterForm.querySelectorAll('select');
        
        // Store current filters in session storage for persistence
        filterSelects.forEach(select => {
            select.addEventListener('change', function() {
                sessionStorage.setItem(`reportFilter_${this.name}`, this.value);
            });
            
            // Restore values if available
            const savedValue = sessionStorage.getItem(`reportFilter_${this.name}`);
            if (savedValue !== null) {
                this.value = savedValue;
            }
        });
        
        const searchInput = filterForm.querySelector('input[name="q"]');
        const savedSearch = sessionStorage.getItem('reportFilter_q');
        if (savedSearch !== null) {
            searchInput.value = savedSearch;
        }
        
        searchInput.addEventListener('input', function() {
            sessionStorage.setItem('reportFilter_q', this.value);
        });
    });
    </script>
