<?php if (!function_exists('avatar_img')) { @include_once '../../helpers.php'; } ?>


<!-- Restored Admin Styles -->
<style>

        :root {
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --secondary: #6c757d;
            --success: #28a745;
            --danger: #dc3545;
            --warning: #ffc107;
            --info: #17a2b8;
            --light: #f8f9fa;
            --dark: #343a40;
            --bg-main: #f5f7f9;
            --bg-card: #ffffff;
            --text-main: #212529;
            --text-muted: #6c757d;
            --border: #dee2e6;
            --radius: 12px;
            --radius-sm: 8px;
            --shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
        }

        body {
            background-color: var(--bg-main);
            color: var(--text-main);
            line-height: 1.6;
            padding: 20px;
            min-height: 100vh;
        }

        .admin-container {
            max-width: 1400px;
            margin: 0 auto;
        }

        .admin-header {
            margin-bottom: 32px;
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            flex-wrap: wrap;
            gap: 16px;
            padding: 24px;
            background: var(--bg-card);
            border-radius: var(--radius);
            box-shadow: var(--shadow);
            border-left: 4px solid var(--primary);
        }

        .admin-header-content h1 {
            font-size: 28px;
            font-weight: 700;
            color: var(--dark);
            margin-bottom: 8px;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .admin-header-content p {
            color: var(--text-muted);
            font-size: 16px;
            max-width: 600px;
        }

        .report-id {
            background: var(--primary);
            color: white;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: 600;
        }

        .header-actions {
            display: flex;
            gap: 12px;
            flex-wrap: wrap;
        }

        .btn {
            padding: 12px 20px;
            border-radius: var(--radius-sm);
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            border: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            text-decoration: none;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
        }

        .btn-success {
            background: var(--success);
            color: white;
        }

        .btn-success:hover {
            background: #218838;
            transform: translateY(-2px);
        }

        .btn-warning {
            background: var(--warning);
            color: var(--dark);
        }

        .btn-warning:hover {
            background: #e0a800;
            transform: translateY(-2px);
        }

        .btn-danger {
            background: var(--danger);
            color: white;
        }

        .btn-danger:hover {
            background: #c82333;
            transform: translateY(-2px);
        }

        .btn-secondary {
            background: var(--secondary);
            color: white;
        }

        .btn-secondary:hover {
            background: #5a6268;
            transform: translateY(-2px);
        }

        .btn-sm {
            padding: 8px 16px;
            font-size: 13px;
        }

        .back-link {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 12px 20px;
            background: var(--bg-card);
            border: 2px solid var(--border);
            border-radius: var(--radius-sm);
            color: var(--text-main);
            text-decoration: none;
            font-weight: 600;
            transition: var(--transition);
        }

        .back-link:hover {
            background: #f8f9fa;
            border-color: var(--primary);
            color: var(--primary);
        }

        .detail-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 24px;
            margin-bottom: 40px;
        }

        @media (max-width: 1200px) {
            .detail-grid {
                grid-template-columns: 1fr;
            }
        }

        .card {
            background: var(--bg-card);
            border-radius: var(--radius);
            padding: 24px;
            box-shadow: var(--shadow);
            position: relative;
            overflow: hidden;
            border: 1px solid var(--border);
        }

        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 16px;
            border-bottom: 2px solid var(--border);
            flex-wrap: wrap;
            gap: 16px;
        }

        .card-title {
            font-size: 20px;
            font-weight: 700;
            display: flex;
            align-items: center;
            gap: 12px;
            color: var(--dark);
        }

        .badge {
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 13px;
            font-weight: 700;
            display: inline-block;
        }

        .badge-pending {
            background: var(--warning);
            color: white;
        }

        .badge-resolved {
            background: var(--success);
            color: white;
        }

        .badge-dismissed {
            background: var(--secondary);
            color: white;
        }

        .badge-investigating {
            background: var(--info);
            color: white;
        }

        .type-badge {
            padding: 6px 12px;
            border-radius: 6px;
            font-size: 12px;
            font-weight: 700;
            text-transform: uppercase;
        }

        .type-user {
            background: rgba(67, 97, 238, 0.15);
            color: var(--primary);
            border: 1px solid rgba(67, 97, 238, 0.3);
        }

        .type-post {
            background: rgba(40, 167, 69, 0.15);
            color: var(--success);
            border: 1px solid rgba(40, 167, 69, 0.3);
        }

        .type-comment {
            background: rgba(255, 193, 7, 0.15);
            color: var(--warning);
            border: 1px solid rgba(255, 193, 7, 0.3);
        }

        .info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 20px;
        }

        .info-item {
            margin-bottom: 16px;
        }

        .info-label {
            font-size: 13px;
            color: var(--text-muted);
            text-transform: uppercase;
            font-weight: 700;
            margin-bottom: 6px;
            display: block;
        }

        .info-value {
            font-size: 16px;
            font-weight: 600;
            color: var(--dark);
            word-break: break-word;
        }

        .content-box {
            background: #f8f9fa;
            border-radius: var(--radius-sm);
            padding: 20px;
            margin: 20px 0;
            border-left: 4px solid var(--primary);
        }

        .content-box h4 {
            margin-bottom: 12px;
            font-size: 15px;
            color: var(--text-muted);
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .content-text {
            line-height: 1.6;
            white-space: pre-wrap;
            word-break: break-word;
            font-size: 15px;
            background: white;
            padding: 16px;
            border-radius: 8px;
            border: 1px solid var(--border);
            max-height: 200px;
            overflow-y: auto;
        }

        .image-gallery {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
            gap: 12px;
            margin-top: 16px;
        }

        .image-item {
            border-radius: var(--radius-sm);
            overflow: hidden;
            position: relative;
            aspect-ratio: 1/1;
            cursor: pointer;
            border: 2px solid transparent;
            transition: var(--transition);
        }

        .image-item:hover {
            border-color: var(--primary);
            transform: scale(1.05);
        }

        .image-item img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .action-buttons {
            display: flex;
            gap: 12px;
            flex-wrap: wrap;
            margin-top: 24px;
            padding-top: 20px;
            border-top: 2px solid var(--border);
        }

        .quick-actions {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 16px;
            margin: 20px 0;
        }

        .quick-action {
            padding: 16px;
            background: #f8f9fa;
            border-radius: var(--radius-sm);
            border: 2px solid transparent;
            text-align: center;
            cursor: pointer;
            transition: var(--transition);
        }

        .quick-action:hover {
            border-color: var(--primary);
            transform: translateY(-2px);
        }

        .quick-action i {
            font-size: 24px;
            margin-bottom: 8px;
            color: var(--primary);
        }

        .quick-action span {
            font-weight: 600;
            color: var(--dark);
        }

        .history-list {
            list-style: none;
        }

        .history-item {
            padding: 20px;
            border-left: 4px solid var(--border);
            margin-bottom: 16px;
            background: #f8f9fa;
            border-radius: 0 var(--radius-sm) var(--radius-sm) 0;
            position: relative;
            transition: var(--transition);
        }

        .history-item:hover {
            background: #e9ecef;
            transform: translateX(4px);
        }

        .history-item:before {
            content: '';
            position: absolute;
            left: -8px;
            top: 24px;
            width: 16px;
            height: 16px;
            border-radius: 50%;
            background: var(--secondary);
            border: 3px solid var(--bg-card);
        }

        .history-item.high:before { background: var(--danger); }
        .history-item.medium:before { background: var(--warning); }
        .history-item.low:before { background: var(--info); }

        .history-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 12px;
            flex-wrap: wrap;
            gap: 12px;
        }

        .history-action {
            font-weight: 700;
            font-size: 15px;
            color: var(--dark);
        }

        .history-time {
            font-size: 13px;
            color: var(--text-muted);
            font-weight: 600;
        }

        .history-details {
            font-size: 15px;
            margin-bottom: 12px;
            word-break: break-word;
            line-height: 1.5;
        }

        .history-reason {
            padding: 12px;
            background: white;
            border-radius: var(--radius-sm);
            font-size: 14px;
            border-left: 4px solid var(--primary);
            margin-top: 12px;
            word-break: break-word;
        }

        .empty-state {
            text-align: center;
            padding: 40px 20px;
            color: var(--text-muted);
        }

        .empty-state i {
            font-size: 48px;
            margin-bottom: 16px;
            opacity: 0.5;
        }

        .user-info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
            gap: 16px;
            margin: 20px 0;
        }

        .user-stat {
            text-align: center;
            padding: 20px 12px;
            background: #f8f9fa;
            border-radius: var(--radius-sm);
            border: 2px solid transparent;
            transition: var(--transition);
        }

        .user-stat:hover {
            border-color: var(--primary);
            transform: translateY(-2px);
        }

        .user-stat-value {
            font-size: 28px;
            font-weight: 800;
            color: var(--primary);
            margin-bottom: 6px;
        }

        .user-stat-label {
            font-size: 12px;
            color: var(--text-muted);
            text-transform: uppercase;
            font-weight: 700;
        }

        /* Modal styles */
        .modal-backdrop {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.7);
            display: none;
            align-items: center;
            justify-content: center;
            z-index: 10000;
            padding: 20px;
            backdrop-filter: blur(5px);
        }

        .modal-backdrop.active {
            display: flex;
        }

        .modal {
            background: var(--bg-card);
            border-radius: var(--radius);
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            width: 100%;
            max-width: 600px;
            max-height: 90vh;
            overflow-y: auto;
            animation: modalSlideIn 0.3s ease;
        }

        @keyframes modalSlideIn {
            from {
                opacity: 0;
                transform: translateY(-50px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .modal-header {
            padding: 24px;
            border-bottom: 2px solid var(--border);
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: #f8f9fa;
            border-radius: var(--radius) var(--radius) 0 0;
        }

        .modal-title {
            font-size: 20px;
            font-weight: 700;
            color: var(--dark);
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .modal-close {
            background: none;
            border: none;
            font-size: 24px;
            cursor: pointer;
            color: var(--text-muted);
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: var(--transition);
        }

        .modal-close:hover {
            background: var(--light);
            color: var(--danger);
        }

        .modal-body {
            padding: 24px;
        }

        .modal-footer {
            padding: 24px;
            border-top: 2px solid var(--border);
            display: flex;
            justify-content: flex-end;
            gap: 16px;
            background: #f8f9fa;
            border-radius: 0 0 var(--radius) var(--radius);
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: var(--text-muted);
            font-size: 14px;
        }

        .form-control {
            width: 100%;
            padding: 12px 16px;
            border: 2px solid var(--border);
            border-radius: var(--radius-sm);
            font-size: 15px;
            transition: var(--transition);
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.1);
        }

        .form-textarea {
            width: 100%;
            padding: 16px;
            border: 2px solid var(--border);
            border-radius: var(--radius-sm);
            font-size: 15px;
            resize: vertical;
            min-height: 120px;
            font-family: inherit;
            line-height: 1.5;
        }

        .form-textarea:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.1);
        }

        .image-modal {
            max-width: 90vw;
            max-height: 90vh;
            background: black;
            border-radius: 12px;
            overflow: hidden;
        }

        .image-modal img {
            width: 100%;
            height: auto;
            display: block;
            max-height: 80vh;
            object-fit: contain;
        }

        @media (max-width: 768px) {
            .admin-header {
                flex-direction: column;
                text-align: center;
            }
            
            .header-actions {
                width: 100%;
                justify-content: center;
            }
            
            .action-buttons {
                flex-direction: column;
            }
            
            .info-grid {
                grid-template-columns: 1fr;
            }
            
            .modal-footer {
                flex-direction: column;
            }
            
            .quick-actions {
                grid-template-columns: 1fr;
            }
        }
    
</style>
<div class="admin-container">
        <!-- Header Principal -->
        <div class="admin-header">
            <div class="admin-header-content">
                <h1>
                    <i class="fas fa-flag"></i>
                    <?= h($pageTitle) ?>
                    <span class="report-id">#<?= h($report['id']) ?></span>
                </h1>
                <p><?= h($pageSubtitle) ?></p>
            </div>
            <div class="header-actions">
                <a href="./?r=admin/reports" class="back-link">
                    <i class="fas fa-arrow-left"></i> Volver a reportes
                </a>
                <button class="btn btn-primary" id="updateStatusBtn">
                    <i class="fas fa-edit"></i> Actualizar Estado
                </button>
            </div>
        </div>

        <div class="detail-grid">
            <!-- Información del Reporte -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-info-circle"></i> Información del Reporte
                        <span class="type-badge type-<?= h($report['target_type']) ?>">
                            <?= h($report['target_type']) ?>
                        </span>
                    </h3>
                    <span class="badge badge-<?= h($report['status']) ?>">
                        <?= h(ucfirst($report['status'])) ?>
                    </span>
                </div>

                <div class="info-grid">
                    <div class="info-item">
                        <span class="info-label">ID del Reporte</span>
                        <div class="info-value">#<?= h($report['id']) ?></div>
                    </div>

                    <div class="info-item">
                        <span class="info-label">Fecha de Creación</span>
                        <div class="info-value"><?= h(fdt($report['created_at'], 'd/m/Y H:i')) ?></div>
                    </div>

                    <div class="info-item">
                        <span class="info-label">Estado Actual</span>
                        <div class="info-value">
                            <span class="badge badge-<?= h($report['status']) ?>">
                                <?= h(ucfirst($report['status'])) ?>
                            </span>
                        </div>
                    </div>

                    <div class="info-item">
                        <span class="info-label">Motivo del Reporte</span>
                        <div class="info-value"><?= h(ucfirst($report['reason'])) ?></div>
                    </div>
                </div>

                <?php if (!empty($report['description'])): ?>
                <div class="content-box">
                    <h4><i class="fas fa-comment"></i> Descripción del Reporte</h4>
                    <div class="content-text"><?= h($report['description']) ?></div>
                </div>
                <?php endif; ?>

                <!-- Acciones Rápidas -->
                <div class="quick-actions">
                    <div class="quick-action" data-action="resolved">
                        <i class="fas fa-check-circle"></i>
                        <span>Marcar como Resuelto</span>
                    </div>
                    <div class="quick-action" data-action="investigating">
                        <i class="fas fa-search"></i>
                        <span>En Investigación</span>
                    </div>
                    <div class="quick-action" data-action="dismissed">
                        <i class="fas fa-times-circle"></i>
                        <span>Desestimar Reporte</span>
                    </div>
                </div>
            </div>

            <!-- Información del Reportador -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-user"></i> Información del Reportador</h3>
                </div>

                <div class="info-grid">
                    <div class="info-item">
                        <span class="info-label">Usuario</span>
                        <div class="info-value">
                            <i class="fas fa-user"></i> <?= h($report['reporter_username']) ?>
                        </div>
                    </div>

                    <div class="info-item">
                        <span class="info-label">Email</span>
                        <div class="info-value">
                            <i class="fas fa-envelope"></i> <?= h($report['reporter_email']) ?>
                        </div>
                    </div>

                    <div class="info-item">
                        <span class="info-label">ID de Usuario</span>
                        <div class="info-value">#<?= h($report['reporter_id']) ?></div>
                    </div>
                </div>

                <div class="action-buttons">
                    <!-- ENLACES CORREGIDOS -->
                    <a href="./?r=admin/users&q=<?= urlencode($report['reporter_username']) ?>" class="btn btn-primary btn-sm">
                        <i class="fas fa-search"></i> Ver en Usuarios
                    </a>
                    <a href="./?r=profile/friend&id=<?= h($report['reporter_id']) ?>" class="btn btn-secondary btn-sm" target="_blank">
                        <i class="fas fa-eye"></i> Ver Perfil
                    </a>
                </div>
            </div>

            <!-- Contenido Reportado -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-file-alt"></i> Contenido Reportado
                        <span class="type-badge type-<?= h($report['target_type']) ?>">
                            <?= h(ucfirst($report['target_type'])) ?>
                        </span>
                    </h3>
                </div>

                <div class="content-box">
                    <h4><i class="fas fa-align-left"></i> Contenido Reportado</h4>
                    <div class="content-text"><?= h($reported_content) ?></div>
                </div>

                <?php if ($report['target_type'] === 'post' && !empty($images)): ?>
                <div class="info-item">
                    <span class="info-label">Imágenes adjuntas (<?= count($images) ?>)</span>
                    <div class="image-gallery">
                        <?php foreach ($images as $image): ?>
                        <div class="image-item" data-image="<?= h($image['url']) ?>">
                            <img src="<?= h(media_url($image['url'])) ?>" alt="Imagen del post" loading="lazy">
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endif; ?>

                <div class="action-buttons">
                    <?php if ($report['target_type'] === 'post'): ?>
                    <!-- ENLACE CORREGIDO -->
                    <a href="./?r=posts/view&id=<?= h($report['target_id']) ?>" class="btn btn-primary btn-sm" target="_blank">
                        <i class="fas fa-external-link-alt"></i> Ver Publicación
                    </a>
                    <button class="btn btn-danger btn-sm action-btn" data-action="delete_post" data-id="<?= h($report['target_id']) ?>">
                        <i class="fas fa-trash"></i> Eliminar Post
                    </button>
                    
                    <?php elseif ($report['target_type'] === 'user'): ?>
                    <!-- ENLACE CORREGIDO -->
                    <a href="./?r=profile/friend&id=<?= h($report['target_id']) ?>" class="btn btn-primary btn-sm" target="_blank">
                        <i class="fas fa-external-link-alt"></i> Ver Perfil
                    </a>
                    <button class="btn btn-warning btn-sm action-btn" data-action="warn_user" data-id="<?= h($report['target_id']) ?>">
                        <i class="fas fa-exclamation-triangle"></i> Advertir Usuario
                    </button>
                    <button class="btn btn-danger btn-sm action-btn" data-action="block_user" data-id="<?= h($report['target_id']) ?>">
                        <i class="fas fa-ban"></i> Bloquear Usuario
                    </button>
                    
                    <?php elseif ($report['target_type'] === 'comment'): ?>
                    <?php if ($comment_post_id): ?>
                    <!-- ENLACE CORREGIDO -->
                    <a href="./?r=posts/view&id=<?= h($comment_post_id) ?>#comment-<?= h($report['target_id']) ?>" class="btn btn-primary btn-sm" target="_blank">
                        <i class="fas fa-external-link-alt"></i> Ver Comentario
                    </a>
                    <?php endif; ?>
                    <button class="btn btn-danger btn-sm action-btn" data-action="delete_comment" data-id="<?= h($report['target_id']) ?>">
                        <i class="fas fa-trash"></i> Eliminar Comentario
                    </button>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Historial del Reporte -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-history"></i> Historial del Reporte</h3>
                </div>

                <?php if (!empty($history)): ?>
                <ul class="history-list">
                    <?php foreach ($history as $entry): ?>
                    <li class="history-item <?= $entry['severity'] ?? 'medium' ?>">
                        <div class="history-header">
                            <span class="history-action"><?= h(ucfirst(str_replace('_', ' ', $entry['action']))) ?></span>
                            <span class="history-time"><?= h(fdt($entry['created_at'], 'd/m/Y H:i')) ?></span>
                        </div>
                        <div class="history-details">
                            <strong>Por:</strong> <?= h($entry['admin_username'] ?? 'Sistema') ?>
                            <br><strong>Detalles:</strong> <?= h($entry['details']) ?>
                        </div>
                        <?php if (!empty($entry['admin_reason'])): ?>
                        <div class="history-reason">
                            <strong>Motivo:</strong> <?= h($entry['admin_reason']) ?>
                        </div>
                        <?php endif; ?>
                    </li>
                    <?php endforeach; ?>
                </ul>
                <?php else: ?>
                <div class="empty-state">
                    <i class="fas fa-history"></i>
                    <p>No hay historial disponible para este reporte</p>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Modal para actualizar estado -->
    <div class="modal-backdrop" id="updateModal">
        <div class="modal">
            <div class="modal-header">
                <h3 class="modal-title">
                    <i class="fas fa-edit"></i> Actualizar Estado del Reporte
                </h3>
                <button class="modal-close" id="closeUpdateModal">&times;</button>
            </div>
            <form method="POST" action="./?r=admin/update-report-status" id="updateForm">
<?= csrf_field() ?>

                <input type="hidden" name="report_id" value="<?= h($report['id']) ?>">
                
                <div class="modal-body">
                    <div class="form-group">
                        <label class="form-label" for="status">Nuevo Estado</label>
                        <select class="form-control" id="status" name="status" required>
                            <option value="">Seleccionar estado...</option>
                            <option value="pending" <?= $report['status'] === 'pending' ? 'selected' : '' ?>>Pendiente</option>
                            <option value="investigating" <?= $report['status'] === 'investigating' ? 'selected' : '' ?>>En Investigación</option>
                            <option value="resolved" <?= $report['status'] === 'resolved' ? 'selected' : '' ?>>Resuelto</option>
                            <option value="dismissed" <?= $report['status'] === 'dismissed' ? 'selected' : '' ?>>Desestimado</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label class="form-label" for="notes">Notas (Opcional)</label>
                        <textarea class="form-textarea" id="notes" name="notes" placeholder="Agregar notas sobre la actualización del estado..."><?= h($report['notes'] ?? '') ?></textarea>
                    </div>

                    <div class="form-group">
                        <label class="form-label">
                            <input type="checkbox" name="notify_reporter" value="1" checked> 
                            Notificar al reportador del cambio
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" id="cancelUpdate">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Actualizar Estado</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Modal para ver imagen -->
    <div class="modal-backdrop" id="imageModal">
        <div class="modal image-modal">
            <div class="modal-header">
                <h3 class="modal-title">
                    <i class="fas fa-image"></i> Vista Previa de Imagen
                </h3>
                <button class="modal-close" id="closeImageModal">&times;</button>
            </div>
            <div class="modal-body">
                <img id="modalImage" src="" alt="Imagen ampliada">
            </div>
        </div>
    </div>

    <!-- Modal para acciones -->
    <div class="modal-backdrop" id="actionModal">
        <div class="modal">
            <div class="modal-header">
                <h3 class="modal-title" id="actionModalTitle">
                    <i class="fas fa-cog"></i> Confirmar Acción
                </h3>
                <button class="modal-close" id="closeActionModal">&times;</button>
            </div>
            <form method="POST" action="./?r=admin/take-action" id="actionForm">
<?= csrf_field() ?>

                <input type="hidden" name="report_id" value="<?= h($report['id']) ?>">
                <input type="hidden" name="action" id="actionType">
                <input type="hidden" name="target_id" id="actionTargetId">
                <input type="hidden" name="target_type" value="<?= h($report['target_type']) ?>">
                
                <div class="modal-body">
                    <div class="form-group">
                        <label class="form-label" for="actionReason">Motivo de la acción</label>
                        <textarea class="form-textarea" id="actionReason" name="reason" placeholder="Explicar por qué se toma esta acción..." required></textarea>
                    </div>
                    <p id="actionWarning" style="color: var(--danger); font-weight: 600; display: none;">
                        <i class="fas fa-exclamation-triangle"></i> Esta acción no se puede deshacer
                    </p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" id="cancelAction">Cancelar</button>
                    <button type="submit" class="btn btn-danger" id="confirmAction">Confirmar</button>
                </div>
            </form>
        </div>
    </div>

    <script>
        // === MODALES ===
        const updateModal = document.getElementById('updateModal');
        const imageModal = document.getElementById('imageModal');
        const actionModal = document.getElementById('actionModal');
        
        // === FUNCIONES PARA ABRIR/CERRAR MODALES ===
        function openModal(modal) {
            modal.classList.add('active');
            document.body.style.overflow = 'hidden';
        }

        function closeModal(modal) {
            modal.classList.remove('active');
            document.body.style.overflow = 'auto';
        }

        function openUpdateModal(status = '') {
            if (status) {
                document.getElementById('status').value = status;
            }
            openModal(updateModal);
        }

        function openActionModal(action, targetId, targetType) {
            const actionTitles = {
                'delete_post': 'Eliminar Publicación',
                'delete_comment': 'Eliminar Comentario', 
                'warn_user': 'Advertir Usuario',
                'block_user': 'Bloquear Usuario'
            };
            
            const actionDescriptions = {
                'delete_post': '¿Estás seguro de eliminar esta publicación?',
                'delete_comment': '¿Estás seguro de eliminar este comentario?',
                'warn_user': '¿Estás seguro de advertir a este usuario?',
                'block_user': '¿Estás seguro de bloquear a este usuario?'
            };
            
            document.getElementById('actionModalTitle').innerHTML = 
                `<i class="fas fa-${action.includes('delete') ? 'trash' : 'exclamation-triangle'}"></i> ${actionTitles[action]}`;
            
            document.getElementById('actionType').value = action;
            document.getElementById('actionTargetId').value = targetId;
            
            const warning = document.getElementById('actionWarning');
            if (action.includes('delete') || action === 'block_user') {
                warning.style.display = 'block';
            } else {
                warning.style.display = 'none';
            }
            
            openModal(actionModal);
        }

        // === EVENT LISTENERS ===
        document.addEventListener('DOMContentLoaded', function() {
            console.log('✅ Report Detail cargado - Inicializando eventos');
            
            // Botón principal de actualización
            document.getElementById('updateStatusBtn').addEventListener('click', function() {
                openUpdateModal();
            });

            // Acciones rápidas
            document.querySelectorAll('.quick-action').forEach(action => {
                action.addEventListener('click', function() {
                    const status = this.getAttribute('data-action');
                    openUpdateModal(status);
                });
            });

            // Botones de acción específicos
            document.querySelectorAll('.action-btn').forEach(btn => {
                btn.addEventListener('click', function() {
                    const action = this.getAttribute('data-action');
                    const targetId = this.getAttribute('data-id');
                    openActionModal(action, targetId, '<?= h($report['target_type']) ?>');
                });
            });

            // Imágenes
            document.querySelectorAll('.image-item').forEach(item => {
                item.addEventListener('click', function() {
                    const imageUrl = this.getAttribute('data-image');
                    document.getElementById('modalImage').src = imageUrl;
                    openModal(imageModal);
                });
            });

            // Cerrar modales
            document.getElementById('closeUpdateModal').addEventListener('click', () => closeModal(updateModal));
            document.getElementById('closeImageModal').addEventListener('click', () => closeModal(imageModal));
            document.getElementById('closeActionModal').addEventListener('click', () => closeModal(actionModal));
            document.getElementById('cancelUpdate').addEventListener('click', () => closeModal(updateModal));
            document.getElementById('cancelAction').addEventListener('click', () => closeModal(actionModal));

            // Cerrar modales al hacer clic fuera
            document.addEventListener('click', function(e) {
                if (e.target === updateModal) closeModal(updateModal);
                if (e.target === imageModal) closeModal(imageModal);
                if (e.target === actionModal) closeModal(actionModal);
            });

            // Cerrar con Escape
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    closeModal(updateModal);
                    closeModal(imageModal);
                    closeModal(actionModal);
                }
            });

            // Validación de formularios
            document.getElementById('updateForm').addEventListener('submit', function(e) {
                const status = this.querySelector('#status').value;
                if (!status) {
                    e.preventDefault();
                    alert('Por favor, selecciona un estado');
                    return false;
                }
            });

            document.getElementById('actionForm').addEventListener('submit', function(e) {
                const reason = this.querySelector('#actionReason').value.trim();
                if (!reason) {
                    e.preventDefault();
                    alert('Por favor, ingresa un motivo para esta acción');
                    return false;
                }
            });

            // Efectos hover en tarjetas
            document.querySelectorAll('.card').forEach(card => {
                card.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-4px)';
                    this.style.boxShadow = '0 8px 25px rgba(0, 0, 0, 0.15)';
                });
                
                card.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0)';
                    this.style.boxShadow = 'var(--shadow)';
                });
            });

            console.log('✅ Todos los eventos inicializados correctamente');
        });

        // Función de debug para verificar que los eventos están funcionando
        function debugEvents() {
            console.log('🔍 Debug de eventos:');
            console.log('📊 Botones de acción:', document.querySelectorAll('.action-btn').length);
            console.log('⚡ Acciones rápidas:', document.querySelectorAll('.quick-action').length);
            console.log('🖼️ Imágenes:', document.querySelectorAll('.image-item').length);
            console.log('✅ Modales cargados correctamente');
        }

        // Ejecutar debug después de 1 segundo
        setTimeout(debugEvents, 1000);
    </script>
