<?php if (!function_exists('avatar_img')) { @include_once '../../helpers.php'; } ?>

<!-- Restored Admin Styles -->
<style>

        :root {
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --secondary: #6c757d;
            --success: #28a745;
            --danger: #dc3545;
            --warning: #ffc107;
            --info: #17a2b8;
            --light: #f8f9fa;
            --dark: #343a40;
            --bg-main: #f5f7f9;
            --bg-card: #ffffff;
            --text-main: #212529;
            --text-muted: #6c757d;
            --border: #dee2e6;
            --radius: 8px;
            --radius-sm: 4px;
            --shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background-color: var(--bg-main);
            color: var(--text-main);
            line-height: 1.6;
            padding: 20px;
        }

        .admin-container {
            max-width: 1400px;
            margin: 0 auto;
        }

        .admin-header {
            display: flex;
            align-items: center;
            margin-bottom: 24px;
            gap: 16px;
        }

        .back-button {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: var(--bg-card);
            color: var(--primary);
            border: 1px solid var(--border);
            cursor: pointer;
            transition: var(--transition);
            text-decoration: none;
        }

        .back-button:hover {
            background: var(--primary);
            color: white;
        }

        .admin-header h1 {
            font-size: 28px;
            font-weight: 700;
            color: var(--dark);
            margin-bottom: 0;
        }

        .admin-header p {
            color: var(--text-muted);
            font-size: 16px;
        }

        .admin-stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .stat-card {
            background: var(--bg-card);
            border-radius: var(--radius);
            padding: 20px;
            box-shadow: var(--shadow);
            transition: var(--transition);
        }

        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
        }

        .stat-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 16px;
        }

        .stat-title {
            font-size: 14px;
            font-weight: 600;
            color: var(--text-muted);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .stat-icon {
            width: 48px;
            height: 48px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
        }

        .stat-icon.posts {
            background: rgba(67, 97, 238, 0.1);
            color: var(--primary);
        }

        .stat-icon.likes {
            background: rgba(220, 53, 69, 0.1);
            color: var(--danger);
        }

        .stat-icon.comments {
            background: rgba(23, 162, 184, 0.1);
            color: var(--info);
        }

        .stat-icon.reports {
            background: rgba(255, 193, 7, 0.1);
            color: var(--warning);
        }

        .stat-value {
            font-size: 32px;
            font-weight: 700;
            margin-bottom: 12px;
            color: var(--dark);
        }

        .stat-desc {
            font-size: 14px;
            color: var(--text-muted);
            margin-bottom: 16px;
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .trend {
            font-size: 12px;
            font-weight: 600;
            padding: 4px 8px;
            border-radius: 20px;
            display: inline-flex;
            align-items: center;
            gap: 4px;
        }

        .trend.positive {
            background: rgba(40, 199, 111, 0.2);
            color: #28c76f;
        }

        .trend.negative {
            background: rgba(255, 77, 77, 0.2);
            color: #ff4d4d;
        }

        .filters {
            background: var(--bg-card);
            border-radius: var(--radius);
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: var(--shadow);
        }

        .filter-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-bottom: 15px;
        }

        .filter-group {
            display: flex;
            flex-direction: column;
        }

        .filter-label {
            font-size: 14px;
            font-weight: 600;
            margin-bottom: 8px;
            color: var(--text-muted);
        }

        .filter-input, .filter-select {
            padding: 10px 12px;
            border: 1px solid var(--border);
            border-radius: var(--radius-sm);
            font-size: 14px;
            transition: var(--transition);
        }

        .filter-input:focus, .filter-select:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.1);
        }

        .filter-actions {
            display: flex;
            gap: 10px;
            justify-content: flex-end;
        }

        .btn-sm {
            padding: 8px 16px;
            font-size: 14px;
            border-radius: var(--radius-sm);
            cursor: pointer;
            transition: var(--transition);
        }

        .btn-primary {
            background: var(--primary);
            color: white;
            border: none;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
        }

        .btn-outline {
            background: transparent;
            border: 1px solid var(--border);
            color: var(--text-muted);
        }

        .btn-outline:hover {
            background: var(--bg-main);
        }

        .posts-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .post-card {
            background: var(--bg-card);
            border-radius: var(--radius);
            overflow: hidden;
            box-shadow: var(--shadow);
            transition: var(--transition);
        }

        .post-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.15);
        }

        .post-image {
            width: 100%;
            height: 200px;
            object-fit: cover;
            border-bottom: 1px solid var(--border);
        }

        .post-content {
            padding: 16px;
        }

        .post-author {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 12px;
        }

        .author-avatar {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 14px;
        }

        .author-name {
            font-weight: 600;
            font-size: 14px;
        }

        .post-date {
            font-size: 12px;
            color: var(--text-muted);
        }

        .post-caption {
            margin-bottom: 16px;
            line-height: 1.5;
        }

        .post-stats {
            display: flex;
            gap: 16px;
            margin-bottom: 16px;
            padding-bottom: 16px;
            border-bottom: 1px solid var(--border);
        }

        .stat {
            display: flex;
            align-items: center;
            gap: 6px;
            font-size: 14px;
            color: var(--text-muted);
        }

        .post-actions {
            display: flex;
            gap: 8px;
        }

        .btn-icon {
            flex: 1;
            padding: 8px 12px;
            border-radius: var(--radius-sm);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 6px;
            cursor: pointer;
            transition: var(--transition);
            font-size: 14px;
            font-weight: 500;
        }

        .btn-view {
            background: rgba(23, 162, 184, 0.1);
            color: var(--info);
            border: 1px solid rgba(23, 162, 184, 0.2);
        }

        .btn-view:hover {
            background: rgba(23, 162, 184, 0.2);
        }

        .btn-delete {
            background: rgba(220, 53, 69, 0.1);
            color: var(--danger);
            border: 1px solid rgba(220, 53, 69, 0.2);
        }

        .btn-delete:hover {
            background: rgba(220, 53, 69, 0.2);
        }

        .pagination {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 12px;
            margin-top: 20px;
        }

        .pagination-info {
            font-size: 14px;
            color: var(--text-muted);
        }

        .pagination-button {
            padding: 8px 16px;
            border: 1px solid var(--border);
            border-radius: var(--radius-sm);
            background: var(--bg-card);
            color: var(--text-main);
            cursor: pointer;
            transition: var(--transition);
        }

        .pagination-button:hover:not(:disabled) {
            background: var(--bg-main);
        }

        .pagination-button:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }

        .pagination-active {
            background: var(--primary);
            color: white;
            border-color: var(--primary);
        }

        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 1000;
            align-items: center;
            justify-content: center;
        }

        .modal-content {
            background: var(--bg-card);
            border-radius: var(--radius);
            width: 100%;
            max-width: 500px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
            overflow: hidden;
        }

        .modal-header {
            padding: 20px;
            border-bottom: 1px solid var(--border);
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: var(--bg-main);
        }

        .modal-title {
            font-size: 18px;
            font-weight: 600;
        }

        .modal-close {
            background: none;
            border: none;
            font-size: 20px;
            cursor: pointer;
            color: var(--text-muted);
        }

        .modal-body {
            padding: 20px;
        }

        .modal-form-group {
            margin-bottom: 16px;
        }

        .modal-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            font-size: 14px;
        }

        .modal-textarea {
            width: 100%;
            padding: 10px 12px;
            border: 1px solid var(--border);
            border-radius: var(--radius-sm);
            font-size: 14px;
            transition: var(--transition);
            min-height: 100px;
            resize: vertical;
        }

        .modal-textarea:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.1);
        }

        .modal-footer {
            padding: 20px;
            border-top: 1px solid var(--border);
            display: flex;
            justify-content: flex-end;
            gap: 12px;
            background: var(--bg-main);
        }

        .empty-state {
            grid-column: 1 / -1;
            text-align: center;
            padding: 60px 20px;
            color: var(--text-muted);
        }

        .empty-state i {
            font-size: 48px;
            margin-bottom: 16px;
            opacity: 0.5;
        }

        /* Responsive */
        @media (max-width: 1024px) {
            .posts-grid {
                grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            }
            
            .filter-row {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 768px) {
            .admin-stats {
                grid-template-columns: 1fr 1fr;
            }
            
            .posts-grid {
                grid-template-columns: 1fr;
            }
            
            .admin-header {
                flex-direction: column;
                align-items: flex-start;
                gap: 10px;
            }
            
            .modal-content {
                margin: 20px;
                width: calc(100% - 40px);
            }
            
            .post-actions {
                flex-direction: column;
            }
        }

        @media (max-width: 480px) {
            .admin-stats {
                grid-template-columns: 1fr;
            }
            
            .post-stats {
                flex-wrap: wrap;
            }
        }
    
</style>
<?php
// src/views/admin/posts.php
?>


<div class="admin-container">
        <div class="admin-header">
            <a href="./?r=admin/dashboard" class="back-button" title="Volver al dashboard">
                <i class="fas fa-arrow-left"></i>
            </a>
            <div>
                <h1>Gestión de Publicaciones</h1>
                <p>Administra y modera las publicaciones del sistema</p>
            </div>
        </div>

        <div class="admin-stats">
            <div class="stat-card">
                <div class="stat-header">
                    <div class="stat-title">Publicaciones Totales</div>
                    <div class="stat-icon posts">
                        <i class="fas fa-image"></i>
                    </div>
                </div>
                <div class="stat-value"><?= h($stats['total_posts']) ?></div>
                <div class="stat-desc">
                    <span class="trend positive"><i class="fas fa-arrow-up"></i> 8%</span>
                    vs semana anterior
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-header">
                    <div class="stat-title">Likes Totales</div>
                    <div class="stat-icon likes">
                        <i class="fas fa-heart"></i>
                    </div>
                </div>
                <div class="stat-value"><?= h($totalLikes ?? 0) ?></div>
                <div class="stat-desc">
                    <span class="trend positive"><i class="fas fa-arrow-up"></i> 12%</span>
                    interacciones
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-header">
                    <div class="stat-title">Comentarios</div>
                    <div class="stat-icon comments">
                        <i class="fas fa-comment"></i>
                    </div>
                </div>
                <div class="stat-value"><?= h($stats['total_comments']) ?></div>
                <div class="stat-desc">
                    <span class="trend positive"><i class="fas fa-arrow-up"></i> 15%</span>
                    esta semana
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-header">
                    <div class="stat-title">Reportes Pendientes</div>
                    <div class="stat-icon reports">
                        <i class="fas fa-flag"></i>
                    </div>
                </div>
                <div class="stat-value"><?= h($stats['pending_reports']) ?></div>
                <div class="stat-desc">
                    <span class="trend <?= $stats['pending_reports'] > 0 ? 'negative' : 'positive' ?>">
                        <i class="fas fa-arrow-<?= $stats['pending_reports'] > 0 ? 'up' : 'down' ?>"></i>
                        <?= $stats['pending_reports'] > 0 ? '5%' : '0%' ?>
                    </span>
                    necesita revisión
                </div>
            </div>
        </div>

        <div class="filters">
            <form method="GET" action="./?r=admin/posts">
                <input type="hidden" name="r" value="admin/posts">
                
                <div class="filter-row">
                    <div class="filter-group">
                        <label class="filter-label">Buscar por autor</label>
                        <input type="text" name="author" class="filter-input" placeholder="Nombre de usuario" value="<?= h($_GET['author'] ?? '') ?>">
                    </div>
                    
                    <div class="filter-group">
                        <label class="filter-label">Ordenar por</label>
                        <select name="sort" class="filter-select">
                            <option value="newest" <?= (!empty($_GET['sort']) && $_GET['sort'] === 'newest') ? 'selected' : '' ?>>Más recientes</option>
                            <option value="oldest" <?= (!empty($_GET['sort']) && $_GET['sort'] === 'oldest') ? 'selected' : '' ?>>Más antiguos</option>
                            <option value="popular" <?= (!empty($_GET['sort']) && $_GET['sort'] === 'popular') ? 'selected' : '' ?>>Más populares</option>
                        </select>
                    </div>
                    
                    <div class="filter-group">
                        <label class="filter-label">Posts por página</label>
                        <select name="limit" class="filter-select">
                            <option value="12" <?= (!empty($_GET['limit']) && $_GET['limit'] == 12) ? 'selected' : '' ?>>12</option>
                            <option value="24" <?= (!empty($_GET['limit']) && $_GET['limit'] == 24) ? 'selected' : '' ?>>24</option>
                            <option value="48" <?= (!empty($_GET['limit']) && $_GET['limit'] == 48) ? 'selected' : '' ?>>48</option>
                        </select>
                    </div>
                </div>
                
                <div class="filter-actions">
                    <button type="submit" class="btn-sm btn-primary">
                        <i class="fas fa-filter"></i> Aplicar Filtros
                    </button>
                    <a href="./?r=admin/posts" class="btn-sm btn-outline">
                        <i class="fas fa-times"></i> Limpiar
                    </a>
                </div>
            </form>
        </div>

        <div class="posts-grid">
            <?php if (!empty($posts)): ?>
                <?php foreach ($posts as $post): ?>
                <div class="post-card">
                    <?php if (!empty($post['image_url'])): ?>
                    <img src="<?= h(media_url($post['image_url'])) ?>" alt="Post image" class="post-image" onerror="this.style.display='none'">
                    <?php else: ?>
                    <div class="post-image" style="background: #f0f0f0; display: flex; align-items: center; justify-content: center;">
                        <i class="fas fa-image" style="font-size: 48px; color: #ccc;"></i>
                    </div>
                    <?php endif; ?>
                    
                    <div class="post-content">
                        <div class="post-author">
                            <div class="author-avatar" style="overflow:hidden;border-radius:50%;padding:0;background:none;">
                                <?= strtoupper(substr($post['username'], 0, 1)) ?>
                            </div>
                            <div>
                                <div class="author-name"><?= h($post['username']) ?></div>
                                <div class="post-date"><?= h(fdt_madrid($post['created_at'], 'd/m/Y H:i')) ?></div>
                            </div>
                        </div>
                        
                        <?php if (!empty($post['caption'])): ?>
                        <div class="post-caption">
                            <?= h(limit_text($post['caption'], 100)) ?>
                        </div>
                        <?php endif; ?>
                        
                        <div class="post-stats">
                            <div class="stat">
                                <i class="fas fa-heart"></i>
                                <span><?= h($post['likes_count'] ?? 0) ?> likes</span>
                            </div>
                            <div class="stat">
                                <i class="fas fa-comment"></i>
                                <span><?= h($post['comments_count'] ?? 0) ?> comentarios</span>
                            </div>
                        </div>
                        
                        <div class="post-actions">
                            <button class="btn-icon btn-view" onclick="viewPost('<?= h($post['id']) ?>')">
                                <i class="fas fa-eye"></i> Ver
                            </button>
                            <button class="btn-icon btn-delete" onclick="deletePost('<?= h($post['id']) ?>', '<?= h($post['username']) ?>')">
                                <i class="fas fa-trash"></i> Eliminar
                            </button>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="empty-state">
                    <i class="fas fa-image"></i>
                    <h3>No hay publicaciones</h3>
                    <p>No se encontraron publicaciones con los filtros aplicados.</p>
                </div>
            <?php endif; ?>
        </div>

        <div class="pagination">
            <button class="pagination-button" <?= $pagination['page'] <= 1 ? 'disabled' : '' ?> onclick="changePage(<?= $pagination['page'] - 1 ?>)">
                <i class="fas fa-chevron-left"></i> Anterior
            </button>
            
            <span class="pagination-info">
                Página <?= $pagination['page'] ?> de <?= $pagination['totalPages'] ?>
            </span>
            
            <button class="pagination-button" <?= $pagination['page'] >= $pagination['totalPages'] ? 'disabled' : '' ?> onclick="changePage(<?= $pagination['page'] + 1 ?>)">
                Siguiente <i class="fas fa-chevron-right"></i>
            </button>
        </div>
    </div>

    <!-- Modal para eliminar post -->
    <div class="modal" id="deleteModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title">Eliminar Publicación</h3>
                <button class="modal-close" onclick="closeModal('deleteModal')">&times;</button>
            </div>
            <form method="POST" action="./?r=admin/delete-post">
<?= csrf_field() ?>

                <input type="hidden" name="post_id" id="deletePostId">
                
                <div class="modal-body">
                    <div class="modal-form-group">
                        <label class="modal-label">Autor</label>
                        <input type="text" id="deletePostAuthor" class="filter-input" readonly>
                    </div>
                    
                    <div class="modal-form-group">
                        <label class="modal-label">Motivo de eliminación (obligatorio)</label>
                        <textarea name="reason" class="modal-textarea" placeholder="Describe el motivo de la eliminación..." required></textarea>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn-sm btn-outline" onclick="closeModal('deleteModal')">Cancelar</button>
                    <button type="submit" class="btn-sm btn-danger">
                        <i class="fas fa-trash"></i> Confirmar Eliminación
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        function changePage(page) {
            const url = new URL(window.location.href);
            url.searchParams.set('page', page);
            window.location.href = url.toString();
        }
        
        function viewPost(postId) {
            window.open('./?r=posts/view&id=' + postId, '_blank');
        }
        
        function deletePost(postId, authorName) {
            document.getElementById('deletePostId').value = postId;
            document.getElementById('deletePostAuthor').value = authorName;
            document.getElementById('deleteModal').style.display = 'flex';
        }
        
        function closeModal(modalId) {
            document.getElementById(modalId).style.display = 'none';
        }
        
        // Cerrar modal al hacer clic fuera del contenido
        window.onclick = function(event) {
            const modals = document.getElementsByClassName('modal');
            for (let modal of modals) {
                if (event.target === modal) {
                    modal.style.display = 'none';
                }
            }
        };
    </script>
