<?php if (!function_exists('avatar_img')) { @include_once '../../../helpers.php'; } ?>


<!-- Restored Admin Styles -->
<style>

        :root {
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --secondary: #6c757d;
            --success: #28a745;
            --danger: #dc3545;
            --warning: #ffc107;
            --info: #17a2b8;
            --light: #f8f9fa;
            --dark: #343a40;
            --bg-main: #f5f7f9;
            --bg-card: #ffffff;
            --text-main: #212529;
            --text-muted: #6c757d;
            --border: #dee2e6;
            --radius: 12px;
            --radius-sm: 8px;
            --shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background-color: var(--bg-main);
            color: var(--text-main);
            line-height: 1.6;
            padding: 20px;
        }

        .policies-container {
            max-width: 1200px;
            margin: 0 auto;
        }

        .policies-header {
            background: var(--bg-card);
            border-radius: var(--radius);
            padding: 25px;
            margin-bottom: 24px;
            box-shadow: var(--shadow);
        }

        .policies-header h1 {
            font-size: 28px;
            font-weight: 700;
            color: var(--dark);
            margin-bottom: 8px;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .policies-header p {
            color: var(--text-muted);
            font-size: 16px;
        }

        .policy-tabs {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
            flex-wrap: wrap;
        }

        .policy-tab {
            padding: 12px 24px;
            background: var(--light);
            border: 1px solid var(--border);
            border-radius: var(--radius-sm);
            cursor: pointer;
            transition: var(--transition);
            font-weight: 500;
        }

        .policy-tab.active {
            background: var(--primary);
            color: white;
            border-color: var(--primary);
        }

        .policy-tab:hover:not(.active) {
            background: var(--bg-card);
        }

        .policy-content {
            display: none;
            background: var(--bg-card);
            border-radius: var(--radius);
            padding: 30px;
            box-shadow: var(--shadow);
            margin-bottom: 24px;
        }

        .policy-content.active {
            display: block;
        }

        .policy-title {
            font-size: 20px;
            font-weight: 600;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 2px solid var(--border);
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: var(--dark);
        }

        .form-control {
            width: 100%;
            padding: 12px 16px;
            border: 1px solid var(--border);
            border-radius: var(--radius-sm);
            font-size: 16px;
            transition: var(--transition);
            font-family: inherit;
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.1);
        }

        .form-textarea {
            min-height: 300px;
            resize: vertical;
        }

        .form-help {
            font-size: 0.85rem;
            color: var(--text-muted);
            margin-top: 5px;
        }

        .btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 12px 24px;
            border-radius: var(--radius-sm);
            text-decoration: none;
            font-weight: 600;
            transition: var(--transition);
            border: none;
            cursor: pointer;
            font-size: 16px;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
        }

        .btn-secondary {
            background: var(--secondary);
            color: white;
        }

        .btn-secondary:hover {
            background: #5a6268;
            transform: translateY(-2px);
        }

        .editor-toolbar {
            background: var(--light);
            padding: 10px;
            border: 1px solid var(--border);
            border-bottom: none;
            border-radius: var(--radius-sm) var(--radius-sm) 0 0;
            display: flex;
            gap: 5px;
            flex-wrap: wrap;
        }

        .editor-btn {
            padding: 8px 12px;
            background: white;
            border: 1px solid var(--border);
            border-radius: 4px;
            cursor: pointer;
            transition: var(--transition);
        }

        .editor-btn:hover {
            background: var(--primary);
            color: white;
            border-color: var(--primary);
        }

        .preview-section {
            background: var(--light);
            padding: 20px;
            border-radius: var(--radius-sm);
            margin-top: 20px;
            border: 1px solid var(--border);
        }

        .preview-section h4 {
            margin-bottom: 10px;
            color: var(--dark);
        }

        @media (max-width: 768px) {
            .policy-tabs {
                flex-direction: column;
            }
            
            .policy-tab {
                text-align: center;
            }
        }
    
</style>
<div class="policies-container">
        <!-- Header -->
        <div class="policies-header">
            <h1>
                <i class="fas fa-file-contract"></i>
                Gestión de Políticas del Sitio
            </h1>
            <p>Edita y actualiza los contenidos de las políticas legales de Thirty</p>
        </div>

        <form method="post">
            <?= csrf_field() ?>
            
            <!-- Tabs de Navegación -->
            <div class="policy-tabs">
                <div class="policy-tab active" data-tab="terms">Términos y Condiciones</div>
                <div class="policy-tab" data-tab="privacy">Política de Privacidad</div>
                <div class="policy-tab" data-tab="cookies">Política de Cookies</div>
                <div class="policy-tab" data-tab="guidelines">Guías de la Comunidad</div>
            </div>

            <!-- Términos y Condiciones -->
            <div class="policy-content active" id="terms-content">
                <div class="policy-title">
                    <i class="fas fa-file-contract"></i>
                    Términos y Condiciones
                </div>
                
                <div class="form-group">
                    <label class="form-label" for="terms_content">Contenido de Términos y Condiciones</label>
                    <div class="editor-toolbar">
                        <button type="button" class="editor-btn" onclick="formatText('terms_content', 'bold')"><i class="fas fa-bold"></i></button>
                        <button type="button" class="editor-btn" onclick="formatText('terms_content', 'italic')"><i class="fas fa-italic"></i></button>
                        <button type="button" class="editor-btn" onclick="formatText('terms_content', 'underline')"><i class="fas fa-underline"></i></button>
                        <button type="button" class="editor-btn" onclick="insertHeading('terms_content')"><i class="fas fa-heading"></i></button>
                        <button type="button" class="editor-btn" onclick="insertList('terms_content')"><i class="fas fa-list"></i></button>
                    </div>
                    <textarea class="form-control form-textarea" id="terms_content" name="terms_content" placeholder="Escribe aquí los términos y condiciones..."><?= h($policies['terms_content'] ?? '') ?></textarea>
                    <div class="form-help">
                        Usa HTML básico para formatear el texto. Los usuarios verán este contenido en la página pública de Términos y Condiciones.
                    </div>
                </div>

                <div class="preview-section">
                    <h4>Vista Previa:</h4>
                    <div id="terms-preview">
                        <?= $policies['terms_content'] ?: 'No hay contenido todavía. Los usuarios verán un texto por defecto.' ?>
                    </div>
                </div>
            </div>

            <!-- Política de Privacidad -->
            <div class="policy-content" id="privacy-content">
                <div class="policy-title">
                    <i class="fas fa-shield-alt"></i>
                    Política de Privacidad
                </div>
                
                <div class="form-group">
                    <label class="form-label" for="privacy_content">Contenido de Política de Privacidad</label>
                    <div class="editor-toolbar">
                        <button type="button" class="editor-btn" onclick="formatText('privacy_content', 'bold')"><i class="fas fa-bold"></i></button>
                        <button type="button" class="editor-btn" onclick="formatText('privacy_content', 'italic')"><i class="fas fa-italic"></i></button>
                        <button type="button" class="editor-btn" onclick="formatText('privacy_content', 'underline')"><i class="fas fa-underline"></i></button>
                        <button type="button" class="editor-btn" onclick="insertHeading('privacy_content')"><i class="fas fa-heading"></i></button>
                        <button type="button" class="editor-btn" onclick="insertList('privacy_content')"><i class="fas fa-list"></i></button>
                    </div>
                    <textarea class="form-control form-textarea" id="privacy_content" name="privacy_content" placeholder="Escribe aquí la política de privacidad..."><?= h($policies['privacy_content'] ?? '') ?></textarea>
                    <div class="form-help">
                        Describe cómo manejas la información de los usuarios, qué datos recopilas y cómo los proteges.
                    </div>
                </div>

                <div class="preview-section">
                    <h4>Vista Previa:</h4>
                    <div id="privacy-preview">
                        <?= $policies['privacy_content'] ?: 'No hay contenido todavía. Los usuarios verán un texto por defecto.' ?>
                    </div>
                </div>
            </div>

            <!-- Política de Cookies -->
            <div class="policy-content" id="cookies-content">
                <div class="policy-title">
                    <i class="fas fa-cookie-bite"></i>
                    Política de Cookies
                </div>
                
                <div class="form-group">
                    <label class="form-label" for="cookies_content">Contenido de Política de Cookies</label>
                    <div class="editor-toolbar">
                        <button type="button" class="editor-btn" onclick="formatText('cookies_content', 'bold')"><i class="fas fa-bold"></i></button>
                        <button type="button" class="editor-btn" onclick="formatText('cookies_content', 'italic')"><i class="fas fa-italic"></i></button>
                        <button type="button" class="editor-btn" onclick="formatText('cookies_content', 'underline')"><i class="fas fa-underline"></i></button>
                        <button type="button" class="editor-btn" onclick="insertHeading('cookies_content')"><i class="fas fa-heading"></i></button>
                        <button type="button" class="editor-btn" onclick="insertList('cookies_content')"><i class="fas fa-list"></i></button>
                    </div>
                    <textarea class="form-control form-textarea" id="cookies_content" name="cookies_content" placeholder="Escribe aquí la política de cookies..."><?= h($policies['cookies_content'] ?? '') ?></textarea>
                    <div class="form-help">
                        Explica qué cookies usas, para qué sirven y cómo los usuarios pueden gestionarlas.
                    </div>
                </div>

                <div class="preview-section">
                    <h4>Vista Previa:</h4>
                    <div id="cookies-preview">
                        <?= $policies['cookies_content'] ?: 'No hay contenido todavía. Los usuarios verán un texto por defecto.' ?>
                    </div>
                </div>
            </div>

            <!-- Guías de la Comunidad -->
            <div class="policy-content" id="guidelines-content">
                <div class="policy-title">
                    <i class="fas fa-users"></i>
                    Guías de la Comunidad
                </div>
                
                <div class="form-group">
                    <label class="form-label" for="community_guidelines">Contenido de Guías de la Comunidad</label>
                    <div class="editor-toolbar">
                        <button type="button" class="editor-btn" onclick="formatText('community_guidelines', 'bold')"><i class="fas fa-bold"></i></button>
                        <button type="button" class="editor-btn" onclick="formatText('community_guidelines', 'italic')"><i class="fas fa-italic"></i></button>
                        <button type="button" class="editor-btn" onclick="formatText('community_guidelines', 'underline')"><i class="fas fa-underline"></i></button>
                        <button type="button" class="editor-btn" onclick="insertHeading('community_guidelines')"><i class="fas fa-heading"></i></button>
                        <button type="button" class="editor-btn" onclick="insertList('community_guidelines')"><i class="fas fa-list"></i></button>
                    </div>
                    <textarea class="form-control form-textarea" id="community_guidelines" name="community_guidelines" placeholder="Escribe aquí las guías de la comunidad..."><?= h($policies['community_guidelines'] ?? '') ?></textarea>
                    <div class="form-help">
                        Establece las normas de conducta esperadas en la comunidad y las consecuencias por incumplirlas.
                    </div>
                </div>

                <div class="preview-section">
                    <h4>Vista Previa:</h4>
                    <div id="guidelines-preview">
                        <?= $policies['community_guidelines'] ?: 'No hay contenido todavía. Los usuarios verán un texto por defecto.' ?>
                    </div>
                </div>
            </div>

            <!-- Botones de Acción -->
            <div style="display: flex; gap: 15px; flex-wrap: wrap; margin-top: 30px;">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Guardar Todas las Políticas
                </button>
                <a href="./?r=admin/control-panel" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Volver al Panel
                </button>
                <button type="reset" class="btn btn-secondary">
                    <i class="fas fa-undo"></i> Restablecer Cambios
                </button>
            </div>
        </form>
    </div>

    <script>
        // Sistema de tabs
        document.addEventListener('DOMContentLoaded', function() {
            const tabs = document.querySelectorAll('.policy-tab');
            const contents = document.querySelectorAll('.policy-content');
            
            tabs.forEach(tab => {
                tab.addEventListener('click', function() {
                    const tabName = this.getAttribute('data-tab');
                    
                    // Remover active de todos
                    tabs.forEach(t => t.classList.remove('active'));
                    contents.forEach(c => c.classList.remove('active'));
                    
                    // Activar tab y contenido seleccionado
                    this.classList.add('active');
                    document.getElementById(tabName + '-content').classList.add('active');
                });
            });

            // Actualizar vistas previas en tiempo real
            const textareas = document.querySelectorAll('textarea');
            textareas.forEach(textarea => {
                textarea.addEventListener('input', function() {
                    const previewId = this.id + '-preview';
                    const previewElement = document.getElementById(previewId);
                    if (previewElement) {
                        previewElement.innerHTML = this.value || 'No hay contenido todavía. Los usuarios verán un texto por defecto.';
                    }
                });
            });
        });

        // Funciones básicas de formato
        function formatText(textareaId, format) {
            const textarea = document.getElementById(textareaId);
            const start = textarea.selectionStart;
            const end = textarea.selectionEnd;
            const selectedText = textarea.value.substring(start, end);
            
            let formattedText = '';
            switch(format) {
                case 'bold':
                    formattedText = `<strong>${selectedText}</strong>`;
                    break;
                case 'italic':
                    formattedText = `<em>${selectedText}</em>`;
                    break;
                case 'underline':
                    formattedText = `<u>${selectedText}</u>`;
                    break;
            }
            
            textarea.value = textarea.value.substring(0, start) + formattedText + textarea.value.substring(end);
            textarea.focus();
        }

        function insertHeading(textareaId) {
            const textarea = document.getElementById(textareaId);
            const start = textarea.selectionStart;
            textarea.value = textarea.value.substring(0, start) + '<h2>Título de Sección</h2>' + textarea.value.substring(start);
            textarea.focus();
        }

        function insertList(textareaId) {
            const textarea = document.getElementById(textareaId);
            const start = textarea.selectionStart;
            textarea.value = textarea.value.substring(0, start) + '<ul>\n<li>Elemento de lista</li>\n<li>Otro elemento</li>\n</ul>' + textarea.value.substring(start);
            textarea.focus();
        }
    </script>
