<?php if (!function_exists('avatar_img')) { @include_once '../../../helpers.php'; } ?>


<!-- Restored Admin Styles -->
<style>

        :root {
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --secondary: #6c757d;
            --success: #28a745;
            --danger: #dc3545;
            --warning: #ffc107;
            --info: #17a2b8;
            --light: #f8f9fa;
            --dark: #343a40;
            --bg-main: #f5f7f9;
            --bg-card: #ffffff;
            --text-main: #212529;
            --text-muted: #6c757d;
            --border: #dee2e6;
            --radius: 12px;
            --radius-sm: 8px;
            --shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }

        .maintenance-container {
            max-width: 800px;
            margin: 0 auto;
        }

        .status-card {
            background: white;
            border-radius: var(--radius);
            padding: 30px;
            margin-bottom: 24px;
            box-shadow: var(--shadow);
            text-align: center;
        }

        .status-icon {
            font-size: 4rem;
            margin-bottom: 20px;
        }

        .status-active {
            color: var(--danger);
        }

        .status-inactive {
            color: var(--success);
        }

        .status-title {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 10px;
        }

        .status-message {
            color: var(--text-muted);
            font-size: 1.1rem;
            margin-bottom: 20px;
        }

        .maintenance-card {
            background: white;
            border-radius: var(--radius);
            padding: 30px;
            margin-bottom: 24px;
            box-shadow: var(--shadow);
        }

        .card-title {
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: var(--dark);
        }

        .form-control {
            width: 100%;
            padding: 12px 16px;
            border: 1px solid var(--border);
            border-radius: var(--radius-sm);
            font-size: 16px;
            transition: var(--transition);
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.1);
        }

        .form-textarea {
            min-height: 120px;
            resize: vertical;
        }

        .btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 12px 24px;
            border-radius: var(--radius-sm);
            text-decoration: none;
            font-weight: 600;
            transition: var(--transition);
            border: none;
            cursor: pointer;
            font-size: 16px;
        }

        .btn-block {
            width: 100%;
            justify-content: center;
        }

        .btn-danger {
            background: var(--danger);
            color: white;
        }

        .btn-danger:hover {
            background: #c82333;
            transform: translateY(-2px);
        }

        .btn-success {
            background: var(--success);
            color: white;
        }

        .btn-success:hover {
            background: #218838;
            transform: translateY(-2px);
        }

        .btn-secondary {
            background: var(--secondary);
            color: white;
        }

        .btn-secondary:hover {
            background: #5a6268;
            transform: translateY(-2px);
        }

        .action-buttons {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
            margin-top: 20px;
        }

        @media (max-width: 768px) {
            .action-buttons {
                grid-template-columns: 1fr;
            }
            
            .status-title {
                font-size: 1.5rem;
            }
        }

        .maintenance-active {
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% { opacity: 1; }
            50% { opacity: 0.6; }
            100% { opacity: 1; }
        }

        .warning-box {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: var(--radius-sm);
            padding: 15px;
            margin-bottom: 20px;
        }

        .warning-box i {
            color: var(--warning);
            margin-right: 10px;
        }
    
</style>
<div class="maintenance-container">
        <!-- Estado Actual -->
        <div class="status-card">
            <?php if ($config['maintenance_mode']): ?>
                <div class="status-icon status-active maintenance-active">
                    <i class="fas fa-triangle-exclamation"></i>
                </div>
                <div class="status-title" style="color: var(--danger);">
                    MODO MANTENIMIENTO ACTIVO
                </div>
                <div class="status-message">
                    El sitio está actualmente en modo mantenimiento. Solo los administradores pueden acceder.
                </div>
                <?php if (!empty($config['maintenance_message'])): ?>
                    <div class="warning-box">
                        <i class="fas fa-exclamation-triangle"></i>
                        <strong>Mensaje actual:</strong> <?= h($config['maintenance_message']) ?>
                    </div>
                <?php endif; ?>
            <?php else: ?>
                <div class="status-icon status-inactive">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="status-title" style="color: var(--success);">
                    SITIO ACTIVO
                </div>
                <div class="status-message">
                    El sitio está funcionando normalmente. Todos los usuarios pueden acceder.
                </div>
            <?php endif; ?>
        </div>

        <!-- Activar Mantenimiento -->
        <div class="maintenance-card">
            <div class="card-title">
                <i class="fas fa-screwdriver-wrench"></i>
                Activar Modo Mantenimiento
            </div>
            
            <form method="post">
                <?= csrf_field() ?>
                <input type="hidden" name="action" value="enable">
                
                <div class="form-group">
                    <label class="form-label" for="maintenance_message">Mensaje de Mantenimiento</label>
                    <textarea class="form-control form-textarea" id="maintenance_message" name="maintenance_message" 
                              placeholder="Ej: Estamos realizando tareas de mantenimiento. Vuelve pronto..."><?= h($config['maintenance_message'] ?? '') ?></textarea>
                    <div style="font-size: 0.85rem; color: var(--text-muted); margin-top: 5px;">
                        Este mensaje se mostrará a los usuarios cuando intenten acceder al sitio.
                    </div>
                </div>

                <div class="warning-box">
                    <i class="fas fa-exclamation-triangle"></i>
                    <strong>Advertencia:</strong> Al activar el modo mantenimiento, todos los usuarios excepto los administradores serán redirigidos a una página de mantenimiento.
                </div>

                <button type="submit" class="btn btn-danger btn-block" 
                        <?= $config['maintenance_mode'] ? 'disabled' : '' ?>>
                    <i class="fas fa-power-off"></i>
                    <?= $config['maintenance_mode'] ? 'Mantenimiento Ya Activado' : 'Activar Modo Mantenimiento' ?>
                </button>
            </form>
        </div>

        <!-- Desactivar Mantenimiento -->
        <?php if ($config['maintenance_mode']): ?>
        <div class="maintenance-card">
            <div class="card-title">
                <i class="fas fa-play-circle"></i>
                Reanudar Sitio Normalmente
            </div>
            
            <form method="post">
                <?= csrf_field() ?>
                <input type="hidden" name="action" value="disable">
                
                <div class="warning-box" style="background: #d1ecf1; border-color: #bee5eb;">
                    <i class="fas fa-info-circle"></i>
                    Al desactivar el modo mantenimiento, el sitio volverá a estar disponible para todos los usuarios.
                </div>

                <button type="submit" class="btn btn-success btn-block">
                    <i class="fas fa-play"></i>
                    Desactivar Modo Mantenimiento
                </button>
            </form>
        </div>
        <?php endif; ?>

        <!-- Información Adicional -->
        <div class="maintenance-card">
            <div class="card-title">
                <i class="fas fa-info-circle"></i>
                Información del Modo Mantenimiento
            </div>
            
            <div style="line-height: 1.6;">
                <p><strong>¿Qué hace el modo mantenimiento?</strong></p>
                <ul style="margin-left: 20px; margin-bottom: 15px;">
                    <li>Redirige a los usuarios no administradores a una página de mantenimiento</li>
                    <li>Permite el acceso solo a usuarios con rol de administrador o moderador</li>
                    <li>Muestra un mensaje personalizado a los usuarios</li>
                    <li>Permite realizar tareas de mantenimiento sin interrupciones</li>
                </ul>

                <p><strong>Casos de uso recomendados:</strong></p>
                <ul style="margin-left: 20px;">
                    <li>Actualizaciones del sistema</li>
                    <li>Migraciones de base de datos</li>
                    <li>Resolución de problemas críticos</li>
                    <li>Implementación de nuevas características</li>
                </ul>
            </div>

            <div style="margin-top: 20px; text-align: center;">
                <a href="./?r=admin/control-panel" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Volver al Panel de Control
                </a>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Confirmación para acciones críticas
            const forms = document.querySelectorAll('form');
            forms.forEach(form => {
                form.addEventListener('submit', function(e) {
                    const action = this.querySelector('input[name="action"]').value;
                    let message = '';
                    
                    if (action === 'enable') {
                        message = '¿Estás seguro de que quieres activar el modo mantenimiento? Esto impedirá el acceso a todos los usuarios excepto administradores.';
                    } else if (action === 'disable') {
                        message = '¿Estás seguro de que quieres desactivar el modo mantenimiento? El sitio volverá a estar disponible para todos los usuarios.';
                    }
                    
                    if (message && !confirm(message)) {
                        e.preventDefault();
                    }
                });
            });

            // Actualizar estado en tiempo real
            function checkMaintenanceStatus() {
                // Podrías implementar AJAX aquí para verificar el estado en tiempo real
                console.log('Verificando estado de mantenimiento...');
            }

            // Verificar cada 10 segundos si está activo
            setInterval(checkMaintenanceStatus, 10000);
        });
    </script>
