<?php if (!function_exists('avatar_img')) { @include_once '../../helpers.php'; } ?>

<!-- Restored Admin Styles -->
<style>

        :root {
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --secondary: #6c757d;
            --success: #28a745;
            --danger: #dc3545;
            --warning: #ffc107;
            --info: #17a2b8;
            --light: #f8f9fa;
            --dark: #343a40;
            --bg-main: #f5f7f9;
            --bg-card: #ffffff;
            --text-main: #212529;
            --text-muted: #6c757d;
            --border: #dee2e6;
            --radius: 12px;
            --radius-sm: 8px;
            --shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            --shadow-lg: 0 8px 24px rgba(0, 0, 0, 0.12);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
        }

        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: var(--text-main);
            line-height: 1.6;
            min-height: 100vh;
            padding: 20px;
        }

        .admin-container {
            max-width: 1600px;
            margin: 0 auto;
        }

        .admin-header {
            display: flex;
            align-items: center;
            gap: 20px;
            margin-bottom: 30px;
            background: rgba(255, 255, 255, 0.95);
            padding: 25px;
            border-radius: var(--radius);
            box-shadow: var(--shadow-lg);
            backdrop-filter: blur(10px);
            border-left: 4px solid var(--warning);
        }

        .back-button {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: linear-gradient(135deg, #ffc107, #e0a800);
            color: white;
            border: none;
            cursor: pointer;
            transition: var(--transition);
            text-decoration: none;
            box-shadow: 0 4px 12px rgba(255, 193, 7, 0.4);
        }

        .back-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(255, 193, 7, 0.6);
        }

        .admin-header h1 {
            font-size: 32px;
            font-weight: 700;
            color: var(--dark);
            margin-bottom: 5px;
        }

        .admin-header p {
            color: var(--text-muted);
            font-size: 16px;
            margin: 0;
        }

        .admin-stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 24px;
            margin-bottom: 30px;
        }

        .stat-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: var(--radius);
            padding: 25px;
            box-shadow: var(--shadow);
            transition: var(--transition);
            border-left: 4px solid;
            position: relative;
            overflow: hidden;
            backdrop-filter: blur(10px);
        }

        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.8), transparent);
            opacity: 0;
            transition: var(--transition);
        }

        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: var(--shadow-lg);
            background: white;
        }

        .stat-card:hover::before {
            opacity: 1;
        }

        .stat-card.total { border-left-color: var(--info); }
        .stat-card.today { border-left-color: var(--success); }
        .stat-card.critical { border-left-color: var(--danger); }
        .stat-card.users { border-left-color: var(--primary); }

        .stat-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        .stat-title {
            font-size: 14px;
            font-weight: 600;
            color: var(--text-muted);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .stat-icon {
            width: 54px;
            height: 54px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 22px;
            color: white;
        }

        .stat-card.total .stat-icon { background: linear-gradient(135deg, var(--info), #138496); }
        .stat-card.today .stat-icon { background: linear-gradient(135deg, var(--success), #1e7e34); }
        .stat-card.critical .stat-icon { background: linear-gradient(135deg, var(--danger), #c82333); }
        .stat-card.users .stat-icon { background: linear-gradient(135deg, var(--primary), var(--primary-dark)); }

        .stat-value {
            font-size: 36px;
            font-weight: 800;
            margin-bottom: 10px;
            color: var(--dark);
        }

        .stat-desc {
            font-size: 14px;
            color: var(--text-muted);
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .trend {
            font-size: 12px;
            font-weight: 600;
            padding: 4px 10px;
            border-radius: 20px;
            display: inline-flex;
            align-items: center;
            gap: 4px;
        }

        .trend.positive {
            background: rgba(40, 199, 111, 0.15);
            color: #28c76f;
            border: 1px solid rgba(40, 199, 111, 0.3);
        }

        .trend.negative {
            background: rgba(255, 77, 77, 0.15);
            color: #ff4d4d;
            border: 1px solid rgba(255, 77, 77, 0.3);
        }

        .filters {
            background: rgba(255, 255, 255, 0.95);
            border-radius: var(--radius);
            padding: 25px;
            margin-bottom: 30px;
            box-shadow: var(--shadow);
            border: 1px solid rgba(255, 255, 255, 0.2);
            backdrop-filter: blur(10px);
        }

        .filter-form {
            display: flex;
            flex-direction: column;
            gap: 20px;
        }

        .filter-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
        }

        .filter-group {
            display: flex;
            flex-direction: column;
        }

        .filter-label {
            font-size: 14px;
            font-weight: 600;
            margin-bottom: 8px;
            color: var(--text-muted);
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .filter-input, .filter-select {
            padding: 12px 16px;
            border: 1px solid var(--border);
            border-radius: var(--radius-sm);
            font-size: 14px;
            transition: var(--transition);
            background: white;
        }

        .filter-input:focus, .filter-select:focus {
            outline: none;
            border-color: var(--warning);
            box-shadow: 0 0 0 3px rgba(255, 193, 7, 0.1);
            transform: translateY(-1px);
        }

        .filter-actions {
            display: flex;
            gap: 12px;
            justify-content: flex-end;
            padding-top: 10px;
            border-top: 1px solid var(--border);
        }

        .btn {
            padding: 12px 24px;
            border-radius: var(--radius-sm);
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            display: inline-flex;
            align-items: center;
            gap: 8px;
            border: none;
            text-decoration: none;
        }

        .btn-sm {
            padding: 10px 20px;
            font-size: 13px;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--warning), #e0a800);
            color: var(--dark);
            box-shadow: 0 4px 12px rgba(255, 193, 7, 0.3);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(255, 193, 7, 0.4);
        }

        .btn-outline {
            background: transparent;
            border: 1px solid var(--border);
            color: var(--text-muted);
        }

        .btn-outline:hover {
            background: var(--bg-main);
            border-color: var(--warning);
            color: var(--warning);
        }

        .table-container {
            background: rgba(255, 255, 255, 0.95);
            border-radius: var(--radius);
            overflow: hidden;
            box-shadow: var(--shadow-lg);
            margin-bottom: 30px;
            backdrop-filter: blur(10px);
        }

        .table-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 25px;
            border-bottom: 1px solid var(--border);
            background: linear-gradient(135deg, #f8f9fa, #e9ecef);
        }

        .table-title {
            display: flex;
            align-items: center;
            gap: 12px;
            font-size: 20px;
            font-weight: 600;
            color: var(--dark);
        }

        .badge {
            background: var(--warning);
            color: var(--dark);
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }

        .table-responsive {
            overflow-x: auto;
        }

        .data-table {
            width: 100%;
            border-collapse: collapse;
        }

        .data-table th {
            background: #f8f9fa;
            padding: 16px 20px;
            text-align: left;
            font-weight: 600;
            color: var(--text-muted);
            border-bottom: 1px solid var(--border);
            font-size: 13px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .data-table td {
            padding: 20px;
            border-bottom: 1px solid var(--border);
            vertical-align: top;
        }

        .data-table tr:hover {
            background: #f8f9fa;
        }

        .data-table tr:last-child td {
            border-bottom: none;
        }

        .user-cell {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .user-avatar {
            width: 42px;
            height: 42px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 16px;
            flex-shrink: 0;
        }

        .user-info-cell {
            display: flex;
            flex-direction: column;
        }

        .user-name {
            font-weight: 600;
            font-size: 14px;
            color: var(--dark);
        }

        .timestamp {
            font-family: 'Courier New', monospace;
            font-size: 13px;
            color: var(--text-muted);
            white-space: nowrap;
        }

        .action-badge {
            background: rgba(67, 97, 238, 0.1);
            color: var(--primary);
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 500;
            border: 1px solid rgba(67, 97, 238, 0.2);
            display: inline-block;
        }

        .severity-badge {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            border: 1px solid;
        }

        .severity-critical {
            background: rgba(220, 53, 69, 0.1);
            color: var(--danger);
            border-color: rgba(220, 53, 69, 0.3);
        }

        .severity-high {
            background: rgba(255, 193, 7, 0.1);
            color: var(--warning);
            border-color: rgba(255, 193, 7, 0.3);
        }

        .severity-medium {
            background: rgba(23, 162, 184, 0.1);
            color: var(--info);
            border-color: rgba(23, 162, 184, 0.3);
        }

        .severity-low {
            background: rgba(40, 167, 69, 0.1);
            color: var(--success);
            border-color: rgba(40, 167, 69, 0.3);
        }

        .log-details {
            max-width: 300px;
            line-height: 1.4;
            color: var(--dark);
            font-size: 13px;
        }

        .ip-badge {
            background: rgba(108, 117, 125, 0.1);
            color: var(--secondary);
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 11px;
            font-family: 'Courier New', monospace;
            border: 1px solid rgba(108, 117, 125, 0.2);
        }

        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: var(--text-muted);
        }

        .empty-state i {
            font-size: 64px;
            margin-bottom: 20px;
            opacity: 0.5;
        }

        .empty-state p {
            font-size: 16px;
            margin-bottom: 20px;
        }

        .pagination {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px 25px;
            border-top: 1px solid var(--border);
            background: #f8f9fa;
        }

        .pagination-info {
            font-size: 14px;
            color: var(--text-muted);
        }

        .pagination-controls {
            display: flex;
            gap: 8px;
        }

        .pagination-button {
            padding: 8px 16px;
            border: 1px solid var(--border);
            border-radius: var(--radius-sm);
            background: white;
            color: var(--text-main);
            cursor: pointer;
            transition: var(--transition);
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 6px;
            font-size: 14px;
        }

        .pagination-button:hover:not(.active) {
            background: var(--bg-main);
            border-color: var(--warning);
            color: var(--warning);
        }

        .pagination-button.active {
            background: var(--warning);
            color: var(--dark);
            border-color: var(--warning);
        }

        @media (max-width: 1024px) {
            .admin-stats {
                grid-template-columns: repeat(2, 1fr);
            }
            
            .filter-row {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 768px) {
            .admin-stats {
                grid-template-columns: 1fr;
            }
            
            .admin-header {
                flex-direction: column;
                text-align: center;
                gap: 15px;
            }
            
            .table-header {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }
            
            .pagination {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }
        }
    
</style>
<?php
// src/views/admin/logs.php
?>

<div class="admin-container">
        <div class="admin-header">
            <a href="./?r=admin/dashboard" class="back-button" title="Volver al dashboard">
                <i class="fas fa-arrow-left"></i>
            </a>
            <div>
                <h1>Logs de Seguridad</h1>
                <p>Registros de actividad y eventos del sistema</p>
            </div>
        </div>

        <div class="admin-stats">
            <div class="stat-card total">
                <div class="stat-header">
                    <div class="stat-title">Total de Registros</div>
                    <div class="stat-icon">
                        <i class="fas fa-database"></i>
                    </div>
                </div>
                <div class="stat-value"><?= h($pagination['totalItems']) ?></div>
                <div class="stat-desc">
                    <span class="trend positive"><i class="fas fa-arrow-up"></i> 22%</span>
                    vs mes anterior
                </div>
            </div>

            <div class="stat-card today">
                <div class="stat-header">
                    <div class="stat-title">Eventos Hoy</div>
                    <div class="stat-icon">
                        <i class="fas fa-calendar-day"></i>
                    </div>
                </div>
                <div class="stat-value"><?= h($stats['today_logs'] ?? 0) ?></div>
                <div class="stat-desc">
                    <span class="trend positive"><i class="fas fa-arrow-up"></i> 15%</span>
                    actividad hoy
                </div>
            </div>

            <div class="stat-card critical">
                <div class="stat-header">
                    <div class="stat-title">Alta Severidad</div>
                    <div class="stat-icon">
                        <i class="fas fa-exclamation-triangle"></i>
                    </div>
                </div>
                <div class="stat-value"><?= h($stats['high_severity'] ?? 0) ?></div>
                <div class="stat-desc">
                    <span class="trend <?= ($stats['high_severity'] ?? 0) > 0 ? 'negative' : 'positive' ?>">
                        <i class="fas fa-arrow-<?= ($stats['high_severity'] ?? 0) > 0 ? 'up' : 'down' ?>"></i>
                        <?= ($stats['high_severity'] ?? 0) > 0 ? '8%' : '0%' ?>
                    </span>
                    necesita atención
                </div>
            </div>

            <div class="stat-card users">
                <div class="stat-header">
                    <div class="stat-title">Usuarios Activos</div>
                    <div class="stat-icon">
                        <i class="fas fa-user-clock"></i>
                    </div>
                </div>
                <div class="stat-value"><?= h($stats['active_users'] ?? 0) ?></div>
                <div class="stat-desc">
                    <span class="trend positive"><i class="fas fa-arrow-up"></i> 5%</span>
                    en la plataforma
                </div>
            </div>
        </div>

        <div class="filters">
            <form method="get" class="filter-form">
                <input type="hidden" name="r" value="admin/logs">
                <div class="filter-row">
                    <div class="filter-group">
                        <label class="filter-label"><i class="fas fa-bolt"></i> Acción</label>
                        <select class="filter-select" name="action">
                            <option value="">Todas las acciones</option>
                            <?php foreach ($actions as $action): ?>
                                <option value="<?= h($action) ?>" <?= ($_GET['action'] ?? '') === $action ? 'selected' : '' ?>>
                                    <?= h(ucfirst(str_replace('_', ' ', $action))) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="filter-group">
                        <label class="filter-label"><i class="fas fa-shield-alt"></i> Severidad</label>
                        <select class="filter-select" name="severity">
                            <option value="">Todas las severidades</option>
                            <option value="low" <?= ($_GET['severity'] ?? '') === 'low' ? 'selected' : '' ?>>Baja</option>
                            <option value="medium" <?= ($_GET['severity'] ?? '') === 'medium' ? 'selected' : '' ?>>Media</option>
                            <option value="high" <?= ($_GET['severity'] ?? '') === 'high' ? 'selected' : '' ?>>Alta</option>
                            <option value="critical" <?= ($_GET['severity'] ?? '') === 'critical' ? 'selected' : '' ?>>Crítica</option>
                        </select>
                    </div>
                    <div class="filter-group">
                        <label class="filter-label"><i class="fas fa-user"></i> Usuario</label>
                        <input type="text" class="filter-input" name="user" placeholder="Buscar por usuario..." 
                               value="<?= h($_GET['user'] ?? '') ?>">
                    </div>
                </div>
                <div class="filter-actions">
                    <button type="submit" class="btn btn-primary btn-sm">
                        <i class="fas fa-search"></i> Buscar
                    </button>
                    <a href="./?r=admin/logs" class="btn btn-outline btn-sm">
                        <i class="fas fa-undo"></i> Limpiar
                    </a>
                </div>
            </form>
        </div>

        <div class="table-container">
            <div class="table-header">
                <div class="table-title">
                    <i class="fas fa-shield-alt"></i> Registros de Seguridad
                    <span class="badge"><?= $pagination['totalItems'] ?></span>
                </div>
                <div class="table-actions">
                    <button class="btn btn-outline btn-sm">
                        <i class="fas fa-download"></i> Exportar
                    </button>
                </div>
            </div>

            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Fecha</th>
                            <th>Usuario</th>
                            <th>Acción</th>
                            <th>Severidad</th>
                            <th>Detalles</th>
                            <th>IP</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($logs)): ?>
                            <?php foreach ($logs as $log): ?>
                            <tr>
                                <td class="timestamp"><?= h(fdt($log['created_at'])) ?></td>
                                <td>
                                    <?php if (!empty($log['username'])): ?>
                                        <div class="user-cell">
                                            <div class="user-avatar" style="overflow:hidden;border-radius:50%;padding:0;background:none;">
                                                <?= strtoupper(substr($log['username'], 0, 1)) ?>
                                            </div>
                                            <div class="user-info-cell">
                                                <div class="user-name"><?= h($log['username']) ?></div>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <span class="muted">Sistema</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="action-badge"><?= h(ucfirst(str_replace('_', ' ', $log['action']))) ?></span>
                                </td>
                                <td>
                                    <span class="severity-badge severity-<?= h($log['severity']) ?>">
                                        <i class="fas fa-<?= 
                                            $log['severity'] === 'critical' ? 'exclamation-triangle' : 
                                            ($log['severity'] === 'high' ? 'exclamation-circle' : 
                                            ($log['severity'] === 'medium' ? 'info-circle' : 'check-circle'))
                                        ?>"></i>
                                        <?= h(ucfirst($log['severity'])) ?>
                                    </span>
                                </td>
                                <td>
                                    <div class="log-details" title="<?= h($log['details'] ?? '—') ?>">
                                        <?= h(limit_text($log['details'] ?? '—', 80)) ?>
                                    </div>
                                </td>
                                <td>
                                    <span class="ip-badge"><?= h($log['ip_address'] ?? '—') ?></span>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="6" class="empty-state">
                                    <i class="fas fa-box-open"></i>
                                    <p>No hay registros de seguridad</p>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <?php if ($pagination['totalPages'] > 1): ?>
            <div class="pagination">
                <div class="pagination-info">
                    Mostrando <?= count($logs) ?> de <?= $pagination['totalItems'] ?> registros
                </div>
                <div class="pagination-controls">
                    <?php if ($pagination['page'] > 1): ?>
                        <a href="?r=admin/logs&page=1<?= !empty($_GET) ? '&' . http_build_query($_GET) : '' ?>" class="pagination-button">
                            <i class="fas fa-angle-double-left"></i>
                        </a>
                        <a href="?r=admin/logs&page=<?= $pagination['page'] - 1 ?><?= !empty($_GET) ? '&' . http_build_query($_GET) : '' ?>" class="pagination-button">
                            <i class="fas fa-angle-left"></i>
                        </a>
                    <?php endif; ?>

                    <?php
                    $start = max(1, $pagination['page'] - 2);
                    $end = min($pagination['totalPages'], $start + 4);
                    $start = max(1, $end - 4);
                    
                    for ($i = $start; $i <= $end; $i++): ?>
                        <a href="?r=admin/logs&page=<?= $i ?><?= !empty($_GET) ? '&' . http_build_query($_GET) : '' ?>" 
                           class="pagination-button <?= $i == $pagination['page'] ? 'active' : '' ?>">
                            <?= $i ?>
                        </a>
                    <?php endfor; ?>

                    <?php if ($pagination['page'] < $pagination['totalPages']): ?>
                        <a href="?r=admin/logs&page=<?= $pagination['page'] + 1 ?><?= !empty($_GET) ? '&' . http_build_query($_GET) : '' ?>" class="pagination-button">
                            <i class="fas fa-angle-right"></i>
                        </a>
                        <a href="?r=admin/logs&page=<?= $pagination['totalPages'] ?><?= !empty($_GET) ? '&' . http_build_query($_GET) : '' ?>" class="pagination-button">
                            <i class="fas fa-angle-double-right"></i>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
