<?php if (!function_exists('avatar_img')) { @include_once '../../helpers.php'; } ?>
<?php
// src/views/admin/login_attempts.php
?>
<div class="card">
    <div class="card-header">
        <div class="card-title">
            <i class="fas fa-filter"></i> Filtros de Búsqueda
        </div>
    </div>
    <form method="get" class="filters-grid">
        <input type="hidden" name="r" value="admin/login-attempts">
        <div class="filter-group">
            <label class="filter-label">Estado</label>
            <select class="form-control" name="status">
                <option value="">Todos los estados</option>
                <option value="success" <?= ($_GET['status'] ?? '') === 'success' ? 'selected' : '' ?>>Éxito</option>
                <option value="fail" <?= ($_GET['status'] ?? '') === 'fail' ? 'selected' : '' ?>>Fallido</option>
            </select>
        </div>
        <div class="filter-group">
            <label class="filter-label">Dirección IP</label>
            <input type="text" class="form-control" name="ip" placeholder="Buscar por IP..." 
                   value="<?= h($_GET['ip'] ?? '') ?>">
        </div>
        <div class="filter-group">
            <label class="filter-label">Usuario</label>
            <input type="text" class="form-control" name="username" placeholder="Buscar por usuario..." 
                   value="<?= h($_GET['username'] ?? '') ?>">
        </div>
        <div class="filter-group" style="display: flex; align-items: flex-end;">
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-search"></i> Buscar
            </button>
            <a href="./?r=admin/login-attempts" class="btn btn-ghost">
                <i class="fas fa-undo"></i> Limpiar
            </a>
        </div>
    </form>
</div>

<div class="card">
    <div class="card-header">
        <div class="card-title">
            <i class="fas fa-right-to-bracket"></i> Intentos de Login
            <span class="badge badge-primary"><?= $pagination['totalItems'] ?></span>
        </div>
        <div class="action-buttons">
            <a href="#" class="btn btn-ghost btn-sm">
                <i class="fas fa-download"></i> Exportar
            </a>
        </div>
    </div>

    <div class="table-container">
        <table class="table">
            <thead>
                <tr>
                    <th>Fecha</th>
                    <th>Usuario</th>
                    <th>Dirección IP</th>
                    <th>Resultado</th>
                    <th>Detalles</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($attempts)): ?>
                    <?php foreach ($attempts as $attempt): ?>
                    <tr>
                        <td class="mono"><?= h(fdt($attempt['last_attempt'])) ?></td>
                        <td>
                            <?php if (!empty($attempt['username'])): ?>
                                <div class="user-cell">
                                    <div class="user-avatar" style="overflow:hidden;border-radius:50%;padding:0;background:none;">
                                        <?= strtoupper(substr($attempt['username'], 0, 1)) ?>
                                    </div>
                                    <div class="user-info-cell">
                                        <div class="user-name"><?= h($attempt['username']) ?></div>
                                    </div>
                                </div>
                            <?php else: ?>
                                <span class="muted">—</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="badge"><?= h($attempt['ip'] ?? '—') ?></span>
                        </td>
                        <td>
                            <?php $success = strtolower($attempt['status'] ?? '') === 'success'; ?>
                            <span class="badge badge-<?= $success ? 'success' : 'danger' ?>">
                                <?= h(ucfirst($attempt['status'] ?? 'Desconocido')) ?>
                            </span>
                        </td>
                        <td>
                            <span class="muted"><?= h($attempt['details'] ?? '—') ?></span>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5" class="empty-state">
                            <i class="fas fa-box-open"></i>
                            <p>No hay intentos de login registrados</p>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php if ($pagination['totalPages'] > 1): ?>
    <div class="pagination">
        <?php if ($pagination['page'] > 1): ?>
            <a href="?r=admin/login-attempts&page=1<?= !empty($_GET) ? '&' . http_build_query($_GET) : '' ?>" class="page-link">
                <i class="fas fa-angle-double-left"></i>
            </a>
            <a href="?r=admin/login-attempts&page=<?= $pagination['page'] - 1 ?><?= !empty($_GET) ? '&' . http_build_query($_GET) : '' ?>" class="page-link">
                <i class="fas fa-angle-left"></i>
            </a>
        <?php endif; ?>

        <?php
        $start = max(1, $pagination['page'] - 2);
        $end = min($pagination['totalPages'], $start + 4);
        $start = max(1, $end - 4);
        
        for ($i = $start; $i <= $end; $i++): ?>
            <a href="?r=admin/login-attempts&page=<?= $i ?><?= !empty($_GET) ? '&' . http_build_query($_GET) : '' ?>" 
               class="page-link <?= $i == $pagination['page'] ? 'active' : '' ?>">
                <?= $i ?>
            </a>
        <?php endfor; ?>

        <?php if ($pagination['page'] < $pagination['totalPages']): ?>
            <a href="?r=admin/login-attempts&page=<?= $pagination['page'] + 1 ?><?= !empty($_GET) ? '&' . http_build_query($_GET) : '' ?>" class="page-link">
                <i class="fas fa-angle-right"></i>
            </a>
            <a href="?r=admin/login-attempts&page=<?= $pagination['totalPages'] ?><?= !empty($_GET) ? '&' . http_build_query($_GET) : '' ?>" class="page-link">
                <i class="fas fa-angle-double-right"></i>
            </a>
        <?php endif; ?>
    </div>
    <div class="page-info">
        Mostrando <?= count($attempts) ?> de <?= $pagination['totalItems'] ?> intentos
    </div>
    <?php endif; ?>
</div>