<?php if (!function_exists('avatar_img')) { @include_once '../../helpers.php'; } ?>

<!-- Restored Admin Styles -->
<style>

        :root {
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --primary-light: rgba(67, 97, 238, 0.1);
            --secondary: #6c757d;
            --success: #28c76f;
            --success-dark: #22a85c;
            --success-light: rgba(40, 199, 111, 0.1);
            --danger: #ea5455;
            --danger-dark: #e04242;
            --danger-light: rgba(234, 84, 85, 0.1);
            --warning: #ff9f43;
            --warning-dark: #f68c2a;
            --warning-light: rgba(255, 159, 67, 0.1);
            --info: #00cfe8;
            --info-dark: #00b2c8;
            --info-light: rgba(0, 207, 232, 0.1);
            --dark: #283046;
            --darker: #161d31;
            --light: #f8f9fa;
            --gray: #6c757d;
            --text: #d0d2d6;
            --text-muted: #b4b7bd;
            --border: #3b4253;
            --border-light: #414958;
            --bg-dark: #161d31;
            --bg-card: #283046;
            --bg-card-hover: #2f3650;
            --radius: 0.428rem;
            --radius-sm: 0.286rem;
            --shadow: 0 4px 24px 0 rgba(34, 41, 47, 0.1);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', 'Montserrat', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background-color: var(--bg-dark);
            color: var(--text);
            min-height: 100vh;
            display: flex;
            font-size: 0.95rem;
            line-height: 1.5;
        }

        /* Admin Layout */
        .admin-container {
            display: flex;
            width: 100%;
            min-height: 100vh;
        }

        /* Sidebar */
        .admin-sidebar {
            width: 260px;
            background: var(--bg-card);
            border-right: 1px solid var(--border);
            padding: 1.5rem 0;
            position: fixed;
            height: 100vh;
            overflow-y: auto;
            z-index: 1000;
            transition: transform 0.3s ease;
            box-shadow: var(--shadow);
        }

        .admin-sidebar-header {
            padding: 0 1.5rem 1.5rem;
            border-bottom: 1px solid var(--border);
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .admin-sidebar-header h2 {
            font-size: 1.4rem;
            color: var(--primary);
            font-weight: 600;
        }

        .admin-sidebar-header h2 i {
            font-size: 1.6rem;
        }

        .admin-menu {
            list-style: none;
            padding: 0;
        }

        .admin-menu-item {
            margin: 0.25rem 0;
        }

        .admin-menu-link {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.75rem 1.5rem;
            color: var(--text);
            text-decoration: none;
            border-left: 3px solid transparent;
            transition: var(--transition);
            font-weight: 400;
        }

        .admin-menu-link:hover, 
        .admin-menu-link.active {
            background: var(--bg-card-hover);
            border-left-color: var(--primary);
            color: white;
        }

        .admin-menu-link i {
            width: 20px;
            text-align: center;
            font-size: 1.1rem;
        }

        .menu-badge {
            margin-left: auto;
            background: var(--primary);
            color: white;
            padding: 0.2rem 0.5rem;
            border-radius: 50px;
            font-size: 0.7rem;
            font-weight: 600;
            min-width: 24px;
            text-align: center;
        }

        /* Main Content */
        .admin-main {
            flex: 1;
            margin-left: 260px;
            padding: 1.5rem;
            transition: margin-left 0.3s ease;
        }

        .admin-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid var(--border);
        }

        .admin-title h1 {
            font-size: 1.75rem;
            margin-bottom: 0.25rem;
            font-weight: 600;
            color: var(--text);
        }

        .admin-subtitle {
            color: var(--text-muted);
            font-size: 0.95rem;
        }

        .admin-actions {
            display: flex;
            gap: 0.75rem;
            align-items: center;
        }

        .user-info {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.5rem 1rem;
            background: var(--bg-card);
            border-radius: var(--radius);
            border: 1px solid var(--border);
        }

        .user-avatar-sm {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
            font-size: 0.9rem;
        }

        .user-details {
            display: flex;
            flex-direction: column;
        }

        .user-name {
            font-weight: 500;
        }

        .user-role {
            font-size: 0.8rem;
            color: var(--text-muted);
        }

        /* Stats Cards */
        .admin-stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
            gap: 1.25rem;
            margin-bottom: 1.5rem;
        }

        .stat-card {
            background: var(--bg-card);
            border-radius: var(--radius);
            padding: 1.25rem;
            box-shadow: var(--shadow);
            display: flex;
            flex-direction: column;
            transition: var(--transition);
            border: 1px solid var(--border);
            position: relative;
            overflow: hidden;
        }

        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px 0 rgba(34, 41, 47, 0.15);
        }

        .stat-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 1rem;
        }

        .stat-title {
            font-size: 0.85rem;
            color: var(--text-muted);
            text-transform: uppercase;
            font-weight: 600;
            letter-spacing: 0.5px;
        }

        .stat-icon {
            width: 44px;
            height: 44px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.25rem;
        }

        .stat-icon.users { background: var(--primary); }
        .stat-icon.posts { background: var(--info); }
        .stat-icon.comments { background: var(--success); }
        .stat-icon.reports { background: var(--danger); }
        .stat-icon.logs { background: var(--warning); }
        .stat-icon.attempts { background: var(--secondary); }

        .stat-value {
            font-size: 1.75rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
            color: var(--text);
        }

        .stat-desc {
            font-size: 0.85rem;
            color: var(--text-muted);
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .trend {
            display: inline-flex;
            align-items: center;
            gap: 0.25rem;
            font-size: 0.8rem;
            font-weight: 600;
            padding: 0.2rem 0.5rem;
            border-radius: 50px;
        }

        .trend.positive {
            background: var(--success-light);
            color: var(--success);
        }

        .trend.negative {
            background: var(--danger-light);
            color: var(--danger);
        }

        .stat-action {
            margin-top: auto;
            padding-top: 1rem;
        }

        /* Cards */
        .card {
            background: var(--bg-card);
            border-radius: var(--radius);
            padding: 1.5rem;
            box-shadow: var(--shadow);
            margin-bottom: 1.5rem;
            border: 1px solid var(--border);
        }

        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.25rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid var(--border);
        }

        .card-title {
            font-size: 1.25rem;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 0.75rem;
            color: var(--text);
        }

        .card-title i {
            color: var(--primary);
            font-size: 1.1rem;
        }

        /* Filters */
        .filters-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            margin-bottom: 1.25rem;
        }

        .filter-group {
            display: flex;
            flex-direction: column;
        }

        .filter-label {
            font-size: 0.85rem;
            color: var(--text-muted);
            margin-bottom: 0.5rem;
            font-weight: 500;
        }

        /* Forms */
        .form-control {
            width: 100%;
            padding: 0.75rem 1rem;
            background: var(--darker);
            border: 1px solid var(--border);
            border-radius: var(--radius-sm);
            color: var(--text);
            font-size: 0.9rem;
            transition: var(--transition);
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 2px var(--primary-light);
        }

        select.form-control {
            appearance: none;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' viewBox='0 0 24 24' fill='none' stroke='%23b4b7bd' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3E%3Cpath d='M6 9l6 6 6-6'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 1rem center;
            background-size: 16px;
            padding-right: 2.5rem;
        }

        /* Buttons */
        .btn {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.75rem 1.25rem;
            border-radius: var(--radius-sm);
            border: none;
            font-weight: 500;
            cursor: pointer;
            text-decoration: none;
            transition: var(--transition);
            font-size: 0.9rem;
            line-height: 1;
        }

        .btn-sm {
            padding: 0.5rem 0.9rem;
            font-size: 0.85rem;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
        }

        .btn-danger {
            background: var(--danger);
            color: white;
        }

        .btn-danger:hover {
            background: var(--danger-dark);
            transform: translateY(-2px);
        }

        .btn-success {
            background: var(--success);
            color: white;
        }

        .btn-success:hover {
            background: var(--success-dark);
            transform: translateY(-2px);
        }

        .btn-warning {
            background: var(--warning);
            color: white;
        }

        .btn-warning:hover {
            background: var(--warning-dark);
            transform: translateY(-2px);
        }

        .btn-info {
            background: var(--info);
            color: white;
        }

        .btn-info:hover {
            background: var(--info-dark);
            transform: translateY(-2px);
        }

        .btn-ghost {
            background: transparent;
            border: 1px solid var(--border);
            color: var(--text);
        }

        .btn-ghost:hover {
            background: var(--bg-card-hover);
            transform: translateY(-2px);
        }

        /* Tables */
        .table-container {
            overflow-x: auto;
            border-radius: var(--radius);
            border: 1px solid var(--border);
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        .table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0;
            min-width: 800px;
        }

        .table th {
            background: var(--darker);
            padding: 1rem;
            text-align: left;
            font-weight: 600;
            color: var(--text);
            border-bottom: 1px solid var(--border);
            font-size: 0.9rem;
            white-space: nowrap;
        }

        .table td {
            padding: 1rem;
            border-bottom: 1px solid var(--border);
            vertical-align: middle;
            font-size: 0.9rem;
        }

        .table tr:last-child td {
            border-bottom: none;
        }

        .table tr:hover {
            background: var(--bg-card-hover);
        }

        /* Badges */
        .badge {
            display: inline-flex;
            align-items: center;
            padding: 0.35rem 0.65rem;
            border-radius: 50px;
            font-size: 0.75rem;
            font-weight: 600;
            line-height: 1;
        }

        .badge-success { 
            background: var(--success-light); 
            color: var(--success); 
        }
        
        .badge-warning { 
            background: var(--warning-light); 
            color: var(--warning); 
        }
        
        .badge-danger { 
            background: var(--danger-light); 
            color: var(--danger); 
        }
        
        .badge-info { 
            background: var(--info-light); 
            color: var(--info); 
        }
        
        .badge-primary { 
            background: var(--primary-light); 
            color: var(--primary); 
        }

        /* Empty state */
        .empty-state {
            text-align: center;
            padding: 2.5rem 1.5rem;
            color: var(--text-muted);
        }

        .empty-state i {
            font-size: 3rem;
            margin-bottom: 1rem;
            opacity: 0.5;
            color: var(--primary);
        }

        .empty-state p {
            margin-bottom: 1.5rem;
            font-size: 1.1rem;
        }

        /* Pagination */
        .pagination {
            display: flex;
            justify-content: center;
            gap: 0.5rem;
            margin-top: 1.5rem;
            flex-wrap: wrap;
        }

        .page-link {
            padding: 0.6rem 0.9rem;
            border: 1px solid var(--border);
            border-radius: var(--radius-sm);
            color: var(--text);
            text-decoration: none;
            transition: var(--transition);
            font-size: 0.9rem;
            min-width: 42px;
            text-align: center;
        }

        .page-link:hover {
            background: var(--bg-card-hover);
            border-color: var(--primary);
        }

        .page-link.active {
            background: var(--primary);
            color: white;
            border-color: var(--primary);
        }

        .page-info {
            text-align: center;
            margin-top: 0.75rem;
            color: var(--text-muted);
            font-size: 0.85rem;
            width: 100%;
        }

        /* Alerts */
        .alert {
            padding: 1rem 1.25rem;
            border-radius: var(--radius-sm);
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
            border: 1px solid transparent;
        }

        .alert-success {
            background: var(--success-light);
            color: var(--success);
            border-color: rgba(40, 199, 111, 0.2);
        }

        .alert-error {
            background: var(--danger-light);
            color: var(--danger);
            border-color: rgba(234, 84, 85, 0.2);
        }

        /* User cell */
        .user-cell {
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
            font-size: 1rem;
            flex-shrink: 0;
        }

        .user-info-cell {
            display: flex;
            flex-direction: column;
        }

        .user-name {
            font-weight: 500;
            line-height: 1.2;
        }

        .user-id {
            font-size: 0.75rem;
            color: var(--text-muted);
        }

        /* Action buttons */
        .action-buttons {
            display: flex;
            gap: 0.5rem;
        }

        /* Preformatted text */
        .pre-wrap {
            white-space: pre-wrap;
            word-break: break-word;
            max-width: 300px;
            max-height: 100px;
            overflow: auto;
            font-size: 0.85rem;
            line-height: 1.4;
        }

        /* Mono text */
        .mono {
            font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;
            font-size: 0.85rem;
        }

        /* Muted text */
        .muted {
            color: var(--text-muted);
        }

        /* Loading spinner */
        .spinner {
            width: 24px;
            height: 24px;
            border: 2px solid transparent;
            border-top: 2px solid var(--primary);
            border-radius: 50%;
            animation: spin 1s linear infinite;
            display: inline-block;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Mobile menu toggle */
        .menu-toggle {
            display: none;
            position: fixed;
            bottom: 1.5rem;
            right: 1.5rem;
            z-index: 1000;
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: var(--primary);
            color: white;
            border: none;
            box-shadow: var(--shadow);
            align-items: center;
            justify-content: center;
            font-size: 1.25rem;
        }

        /* Responsive */
        @media (max-width: 1200px) {
            .admin-stats {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media (max-width: 992px) {
            .admin-sidebar {
                transform: translateX(-100%);
                width: 260px;
            }
            
            .admin-sidebar.open {
                transform: translateX(0);
            }
            
            .admin-main {
                margin-left: 0;
                padding: 1rem;
            }
            
            .admin-stats {
                grid-template-columns: 1fr;
            }
            
            .menu-toggle {
                display: flex;
            }

            .admin-header {
                flex-direction: column;
                align-items: flex-start;
                gap: 1rem;
            }
            
            .admin-actions {
                width: 100%;
                justify-content: space-between;
            }
            
            .filters-grid {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 768px) {
            .card-header {
                flex-direction: column;
                align-items: flex-start;
                gap: 1rem;
            }
            
            .action-buttons {
                width: 100%;
                justify-content: flex-end;
            }
            
            .pagination {
                flex-direction: column;
                align-items: center;
            }
            
            .page-link {
                width: 100%;
                max-width: 250px;
            }
        }

        /* Toast notifications */
        .toastify {
            border-radius: var(--radius);
            font-family: inherit;
            box-shadow: var(--shadow);
        }

        /* Custom scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
            height: 8px;
        }

        ::-webkit-scrollbar-track {
            background: var(--darker);
            border-radius: 10px;
        }

        ::-webkit-scrollbar-thumb {
            background: var(--border);
            border-radius: 10px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: var(--border-light);
        }
    
</style>
<?php
// src/views/admin/layout.php
?>

<!-- Mobile menu toggle -->
    <button class="menu-toggle" id="menuToggle">
        <i class="fas fa-bars"></i>
    </button>

    <!-- Admin Sidebar -->
    <aside class="admin-sidebar" id="adminSidebar">
        <div class="admin-sidebar-header">
            <i class="fas fa-shield-alt"></i>
            <h2>AdminPanel</h2>
        </div>
        
        <ul class="admin-menu">
            <li class="admin-menu-item">
                <a href="./?r=admin/dashboard" class="admin-menu-link <?= $currentPage === 'dashboard' ? 'active' : '' ?>">
                    <i class="fas fa-gauge-high"></i>
                    <span>Dashboard</span>
                </a>
            </li>
            <li class="admin-menu-item">
                <a href="./?r=admin/users" class="admin-menu-link <?= $currentPage === 'users' ? 'active' : '' ?>">
                    <i class="fas fa-users"></i>
                    <span>Usuarios</span>
                    <span class="menu-badge"><?= $stats['total_users'] ?? 0 ?></span>
                </a>
            </li>
            <li class="admin-menu-item">
                <a href="./?r=admin/posts" class="admin-menu-link <?= $currentPage === 'posts' ? 'active' : '' ?>">
                    <i class="fas fa-file-alt"></i>
                    <span>Publicaciones</span>
                    <span class="menu-badge"><?= $stats['total_posts'] ?? 0 ?></span>
                </a>
            </li>
            <li class="admin-menu-item">
                <a href="./?r=admin/comments" class="admin-menu-link <?= $currentPage === 'comments' ? 'active' : '' ?>">
                    <i class="fas fa-comments"></i>
                    <span>Comentarios</span>
                    <span class="menu-badge"><?= $stats['total_comments'] ?? 0 ?></span>
                </a>
            </li>
            <li class="admin-menu-item">
                <a href="./?r=admin/reports" class="admin-menu-link <?= $currentPage === 'reports' ? 'active' : '' ?>">
                    <i class="fas fa-flag"></i>
                    <span>Reportes</span>
                    <span class="menu-badge"><?= $stats['pending_reports'] ?? 0 ?></span>
                </a>
            </li>
            <li class="admin-menu-item">
                <a href="./?r=admin/logs" class="admin-menu-link <?= $currentPage === 'logs' ? 'active' : '' ?>">
                    <i class="fas fa-shield-halved"></i>
                    <span>Logs de Seguridad</span>
                </a>
            </li>
            <li class="admin-menu-item">
                <a href="./?r=admin/login-attempts" class="admin-menu-link <?= $currentPage === 'login-attempts' ? 'active' : '' ?>">
                    <i class="fas fa-right-to-bracket"></i>
                    <span>Intentos de Login</span>
                </a>
            </li>
            <li class="admin-menu-item" style="margin-top: 1.5rem;">
                <a href="./?r=dashboard" class="admin-menu-link">
                    <i class="fas fa-arrow-left"></i>
                    <span>Volver a la App</span>
                </a>
            </li>
            <li class="admin-menu-item">
                <a href="./?r=logout" class="admin-menu-link">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Cerrar Sesión</span>
                </a>
            </li>
        </ul>
    </aside>

    <!-- Main Content -->
    <main class="admin-main">
        <div class="admin-header">
            <div class="admin-title">
                <h1><?= $pageTitle ?? 'Panel de Administración' ?></h1>
                <p class="admin-subtitle"><?= $pageSubtitle ?? 'Gestión del sistema' ?></p>
            </div>
            <div class="admin-actions">
                <div class="user-info">
                    <div class="user-avatar-sm" style="overflow:hidden;border-radius:50%;padding:0;background:none;">
                        <?= strtoupper(substr($_SESSION['user']['username'], 0, 1)) ?>
                    </div>
                    <div class="user-details">
                        <div class="user-name"><?= h($_SESSION['user']['username']) ?></div>
                        <div class="user-role"><?= h(ucfirst($_SESSION['user']['role'])) ?></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Content will be injected here by individual pages -->
        <?php include $contentView; ?>
    </main>

    <script src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
    <script>
        // Toggle mobile menu
        document.getElementById('menuToggle').addEventListener('click', function() {
            document.getElementById('adminSidebar').classList.toggle('open');
        });

        // Close menu when clicking outside on mobile
        document.addEventListener('click', function(event) {
            const sidebar = document.getElementById('adminSidebar');
            const toggle = document.getElementById('menuToggle');
            
            if (window.innerWidth < 992 && 
                !sidebar.contains(event.target) && 
                !toggle.contains(event.target) &&
                sidebar.classList.contains('open')) {
                sidebar.classList.remove('open');
            }
        });

        // Auto-hide alerts after 5 seconds
        setTimeout(() => {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(alert => {
                alert.style.opacity = '0';
                alert.style.transition = 'opacity 0.5s';
                setTimeout(() => alert.remove(), 500);
            });
        }, 5000);

        // Handle form submissions with loading states
        document.querySelectorAll('form').forEach(form => {
            form.addEventListener('submit', function() {
                const submitBtn = this.querySelector('button[type="submit"]');
                if (submitBtn) {
                    submitBtn.disabled = true;
                    submitBtn.innerHTML = '<span class="spinner"></span> Procesando...';
                }
            });
        });

        // Toast notifications for flash messages
        <?php if (!empty($_SESSION['flash']['success'])): ?>
            Toastify({
                text: "<?= addslashes(flash('success')) ?>",
                duration: 5000,
                gravity: "top",
                position: "right",
                backgroundColor: "var(--success)",
                stopOnFocus: true
            }).showToast();
        <?php endif; ?>

        <?php if (!empty($_SESSION['flash']['error'])): ?>
            Toastify({
                text: "<?= addslashes(flash('error')) ?>",
                duration: 5000,
                gravity: "top",
                position: "right",
                backgroundColor: "var(--danger)",
                stopOnFocus: true
            }).showToast();
        <?php endif; ?>
    </script>
