<?php if (!function_exists('avatar_img')) { @include_once '../../../helpers.php'; } ?>


<!-- Restored Admin Styles -->
<style>

        :root {
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --secondary: #6c757d;
            --success: #28a745;
            --danger: #dc3545;
            --warning: #ffc107;
            --info: #17a2b8;
            --light: #f8f9fa;
            --dark: #343a40;
            --bg-main: #f5f7f9;
            --bg-card: #ffffff;
            --text-main: #212529;
            --text-muted: #6c757d;
            --border: #dee2e6;
            --radius: 16px;
            --radius-sm: 10px;
            --shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            --shadow-lg: 0 12px 40px rgba(0, 0, 0, 0.15);
            --transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
            --gradient: linear-gradient(135deg, #4361ee 0%, #3a0ca3 100%);
            --gradient-light: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
            position: relative;
        }

        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" preserveAspectRatio="none"><defs><pattern id="grid" width="10" height="10" patternUnits="userSpaceOnUse"><path d="M 10 0 L 0 0 0 10" fill="none" stroke="rgba(255,255,255,0.05)" stroke-width="0.5"/></pattern></defs><rect width="100" height="100" fill="url(%23grid)"/></svg>');
            pointer-events: none;
            z-index: -1;
        }

        .control-panel {
            max-width: 1400px;
            margin: 0 auto;
        }

        .panel-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: var(--radius);
            padding: 30px;
            margin-bottom: 24px;
            box-shadow: var(--shadow-lg);
            text-align: center;
            position: relative;
            overflow: hidden;
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .panel-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 5px;
            background: var(--gradient);
        }

        .panel-header h1 {
            font-size: 2.5rem;
            font-weight: 800;
            background: var(--gradient);
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            margin-bottom: 8px;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .panel-header p {
            color: var(--text-muted);
            font-size: 1.1rem;
            max-width: 600px;
            margin: 0 auto;
        }

        .control-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 24px;
            margin-bottom: 30px;
        }

        .control-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: var(--radius);
            padding: 30px;
            box-shadow: var(--shadow);
            transition: var(--transition);
            border-left: 4px solid var(--primary);
            position: relative;
            overflow: hidden;
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .control-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, var(--primary), var(--info));
            opacity: 0;
            transition: var(--transition);
        }

        .control-card:hover {
            transform: translateY(-8px);
            box-shadow: var(--shadow-lg);
        }

        .control-card:hover::before {
            opacity: 1;
        }

        .control-card.system {
            border-left-color: var(--info);
        }

        .control-card.security {
            border-left-color: var(--warning);
        }

        .control-card.content {
            border-left-color: var(--success);
        }

        .control-card.maintenance {
            border-left-color: var(--danger);
        }

        .card-header {
            display: flex;
            align-items: center;
            gap: 15px;
            margin-bottom: 20px;
        }

        .card-icon {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            color: white;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.15);
            transition: var(--transition);
        }

        .control-card:hover .card-icon {
            transform: scale(1.1);
        }

        .system .card-icon { background: var(--info); }
        .security .card-icon { background: var(--warning); }
        .content .card-icon { background: var(--success); }
        .maintenance .card-icon { background: var(--danger); }

        .card-title {
            font-size: 1.4rem;
            font-weight: 700;
            color: var(--dark);
            margin-bottom: 5px;
        }

        .card-subtitle {
            color: var(--text-muted);
            font-size: 0.95rem;
        }

        .card-features {
            list-style: none;
            margin-bottom: 25px;
        }

        .card-features li {
            padding: 10px 0;
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
            display: flex;
            align-items: center;
            gap: 10px;
            transition: var(--transition);
        }

        .card-features li:hover {
            background: rgba(0, 0, 0, 0.02);
            padding-left: 10px;
            border-radius: var(--radius-sm);
        }

        .card-features li:last-child {
            border-bottom: none;
        }

        .card-features i {
            color: var(--success);
            font-size: 14px;
            width: 20px;
            text-align: center;
        }

        .btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 12px 24px;
            border-radius: var(--radius-sm);
            text-decoration: none;
            font-weight: 600;
            transition: var(--transition);
            border: none;
            cursor: pointer;
            font-size: 0.95rem;
            position: relative;
            overflow: hidden;
        }

        .btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: var(--transition);
        }

        .btn:hover::before {
            left: 100%;
        }

        .btn-block {
            width: 100%;
            justify-content: center;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: 0 6px 15px rgba(67, 97, 238, 0.4);
        }

        .btn-info {
            background: var(--info);
            color: white;
        }

        .btn-info:hover {
            background: #138496;
            transform: translateY(-2px);
            box-shadow: 0 6px 15px rgba(23, 162, 184, 0.4);
        }

        .btn-warning {
            background: var(--warning);
            color: var(--dark);
        }

        .btn-warning:hover {
            background: #e0a800;
            transform: translateY(-2px);
            box-shadow: 0 6px 15px rgba(255, 193, 7, 0.4);
        }

        .btn-danger {
            background: var(--danger);
            color: white;
        }

        .btn-danger:hover {
            background: #c82333;
            transform: translateY(-2px);
            box-shadow: 0 6px 15px rgba(220, 53, 69, 0.4);
        }

        .btn-success {
            background: var(--success);
            color: white;
        }

        .btn-success:hover {
            background: #218838;
            transform: translateY(-2px);
            box-shadow: 0 6px 15px rgba(40, 167, 69, 0.4);
        }

        .system-status {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: var(--radius);
            padding: 25px;
            box-shadow: var(--shadow);
            margin-bottom: 24px;
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .status-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
        }

        .status-item {
            text-align: center;
            padding: 20px;
            border-radius: var(--radius-sm);
            background: rgba(255, 255, 255, 0.7);
            transition: var(--transition);
            position: relative;
            overflow: hidden;
            border: 1px solid rgba(255, 255, 255, 0.3);
        }

        .status-item::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 4px;
            background: var(--gradient);
            transform: scaleX(0);
            transition: var(--transition);
            transform-origin: left;
        }

        .status-item:hover::before {
            transform: scaleX(1);
        }

        .status-item:hover {
            transform: translateY(-5px);
            box-shadow: var(--shadow);
            background: white;
        }

        .status-value {
            font-size: 2.2rem;
            font-weight: 800;
            margin-bottom: 8px;
            transition: var(--transition);
        }

        .status-item:hover .status-value {
            transform: scale(1.1);
        }

        .status-label {
            color: var(--text-muted);
            font-size: 0.9rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            font-weight: 600;
        }

        .status-online { color: var(--success); }
        .status-warning { color: var(--warning); }
        .status-offline { color: var(--danger); }

        .quick-actions {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-top: 20px;
        }

        @media (max-width: 768px) {
            .control-grid {
                grid-template-columns: 1fr;
            }
            
            .panel-header h1 {
                font-size: 2rem;
            }
            
            .status-grid {
                grid-template-columns: repeat(2, 1fr);
            }
            
            .quick-actions {
                grid-template-columns: 1fr;
            }
        }

        .maintenance-badge {
            background: var(--danger);
            color: white;
            padding: 8px 16px;
            border-radius: 30px;
            font-size: 0.9rem;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            margin-top: 15px;
            box-shadow: 0 4px 12px rgba(220, 53, 69, 0.4);
        }

        .maintenance-active {
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% { transform: scale(1); box-shadow: 0 4px 12px rgba(220, 53, 69, 0.4); }
            50% { transform: scale(1.05); box-shadow: 0 6px 20px rgba(220, 53, 69, 0.6); }
            100% { transform: scale(1); box-shadow: 0 4px 12px rgba(220, 53, 69, 0.4); }
        }

        .notification-bell {
            position: fixed;
            bottom: 30px;
            right: 30px;
            width: 60px;
            height: 60px;
            background: var(--gradient);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 24px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.2);
            cursor: pointer;
            transition: var(--transition);
            z-index: 1000;
        }

        .notification-bell:hover {
            transform: scale(1.1) rotate(15deg);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.3);
        }

        .notification-bell::after {
            content: '3';
            position: absolute;
            top: -5px;
            right: -5px;
            width: 25px;
            height: 25px;
            background: var(--danger);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 12px;
            font-weight: bold;
            color: white;
            animation: pulse 1.5s infinite;
        }

        .search-box {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: var(--radius);
            padding: 20px;
            margin-bottom: 24px;
            box-shadow: var(--shadow);
            display: flex;
            gap: 15px;
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .search-box input {
            flex: 1;
            padding: 12px 20px;
            border: none;
            border-radius: var(--radius-sm);
            background: rgba(0, 0, 0, 0.05);
            font-size: 1rem;
            transition: var(--transition);
        }

        .search-box input:focus {
            outline: none;
            background: white;
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.2);
        }

        .search-box button {
            padding: 12px 24px;
            background: var(--primary);
            color: white;
            border: none;
            border-radius: var(--radius-sm);
            cursor: pointer;
            font-weight: 600;
            transition: var(--transition);
        }

        .search-box button:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
        }

        .recent-activity {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: var(--radius);
            padding: 25px;
            box-shadow: var(--shadow);
            margin-bottom: 24px;
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .activity-list {
            list-style: none;
            margin-top: 15px;
        }

        .activity-list li {
            padding: 12px 0;
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .activity-list li:last-child {
            border-bottom: none;
        }

        .activity-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 16px;
        }

        .activity-info {
            flex: 1;
        }

        .activity-title {
            font-weight: 600;
            margin-bottom: 4px;
        }

        .activity-time {
            color: var(--text-muted);
            font-size: 0.85rem;
        }

        .section-title {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 20px;
            color: var(--dark);
        }

        .section-title i {
            color: var(--primary);
        }
    
</style>
<div class="control-panel">
        <!-- Header -->
        <div class="panel-header">
            <h1>Panel de Control Completo</h1>
            <p>Gestiona todos los aspectos de la plataforma Thirty desde un solo lugar</p>
            
            <?php if ($system_config['maintenance_mode']): ?>
                <div>
                    <span class="maintenance-badge maintenance-active">
                        <i class="fas fa-triangle-exclamation"></i>
                        MODO MANTENIMIENTO ACTIVO
                    </span>
                </div>
            <?php endif; ?>
        </div>

        <!-- Búsqueda -->
        <div class="search-box">
            <input type="text" placeholder="Buscar en el panel de control...">
            <button><i class="fas fa-search"></i> Buscar</button>
        </div>

        <!-- Estado del Sistema -->
        <div class="system-status">
            <h3 class="section-title">
                <i class="fas fa-chart-bar"></i> Estado del Sistema
            </h3>
            <div class="status-grid">
                <div class="status-item">
                    <div class="status-value status-online"><?= h($stats['total_users']) ?></div>
                    <div class="status-label">Usuarios</div>
                </div>
                <div class="status-item">
                    <div class="status-value status-online"><?= h($stats['total_posts']) ?></div>
                    <div class="status-label">Publicaciones</div>
                </div>
                <div class="status-item">
                    <div class="status-value status-warning"><?= h($stats['pending_reports']) ?></div>
                    <div class="status-label">Reportes Pendientes</div>
                </div>
                <div class="status-item">
                    <div class="status-value status-online"><?= h($stats['active_ads']) ?></div>
                    <div class="status-label">Anuncios Activos</div>
                </div>
            </div>
        </div>

        <!-- Actividad Reciente -->
        <div class="recent-activity">
            <h3 class="section-title">
                <i class="fas fa-history"></i> Actividad Reciente
            </h3>
            <ul class="activity-list">
                <li>
                    <div class="activity-icon" style="background: var(--success);">
                        <i class="fas fa-user-plus"></i>
                    </div>
                    <div class="activity-info">
                        <div class="activity-title">Nuevo usuario registrado</div>
                        <div class="activity-time">Hace 5 minutos</div>
                    </div>
                </li>
                <li>
                    <div class="activity-icon" style="background: var(--warning);">
                        <i class="fas fa-flag"></i>
                    </div>
                    <div class="activity-info">
                        <div class="activity-title">Nuevo reporte de contenido</div>
                        <div class="activity-time">Hace 12 minutos</div>
                    </div>
                </li>
                <li>
                    <div class="activity-icon" style="background: var(--info);">
                        <i class="fas fa-cog"></i>
                    </div>
                    <div class="activity-info">
                        <div class="activity-title">Configuración actualizada</div>
                        <div class="activity-time">Hace 25 minutos</div>
                    </div>
                </li>
                <li>
                    <div class="activity-icon" style="background: var(--primary);">
                        <i class="fas fa-file-alt"></i>
                    </div>
                    <div class="activity-info">
                        <div class="activity-title">Nueva publicación creada</div>
                        <div class="activity-time">Hace 42 minutos</div>
                    </div>
                </li>
            </ul>
        </div>

        <!-- Grid de Control -->
        <div class="control-grid">
            <!-- Configuración del Sistema -->
            <div class="control-card system">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-cogs"></i>
                    </div>
                    <div>
                        <div class="card-title">Configuración General</div>
                        <div class="card-subtitle">Ajustes básicos del sistema</div>
                    </div>
                </div>
                <ul class="card-features">
                    <li><i class="fas fa-check"></i> Nombre y descripción del sitio</li>
                    <li><i class="fas fa-check"></i> Configuración de registros</li>
                    <li><i class="fas fa-check"></i> Límites de seguridad</li>
                    <li><i class="fas fa-check"></i> Tiempos de sesión y cookies</li>
                </ul>
                <a href="./?r=admin/system-settings" class="btn btn-info btn-block">
                    <i class="fas fa-sliders-h"></i> Configurar Sistema
                </a>
            </div>

            <!-- Modo Mantenimiento -->
            <div class="control-card maintenance">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-screwdriver-wrench"></i>
                    </div>
                    <div>
                        <div class="card-title">Modo Mantenimiento</div>
                        <div class="card-subtitle">Control de acceso al sitio</div>
                    </div>
                </div>
                <ul class="card-features">
                    <li><i class="fas fa-check"></i> Activar/desactivar mantenimiento</li>
                    <li><i class="fas fa-check"></i> Mensaje personalizado</li>
                    <li><i class="fas fa-check"></i> Acceso exclusivo para admins</li>
                    <li><i class="fas fa-check"></i> Estado en tiempo real</li>
                </ul>
                <a href="./?r=admin/maintenance" class="btn btn-danger btn-block">
                    <i class="fas fa-triangle-exclamation"></i> Gestionar Mantenimiento
                </a>
            </div>

            <!-- Políticas y Términos -->
            <div class="control-card content">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-file-contract"></i>
                    </div>
                    <div>
                        <div class="card-title">Políticas del Sitio</div>
                        <div class="card-subtitle">Términos, privacidad y cookies</div>
                    </div>
                </div>
                <ul class="card-features">
                    <li><i class="fas fa-check"></i> Términos y condiciones</li>
                    <li><i class="fas fa-check"></i> Política de privacidad</li>
                    <li><i class="fas fa-check"></i> Uso de cookies</li>
                    <li><i class="fas fa-check"></i> Guías de la comunidad</li>
                </ul>
                <a href="./?r=admin/policies" class="btn btn-success btn-block">
                    <i class="fas fa-edit"></i> Editar Políticas
                </a>
            </div>

            <!-- Cache y Optimización -->
            <div class="control-card security">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-bolt"></i>
                    </div>
                    <div>
                        <div class="card-title">Rendimiento</div>
                        <div class="card-subtitle">Cache y optimización</div>
                    </div>
                </div>
                <ul class="card-features">
                    <li><i class="fas fa-check"></i> Limpiar caché del sistema</li>
                    <li><i class="fas fa-check"></i> Optimizar base de datos</li>
                    <li><i class="fas fa-check"></i> Limpiar logs antiguos</li>
                    <li><i class="fas fa-check"></i> Estadísticas de rendimiento</li>
                </ul>
                <a href="./?r=admin/cache" class="btn btn-warning btn-block">
                    <i class="fas fa-broom"></i> Optimizar Sistema
                </a>
            </div>

            <!-- Backup del Sistema -->
            <div class="control-card system">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-database"></i>
                    </div>
                    <div>
                        <div class="card-title">Backup y Restauración</div>
                        <div class="card-subtitle">Copias de seguridad</div>
                    </div>
                </div>
                <ul class="card-features">
                    <li><i class="fas fa-check"></i> Crear backup completo</li>
                    <li><i class="fas fa-check"></i> Listar backups existentes</li>
                    <li><i class="fas fa-check"></i> Descargar backups</li>
                    <li><i class="fas fa-check"></i> Gestión automática</li>
                </ul>
                <a href="./?r=admin/backup" class="btn btn-info btn-block">
                    <i class="fas fa-shield-alt"></i> Gestionar Backups
                </a>
            </div>

            <!-- Gestión de Contenido -->
            <div class="control-card content">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-users-cog"></i>
                    </div>
                    <div>
                        <div class="card-title">Gestión de Usuarios</div>
                        <div class="card-subtitle">Administrar usuarios y roles</div>
                    </div>
                </div>
                <ul class="card-features">
                    <li><i class="fas fa-check"></i> Listar y buscar usuarios</li>
                    <li><i class="fas fa-check"></i> Modificar roles y permisos</li>
                    <li><i class="fas fa-check"></i> Bloquear/desbloquear usuarios</li>
                    <li><i class="fas fa-check"></i> Ver actividad reciente</li>
                </ul>
                <a href="./?r=admin/users" class="btn btn-primary btn-block">
                    <i class="fas fa-user-gear"></i> Gestionar Usuarios
                </a>
            </div>
        </div>

        <!-- Acciones Rápidas -->
        <div class="system-status">
            <h3 class="section-title">
                <i class="fas fa-bolt"></i> Acciones Rápidas
            </h3>
            <div class="quick-actions">
                <a href="./?r=admin/dashboard" class="btn btn-primary">
                    <i class="fas fa-tachometer-alt"></i> Dashboard Principal
                </a>
                <a href="./?r=admin/logs" class="btn btn-warning">
                    <i class="fas fa-clipboard-list"></i> Ver Logs
                </a>
                <a href="./?r=admin/reports" class="btn btn-danger">
                    <i class="fas fa-flag"></i> Reportes Pendientes
                </a>
                <a href="./?r=admin/ads" class="btn btn-success">
                    <i class="fas fa-bullhorn"></i> Gestionar Anuncios
                </a>
            </div>
        </div>
    </div>

    <!-- Campana de Notificaciones -->
    <div class="notification-bell">
        <i class="fas fa-bell"></i>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Efectos de hover mejorados
            const cards = document.querySelectorAll('.control-card');
            cards.forEach(card => {
                card.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-8px) scale(1.02)';
                });
                
                card.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0) scale(1)';
                });
            });

            // Efecto de búsqueda
            const searchInput = document.querySelector('.search-box input');
            searchInput.addEventListener('focus', function() {
                this.parentElement.style.boxShadow = '0 8px 25px rgba(0, 0, 0, 0.15)';
                this.parentElement.style.transform = 'translateY(-5px)';
            });
            
            searchInput.addEventListener('blur', function() {
                this.parentElement.style.boxShadow = 'var(--shadow)';
                this.parentElement.style.transform = 'translateY(0)';
            });

            // Actualizar estado en tiempo real
            function updateSystemStatus() {
                // Simular actualización de datos
                const statusValues = document.querySelectorAll('.status-value');
                statusValues.forEach(value => {
                    const current = parseInt(value.textContent);
                    const change = Math.floor(Math.random() * 5) - 2; // Cambio aleatorio entre -2 y +2
                    const newValue = Math.max(0, current + change);
                    
                    // Animación de conteo
                    animateCount(value, current, newValue, 1000);
                });
                
                console.log('Estado del sistema actualizado');
            }

            // Función para animar contadores
            function animateCount(element, start, end, duration) {
                let startTimestamp = null;
                const step = (timestamp) => {
                    if (!startTimestamp) startTimestamp = timestamp;
                    const progress = Math.min((timestamp - startTimestamp) / duration, 1);
                    element.textContent = Math.floor(progress * (end - start) + start);
                    if (progress < 1) {
                        window.requestAnimationFrame(step);
                    }
                };
                window.requestAnimationFrame(step);
            }

            // Actualizar cada 30 segundos
            setInterval(updateSystemStatus, 30000);

            // Notificación de campana
            const notificationBell = document.querySelector('.notification-bell');
            notificationBell.addEventListener('click', function() {
                this.style.transform = 'scale(0.9)';
                setTimeout(() => {
                    this.style.transform = '';
                    alert('Tienes 3 notificaciones nuevas');
                }, 200);
            });
        });
    </script>
