<?php if (!function_exists('avatar_img')) { @include_once '../../helpers.php'; } ?>

<!-- Restored Admin Styles -->
<style>

        :root {
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --secondary: #6c757d;
            --success: #28a745;
            --danger: #dc3545;
            --warning: #ffc107;
            --info: #17a2b8;
            --light: #f8f9fa;
            --dark: #343a40;
            --bg-main: #f5f7f9;
            --bg-card: #ffffff;
            --text-main: #212529;
            --text-muted: #6c757d;
            --border: #dee2e6;
            --radius: 12px;
            --radius-sm: 8px;
            --shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            --shadow-lg: 0 8px 24px rgba(0, 0, 0, 0.12);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
        }

        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            color: var(--text-main);
            line-height: 1.6;
            min-height: 100vh;
            padding: 20px;
        }

        .admin-container {
            max-width: 1400px;
            margin: 0 auto;
        }

        .admin-header {
            display: flex;
            align-items: center;
            gap: 20px;
            margin-bottom: 30px;
            background: var(--bg-card);
            padding: 25px;
            border-radius: var(--radius);
            box-shadow: var(--shadow);
            border-left: 4px solid var(--primary);
        }

        .back-button {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            color: white;
            border: none;
            cursor: pointer;
            transition: var(--transition);
            text-decoration: none;
            box-shadow: 0 4px 12px rgba(67, 97, 238, 0.3);
        }

        .back-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(67, 97, 238, 0.4);
        }

        .admin-header h1 {
            font-size: 32px;
            font-weight: 700;
            color: var(--dark);
            margin-bottom: 5px;
        }

        .admin-header p {
            color: var(--text-muted);
            font-size: 16px;
            margin: 0;
        }

        .admin-stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 24px;
            margin-bottom: 30px;
        }

        .stat-card {
            background: var(--bg-card);
            border-radius: var(--radius);
            padding: 25px;
            box-shadow: var(--shadow);
            transition: var(--transition);
            border-left: 4px solid;
            position: relative;
            overflow: hidden;
        }

        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.8), transparent);
            opacity: 0;
            transition: var(--transition);
        }

        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: var(--shadow-lg);
        }

        .stat-card:hover::before {
            opacity: 1;
        }

        .stat-card.comments { border-left-color: var(--info); }
        .stat-card.today { border-left-color: var(--success); }
        .stat-card.users { border-left-color: var(--primary); }
        .stat-card.reports { border-left-color: var(--warning); }

        .stat-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        .stat-title {
            font-size: 14px;
            font-weight: 600;
            color: var(--text-muted);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .stat-icon {
            width: 54px;
            height: 54px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 22px;
            color: white;
        }

        .stat-card.comments .stat-icon { background: linear-gradient(135deg, var(--info), #138496); }
        .stat-card.today .stat-icon { background: linear-gradient(135deg, var(--success), #1e7e34); }
        .stat-card.users .stat-icon { background: linear-gradient(135deg, var(--primary), var(--primary-dark)); }
        .stat-card.reports .stat-icon { background: linear-gradient(135deg, var(--warning), #e0a800); }

        .stat-value {
            font-size: 36px;
            font-weight: 800;
            margin-bottom: 10px;
            color: var(--dark);
        }

        .stat-desc {
            font-size: 14px;
            color: var(--text-muted);
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .trend {
            font-size: 12px;
            font-weight: 600;
            padding: 4px 10px;
            border-radius: 20px;
            display: inline-flex;
            align-items: center;
            gap: 4px;
        }

        .trend.positive {
            background: rgba(40, 199, 111, 0.15);
            color: #28c76f;
            border: 1px solid rgba(40, 199, 111, 0.3);
        }

        .trend.negative {
            background: rgba(255, 77, 77, 0.15);
            color: #ff4d4d;
            border: 1px solid rgba(255, 77, 77, 0.3);
        }

        .filters {
            background: var(--bg-card);
            border-radius: var(--radius);
            padding: 25px;
            margin-bottom: 30px;
            box-shadow: var(--shadow);
            border: 1px solid var(--border);
        }

        .filter-form {
            display: flex;
            flex-direction: column;
            gap: 20px;
        }

        .filter-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
        }

        .filter-group {
            display: flex;
            flex-direction: column;
        }

        .filter-label {
            font-size: 14px;
            font-weight: 600;
            margin-bottom: 8px;
            color: var(--text-muted);
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .filter-input, .filter-select {
            padding: 12px 16px;
            border: 1px solid var(--border);
            border-radius: var(--radius-sm);
            font-size: 14px;
            transition: var(--transition);
            background: var(--bg-card);
        }

        .filter-input:focus, .filter-select:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.1);
            transform: translateY(-1px);
        }

        .filter-actions {
            display: flex;
            gap: 12px;
            justify-content: flex-end;
            padding-top: 10px;
            border-top: 1px solid var(--border);
        }

        .btn {
            padding: 12px 24px;
            border-radius: var(--radius-sm);
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            display: inline-flex;
            align-items: center;
            gap: 8px;
            border: none;
            text-decoration: none;
        }

        .btn-sm {
            padding: 10px 20px;
            font-size: 13px;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            color: white;
            box-shadow: 0 4px 12px rgba(67, 97, 238, 0.3);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(67, 97, 238, 0.4);
        }

        .btn-outline {
            background: transparent;
            border: 1px solid var(--border);
            color: var(--text-muted);
        }

        .btn-outline:hover {
            background: var(--bg-main);
            border-color: var(--primary);
            color: var(--primary);
        }

        .table-container {
            background: var(--bg-card);
            border-radius: var(--radius);
            overflow: hidden;
            box-shadow: var(--shadow);
            margin-bottom: 30px;
        }

        .table-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 25px;
            border-bottom: 1px solid var(--border);
            background: linear-gradient(135deg, #f8f9fa, #e9ecef);
        }

        .table-title {
            display: flex;
            align-items: center;
            gap: 12px;
            font-size: 20px;
            font-weight: 600;
            color: var(--dark);
        }

        .badge {
            background: var(--primary);
            color: white;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }

        .table-responsive {
            overflow-x: auto;
        }

        .data-table {
            width: 100%;
            border-collapse: collapse;
        }

        .data-table th {
            background: #f8f9fa;
            padding: 16px 20px;
            text-align: left;
            font-weight: 600;
            color: var(--text-muted);
            border-bottom: 1px solid var(--border);
            font-size: 13px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .data-table td {
            padding: 20px;
            border-bottom: 1px solid var(--border);
            vertical-align: top;
        }

        .data-table tr:hover {
            background: #f8f9fa;
        }

        .data-table tr:last-child td {
            border-bottom: none;
        }

        .user-cell {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .user-avatar {
            width: 42px;
            height: 42px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 16px;
            flex-shrink: 0;
        }

        .user-info-cell {
            display: flex;
            flex-direction: column;
        }

        .user-name {
            font-weight: 600;
            font-size: 14px;
            color: var(--dark);
        }

        .user-id {
            font-size: 12px;
            color: var(--text-muted);
        }

        .comment-content {
            max-width: 300px;
            line-height: 1.5;
            color: var(--dark);
        }

        .post-info .post-title {
            font-weight: 500;
            margin-bottom: 4px;
            color: var(--dark);
        }

        .post-info .post-id {
            font-size: 12px;
            color: var(--text-muted);
        }

        .timestamp {
            font-family: 'Courier New', monospace;
            font-size: 13px;
            color: var(--text-muted);
            white-space: nowrap;
        }

        .action-buttons {
            display: flex;
            gap: 8px;
        }

        .btn-action {
            width: 38px;
            height: 38px;
            border-radius: var(--radius-sm);
            display: flex;
            align-items: center;
            justify-content: center;
            border: 1px solid var(--border);
            background: transparent;
            color: var(--text-muted);
            cursor: pointer;
            transition: var(--transition);
            text-decoration: none;
        }

        .btn-action:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }

        .btn-view:hover {
            background: rgba(23, 162, 184, 0.1);
            color: var(--info);
            border-color: var(--info);
        }

        .btn-delete:hover {
            background: rgba(220, 53, 69, 0.1);
            color: var(--danger);
            border-color: var(--danger);
        }

        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: var(--text-muted);
        }

        .empty-state i {
            font-size: 64px;
            margin-bottom: 20px;
            opacity: 0.5;
        }

        .empty-state p {
            font-size: 16px;
            margin-bottom: 20px;
        }

        .pagination {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px 25px;
            border-top: 1px solid var(--border);
            background: #f8f9fa;
        }

        .pagination-info {
            font-size: 14px;
            color: var(--text-muted);
        }

        .pagination-controls {
            display: flex;
            gap: 8px;
        }

        .pagination-button {
            padding: 8px 16px;
            border: 1px solid var(--border);
            border-radius: var(--radius-sm);
            background: var(--bg-card);
            color: var(--text-main);
            cursor: pointer;
            transition: var(--transition);
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 6px;
            font-size: 14px;
        }

        .pagination-button:hover:not(.active) {
            background: var(--bg-main);
            border-color: var(--primary);
            color: var(--primary);
        }

        .pagination-button.active {
            background: var(--primary);
            color: white;
            border-color: var(--primary);
        }

        .pagination-button:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }

        @media (max-width: 1024px) {
            .admin-stats {
                grid-template-columns: repeat(2, 1fr);
            }
            
            .filter-row {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 768px) {
            .admin-stats {
                grid-template-columns: 1fr;
            }
            
            .admin-header {
                flex-direction: column;
                text-align: center;
                gap: 15px;
            }
            
            .table-header {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }
            
            .pagination {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }
            
            .action-buttons {
                flex-direction: column;
            }
        }
    
</style>
<?php
// src/views/admin/comments.php
?>

<div class="admin-container">
        <div class="admin-header">
            <a href="./?r=admin/dashboard" class="back-button" title="Volver al dashboard">
                <i class="fas fa-arrow-left"></i>
            </a>
            <div>
                <h1>Gestión de Comentarios</h1>
                <p>Administra y modera los comentarios del sistema</p>
            </div>
        </div>

        <?php if (!empty($_SESSION['flash']['success'])): ?>
            <div class="alert alert-success" style="background: rgba(40, 167, 69, 0.1); border: 1px solid var(--success); color: var(--success); padding: 16px; border-radius: var(--radius-sm); margin-bottom: 20px; display: flex; align-items: center; gap: 10px;">
                <i class="fas fa-check-circle"></i> <?= h(flash('success')) ?>
            </div>
        <?php endif; ?>
        <?php if (!empty($_SESSION['flash']['error'])): ?>
            <div class="alert alert-error" style="background: rgba(220, 53, 69, 0.1); border: 1px solid var(--danger); color: var(--danger); padding: 16px; border-radius: var(--radius-sm); margin-bottom: 20px; display: flex; align-items: center; gap: 10px;">
                <i class="fas fa-exclamation-circle"></i> <?= h(flash('error')) ?>
            </div>
        <?php endif; ?>

        <div class="admin-stats">
            <div class="stat-card comments">
                <div class="stat-header">
                    <div class="stat-title">Comentarios Totales</div>
                    <div class="stat-icon">
                        <i class="fas fa-comments"></i>
                    </div>
                </div>
                <div class="stat-value"><?= h($pagination['totalItems']) ?></div>
                <div class="stat-desc">
                    <span class="trend positive"><i class="fas fa-arrow-up"></i> 15%</span>
                    vs semana anterior
                </div>
            </div>

            <div class="stat-card today">
                <div class="stat-header">
                    <div class="stat-title">Comentarios Hoy</div>
                    <div class="stat-icon">
                        <i class="fas fa-calendar-day"></i>
                    </div>
                </div>
                <div class="stat-value"><?= h($stats['today_comments'] ?? 0) ?></div>
                <div class="stat-desc">
                    <span class="trend positive"><i class="fas fa-arrow-up"></i> 8%</span>
                    actividad diaria
                </div>
            </div>

            <div class="stat-card users">
                <div class="stat-header">
                    <div class="stat-title">Usuarios Activos</div>
                    <div class="stat-icon">
                        <i class="fas fa-users"></i>
                    </div>
                </div>
                <div class="stat-value"><?= h($stats['active_users'] ?? 0) ?></div>
                <div class="stat-desc">
                    <span class="trend positive"><i class="fas fa-arrow-up"></i> 12%</span>
                    comentando esta semana
                </div>
            </div>

            <div class="stat-card reports">
                <div class="stat-header">
                    <div class="stat-title">Reportados</div>
                    <div class="stat-icon">
                        <i class="fas fa-flag"></i>
                    </div>
                </div>
                <div class="stat-value"><?= h($stats['reported_comments'] ?? 0) ?></div>
                <div class="stat-desc">
                    <span class="trend <?= ($stats['reported_comments'] ?? 0) > 0 ? 'negative' : 'positive' ?>">
                        <i class="fas fa-arrow-<?= ($stats['reported_comments'] ?? 0) > 0 ? 'up' : 'down' ?>"></i>
                        <?= ($stats['reported_comments'] ?? 0) > 0 ? '5%' : '0%' ?>
                    </span>
                    necesita revisión
                </div>
            </div>
        </div>

        <div class="filters">
            <form method="get" class="filter-form">
                <input type="hidden" name="r" value="admin/comments">
                <div class="filter-row">
                    <div class="filter-group">
                        <label class="filter-label"><i class="fas fa-user"></i> Autor</label>
                        <input type="text" class="filter-input" name="author" placeholder="Nombre de usuario..." 
                               value="<?= h($_GET['author'] ?? '') ?>">
                    </div>
                    <div class="filter-group">
                        <label class="filter-label"><i class="fas fa-file-alt"></i> ID de Publicación</label>
                        <input type="text" class="filter-input" name="post" placeholder="ID de publicación..." 
                               value="<?= h($_GET['post'] ?? '') ?>">
                    </div>
                    <div class="filter-group">
                        <label class="filter-label"><i class="fas fa-search"></i> Contenido</label>
                        <input type="text" class="filter-input" name="content" placeholder="Buscar en comentarios..." 
                               value="<?= h($_GET['content'] ?? '') ?>">
                    </div>
                </div>
                <div class="filter-actions">
                    <button type="submit" class="btn btn-primary btn-sm">
                        <i class="fas fa-search"></i> Buscar
                    </button>
                    <a href="./?r=admin/comments" class="btn btn-outline btn-sm">
                        <i class="fas fa-undo"></i> Limpiar
                    </a>
                </div>
            </form>
        </div>

        <div class="table-container">
            <div class="table-header">
                <div class="table-title">
                    <i class="fas fa-comments"></i> Lista de Comentarios
                    <span class="badge"><?= $pagination['totalItems'] ?></span>
                </div>
                <div class="table-actions">
                    <button class="btn btn-outline btn-sm">
                        <i class="fas fa-download"></i> Exportar
                    </button>
                </div>
            </div>

            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Autor</th>
                            <th>Comentario</th>
                            <th>Publicación</th>
                            <th>Fecha</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($comments)): ?>
                            <?php foreach ($comments as $comment): ?>
                            <tr>
                                <td>
                                    <div class="user-cell">
                                        <div class="user-avatar" style="overflow:hidden;border-radius:50%;padding:0;background:none;">
                                            <?= strtoupper(substr($comment['username'], 0, 1)) ?>
                                        </div>
                                        <div class="user-info-cell">
                                            <div class="user-name"><?= h($comment['username']) ?></div>
                                            <div class="user-id">ID: <?= h($comment['user_id']) ?></div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="comment-content">
                                        <?= h($comment['comment']) ?>
                                    </div>
                                </td>
                                <td>
                                    <?php if (!empty($comment['post_caption'])): ?>
                                        <div class="post-info">
                                            <div class="post-title"><?= h(limit_text($comment['post_caption'], 50)) ?></div>
                                            <div class="post-id">ID: <?= h($comment['post_id']) ?></div>
                                        </div>
                                    <?php else: ?>
                                        <span class="muted">Publicación #<?= h($comment['post_id']) ?></span>
                                    <?php endif; ?>
                                </td>
                                <td class="timestamp"><?= h(fdt($comment['created_at'])) ?></td>
                                <td>
                                    <div class="action-buttons">
                                        <a href="./?r=posts/view&id=<?= h($comment['post_id']) ?>" 
                                           class="btn-action btn-view" title="Ver publicación">
                                            <i class="fas fa-external-link-alt"></i>
                                        </a>
                                        <form method="post" action="./?r=admin/delete-comment" 
                                              onsubmit="return confirm('¿Eliminar este comentario?')">
                                            <?= csrf_field() ?>
                                            <input type="hidden" name="comment_id" value="<?= h($comment['id']) ?>">
                                            <button class="btn-action btn-delete" title="Eliminar comentario">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="5" class="empty-state">
                                    <i class="fas fa-comments"></i>
                                    <p>No se encontraron comentarios</p>
                                    <a href="./?r=admin/comments" class="btn btn-primary btn-sm">Ver todos</a>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <?php if ($pagination['totalPages'] > 1): ?>
            <div class="pagination">
                <div class="pagination-info">
                    Mostrando <?= count($comments) ?> de <?= $pagination['totalItems'] ?> comentarios
                </div>
                <div class="pagination-controls">
                    <?php if ($pagination['page'] > 1): ?>
                        <a href="?r=admin/comments&page=1<?= !empty($_GET) ? '&' . http_build_query($_GET) : '' ?>" class="pagination-button">
                            <i class="fas fa-angle-double-left"></i>
                        </a>
                        <a href="?r=admin/comments&page=<?= $pagination['page'] - 1 ?><?= !empty($_GET) ? '&' . http_build_query($_GET) : '' ?>" class="pagination-button">
                            <i class="fas fa-angle-left"></i>
                        </a>
                    <?php endif; ?>

                    <?php
                    $start = max(1, $pagination['page'] - 2);
                    $end = min($pagination['totalPages'], $start + 4);
                    $start = max(1, $end - 4);
                    
                    for ($i = $start; $i <= $end; $i++): ?>
                        <a href="?r=admin/comments&page=<?= $i ?><?= !empty($_GET) ? '&' . http_build_query($_GET) : '' ?>" 
                           class="pagination-button <?= $i == $pagination['page'] ? 'active' : '' ?>">
                            <?= $i ?>
                        </a>
                    <?php endfor; ?>

                    <?php if ($pagination['page'] < $pagination['totalPages']): ?>
                        <a href="?r=admin/comments&page=<?= $pagination['page'] + 1 ?><?= !empty($_GET) ? '&' . http_build_query($_GET) : '' ?>" class="pagination-button">
                            <i class="fas fa-angle-right"></i>
                        </a>
                        <a href="?r=admin/comments&page=<?= $pagination['totalPages'] ?><?= !empty($_GET) ? '&' . http_build_query($_GET) : '' ?>" class="pagination-button">
                            <i class="fas fa-angle-double-right"></i>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
