<?php if (!function_exists('avatar_img')) { @include_once '../helpers.php'; } ?>
<!doctype html>
<html lang="es">
<head>
<?php
// Ensure DB connection uses UTC so timestamps (NOW()/CURRENT_TIMESTAMP) are in UTC.
// This prevents double offsets when rendering with fdt().
if (isset($db) && $db instanceof PDO) { try { $db->exec("/* SET time_zone = '+00:00' (disabled; use DB session UTC) */"); } catch (\Exception $e) {} }
if (isset($pdo) && $pdo instanceof PDO) { try { $pdo->exec("/* SET time_zone = '+00:00' (disabled; use DB session UTC) */"); } catch (\Exception $e) {} }
?>

<?php
// Base path de la app (para servir /uploads/... cuando la app vive en subcarpeta)
$scriptName = isset($_SERVER['SCRIPT_NAME']) ? $_SERVER['SCRIPT_NAME'] : '/';
$d = dirname($scriptName);              // p.ej. "/eventos" o "/"
if ($d === '\\' || $d === '.' || $d === '') { $d = '/'; }
$__base = rtrim(str_replace('\\','/', $d), '/'); // "" o "/eventos"
?>

  <meta
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Thirty</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    :root{
      --bg:#0b0c10; --panel:#12141a; --card:#0e1016; --card-hover:#151820; --border:#21242c; --border-light:#2a2e3a;
      --text:#e9eaf1; --muted:#a7acb9; --accent:#7cd1ff; --accent2:#b99cff; --accent3:#ff9cf2;
      --btn:#ffffff; --btnText:#0b0c10; --error:#ff4d4d; --success:#4dff88; --warning:#ffc44d;
      --radius:16px; --radius-sm:10px; --shadow:0 8px 24px rgba(0,0,0,0.2); --transition:all 0.3s ease;
      --accent-light: #6bc2ff; --accent2-light: #b59cff; --purple-light: #d6b3ff; --orange-light: #ffb366;
      --green-light: #66ff99; --blue-light: #66b3ff; --red: #ff4d4d;
      --gradient: linear-gradient(135deg, var(--accent), var(--accent2), var(--accent3));
    }
    *{box-sizing:border-box; margin:0; padding:0;}
    body{margin:0;background:linear-gradient(180deg, var(--bg) 0%, var(--panel) 100%);color:var(--text);
         font-family:'Segoe UI', system-ui, -apple-system, sans-serif; line-height:1.6; min-height:100vh;}
    a{color:inherit;text-decoration:none}
    .wrap{max-width:1200px;margin:0 auto;padding:20px}
    .top{position:sticky;top:0;z-index:1000;display:flex;align-items:center;justify-content:space-between;
         padding:15px 0;background:rgba(15, 17, 23, 0.92);backdrop-filter:blur(15px);border-bottom:1px solid var(--border);margin-bottom:30px;}
    .brand{display:inline-flex;align-items:center;gap:12px;font-weight:800;font-size:1.6rem;transition:var(--transition);padding:5px 10px;border-radius:var(--radius-sm);}
    .brand:hover{color:var(--accent);background:rgba(124, 209, 255, 0.1);}
    .dot{width:36px;height:36px;border-radius:12px;background:var(--gradient);display:flex;align-items:center;justify-content:center;box-shadow:0 6px 20px rgba(124,209,255,0.3);transition:var(--transition);}
    .brand:hover .dot{transform:rotate(15deg);}
    .dot i{font-size:16px;color:#fff;}
    .btn{padding:12px 22px;border-radius:var(--radius-sm);border:1px solid var(--border);background:transparent;color:var(--text);cursor:pointer;display:inline-flex;align-items:center;gap:8px;transition:var(--transition);font-weight:500;position:relative;overflow:hidden;}
    .btn:before{content:'';position:absolute;top:0;left:-100%;width:100%;height:100%;background:linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.1), transparent);transition:var(--transition);}
    .btn:hover:before{left:100%;}
    .btn:hover{background:rgba(255,255,255,0.05);border-color:var(--border-light);transform:translateY(-2px);}
    .btn.primary{background:var(--gradient);color:var(--btnText);font-weight:600;border:none;box-shadow:0 5px 15px rgba(124, 209, 255, 0.3);}
    .btn.primary:hover{box-shadow:0 8px 25px rgba(124, 209, 255, 0.4);transform:translateY(-3px);}
    .card{background:var(--card);border:1px solid var(--border);border-radius:var(--radius);padding:28px;transition:var(--transition);box-shadow:var(--shadow);position:relative;overflow:hidden;}
    .card:before{content:'';position:absolute;top:0;left:0;right:0;height:4px;background:var(--gradient);opacity:0;transition:var(--transition);}
    .card:hover{border-color:var(--border-light);transform:translateY(-8px);background:var(--card-hover);}
    .card:hover:before{opacity:1;}
    .muted{color:var(--muted)}
    .grid{display:grid;gap:25px;}
    input,textarea,select{width:100%;padding:14px;border-radius:var(--radius-sm);border:1px solid var(--border);background:rgba(15,18,24,0.5);color:var(--text);font-family:inherit;transition:var(--transition)}
    input:focus,textarea:focus,select:focus{outline:none;border-color:var(--accent);box-shadow:0 0 0 3px rgba(124,209,255,0.2)}
    .hero{padding:100px 0;text-align:center;background:radial-gradient(800px 400px at 50% -10%,rgba(124,209,255,0.22),transparent),radial-gradient(600px 300px at 0% 100%,rgba(185,156,255,0.18),transparent),radial-gradient(600px 300px at 100% 100%,rgba(255,156,242,0.18),transparent);border-radius:var(--radius);margin:30px 0;position:relative;overflow:hidden;}
    .hero:after{content:'';position:absolute;top:0;left:0;right:0;bottom:0;background:rgba(15, 17, 23, 0.6);z-index:-1;}
    .hero h1{margin:0 0 20px 0;font-size:3.5rem;font-weight:900;background:var(--gradient);-webkit-background-clip:text;background-clip:text;color:transparent;line-height:1.2;text-shadow:0 5px 15px rgba(0, 0, 0, 0.3);}
    .hero p{font-size:1.25rem;color:var(--muted);margin-bottom:40px;max-width:650px;margin-left:auto;margin-right:auto;line-height:1.6;}
    .thumb{border-radius:var(--radius);overflow:hidden;border:1px solid var(--border);background:var(--card);transition:var(--transition);position:relative}
    .thumb:hover{transform:translateY(-5px);border-color:var(--border-light);box-shadow:var(--shadow)}
    .thumb img{width:100%;height:auto;display:block}
    .thumb-overlay{position:absolute;bottom:0;left:0;right:0;background:linear-gradient(transparent,rgba(0,0,0,0.8));padding:16px;color:white}
    .thumb:hover .thumb-overlay{background:linear-gradient(transparent,rgba(0,0,0,0.9))}
    .row{display:flex;gap:20px;align-items:center;flex-wrap:wrap;justify-content:center;margin-bottom:20px;}
    .chips{display:flex;gap:10px;flex-wrap:wrap;margin:20px 0}
    .chip{background:rgba(124,209,255,0.1);border:1px solid rgba(124,209,255,0.2);padding:8px 16px;border-radius:20px;font-size:0.9rem;color:var(--accent);display:inline-flex;align-items:center;gap:6px;transition:var(--transition)}
    .chip:hover{background:rgba(124,209,255,0.2);transform:translateY(-2px);box-shadow:0 5px 15px rgba(0, 0, 0, 0.1);}
    .post-grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(250px,1fr));gap:16px;margin:20px 0}
    .alert{padding:16px;border-radius:var(--radius-sm);margin-bottom:20px;display:flex;align-items:center;gap:12px}
    .alert-error{background:rgba(255,77,77,0.1);border:1px solid var(--error);color:var(--error)}
    .alert-success{background:rgba(77,255,136,0.1);border:1px solid var(--success);color:var(--success)}
    .ranking-list{list-style:none}
    .ranking-item{display:flex;align-items:center;padding:12px;border-radius:var(--radius-sm);margin-bottom:10px;background:rgba(15,18,24,0.5);transition:var(--transition)}
    .ranking-item:hover{background:rgba(15,18,24,0.8)}
    .ranking-position{width:32px;height:32px;border-radius:50%;background:var(--accent);color:var(--btnText);display:flex;align-items:center;justify-content:center;font-weight:bold;margin-right:12px;flex-shrink:0}
    .ranking-1 .ranking-position{background:linear-gradient(135deg,#FFD700,#FFA500)}
    .ranking-2 .ranking-position{background:linear-gradient(135deg,#C0C0C0,#A9A9A9)}
    .ranking-3 .ranking-position{background:linear-gradient(135deg,#CD7F32,#8C6B46)}
    .ranking-points{font-weight:bold;color:var(--accent)}
    .footer{text-align:center;padding:60px 0 40px;margin-top:80px;border-top:1px solid var(--border);color:var(--muted);position:relative;background:var(--panel);}
    .footer:before{content:'';position:absolute;top:0;left:50%;transform:translateX(-50%);width:100px;height:4px;background:var(--gradient);border-radius:0 0 4px 4px;}
    .footer-links{display:flex;justify-content:center;gap:25px;margin:25px 0;flex-wrap:wrap;}
    .footer-link{color:var(--muted);text-decoration:none;transition:var(--transition);padding:8px 16px;border-radius:var(--radius-sm);}
    .footer-link:hover{color:var(--accent);background:rgba(124, 209, 255, 0.1);}
    
    /* Navigation improvements */
    .nav-menu{display:flex;gap:8px;align-items:center;}
    .user-menu{display:flex;align-items:center;gap:12px;}
    .user-avatar{width:36px;height:36px;border-radius:10px;background:linear-gradient(135deg, var(--accent), var(--accent2));display:flex;align-items:center;justify-content:center;color:white;font-weight:bold;font-size:14px;cursor:pointer;transition:var(--transition);}
    .user-avatar:hover{transform:scale(1.1);}
    
    /* NOTIFICATION BADGE - COMPLETELY REWRITTEN */
    .notification-wrapper {
        position: relative;
        display: inline-block;
    }
    
    .notification-badge {
        position: absolute;
        top: 2px;
        right: 2px;
        background: var(--accent3);
        color: white;
        border-radius: 50%;
        min-width: 18px;
        height: 18px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 10px;
        font-weight: bold;
        padding: 0;
        border: 2px solid rgba(15, 17, 23, 0.95);
        z-index: 10;
        line-height: 1;
    }
    
    /* Ajuste específico para el botón de notificaciones */
    #notification-btn {
        position: relative;
        padding: 12px 16px 12px 16px; /* Más padding a la derecha para el badge */
    }
    
    .btn.sm{padding:4px 12px;font-size:0.85rem;border-radius:6px;}
    .notification-item.unread{background:linear-gradient(135deg, rgba(124,209,255,0.08), rgba(185,156,255,0.08));border-left-width:6px;}
    .dropdown{position:relative;display:inline-block;}
    .dropdown-content{display:none;position:absolute;right:0;top:100%;background:var(--card);border:1px solid var(--border);border-radius:var(--radius-sm);min-width:200px;box-shadow:var(--shadow);z-index:1000;margin-top:8px;overflow:hidden;}
    .dropdown:hover .dropdown-content{display:block;}
    .dropdown-item{display:flex;align-items:center;gap:10px;padding:12px 16px;color:var(--text);text-decoration:none;transition:var(--transition);border-bottom:1px solid var(--border-light);}
    .dropdown-item:last-child{border-bottom:none;}
    .dropdown-item:hover{background:rgba(124, 209, 255, 0.1);color:var(--accent);}
    .dropdown-divider{height:1px;background:var(--border-light);margin:4px 0;}
    .grid-2{grid-template-columns:1fr 1fr;}
    .grid-3{grid-template-columns:repeat(auto-fit, minmax(300px, 1fr));}

    /* Estilos para el diseño mejorado de landing */
    .card-icon{width:70px;height:70px;border-radius:18px;background:rgba(124, 209, 255, 0.1);display:flex;align-items:center;justify-content:center;margin:0 auto 20px;color:var(--accent);font-size:1.8rem;}
    .stats{display:flex;gap:40px;justify-content:center;margin-top:30px;}
    .stat-item{text-align:center;}
    .stat-number{font-size:2.5rem;font-weight:700;background:var(--gradient);-webkit-background-clip:text;background-clip:text;color:transparent;line-height:1;}
    .stat-label{font-size:0.9rem;color:var(--muted);}

    @media (max-width: 900px){ 
      .post-grid{grid-template-columns:repeat(2,1fr);} 
      .grid-2, .grid-3{grid-template-columns:1fr;}
      .top{flex-direction:column;gap:16px;padding:16px 0;}
      .nav-menu{flex-wrap:wrap;justify-content:center;}
      .btn{padding:10px 18px;font-size:14px;}
      .dropdown-content{position:fixed;left:0;right:0;top:auto;bottom:0;border-radius:16px 16px 0 0;margin-top:0;}
      .stats{flex-wrap:wrap;}
      .hero h1{font-size:2.8rem;}
      
      /* Mobile notification badge adjustment */
      .notification-badge {
          top: 1px;
          right: 1px;
          min-width: 16px;
          height: 16px;
          font-size: 9px;
      }
      
      #notification-btn {
          padding: 10px 14px 10px 14px;
      }
    }
    
    @media (max-width: 600px){ 
      .post-grid{grid-template-columns:1fr;} 
      .hero h1{font-size:2.2rem;}
      .hero p{font-size:1.1rem;}
      .row{flex-direction:column;}
      .wrap{padding:16px;}
      .footer-links{flex-direction:column;gap:10px;}
    }
    
    @keyframes fadeIn{from{opacity:0;transform:translateY(20px);}to{opacity:1;transform:translateY(0);}}
    .animate{animation:fadeIn 0.6s ease forwards;opacity:0;}
    .delay-1{animation-delay:0.2s;} .delay-2{animation-delay:0.4s;} .delay-3{animation-delay:0.6s;}
    
    /* Pulse animation for notification badge */
    @keyframes pulse {
      0% { transform: scale(1); }
      50% { transform: scale(1.1); }
      100% { transform: scale(1); }
    }
    .notification-badge.pulse {
      animation: pulse 1s ease-in-out;
    }
  
/* === Full-bleed gradient bars (header & footer) === */
.top-bleed{position:fixed;top:0;left:0;right:0;height:3px;z-index:9999;
  background: linear-gradient(90deg, var(--accent), var(--accent2));}
.footer-bleed{position:relative;left:50%;transform:translateX(-50%);
  width:100vw;height:2px;background: linear-gradient(90deg, var(--accent), var(--accent2)); margin-bottom:12px;}
/* Footer compaction */
.footer{padding-top:14px !important;padding-bottom:18px !important;margin-top:24px;}
</style>

<?php
  $route = $_GET['r'] ?? 'dashboard';
  $is_admin_route = (strpos($route, 'admin/') === 0);
  if ($is_admin_route):
?>
<style>
:root { --bg: #0b0c10; --panel: #12141a; --card: #0e1016; --card-hover: #151820; --border: #21242c; --border-light: #2a2e3a; --text: #e9eaf1; --muted: #a7acb9; --accent: #8b5cf6; --accent-2: #06b6d4; --success: #22c55e; --danger: #ef4444; --warning: #f59e0b; }

/* --- Admin reset --- */
.admin-container{max-width:1200px;margin:24px auto;padding:0 16px;}
.admin-header{display:flex;align-items:center;justify-content:space-between;gap:16px;margin:12px 0 20px}
.back-button{display:inline-flex;align-items:center;justify-content:center;width:40px;height:40px;border-radius:12px;border:1px solid var(--border);background:var(--card);color:#fff}
.back-button:hover{background:var(--card-hover)}
.admin-stats{display:grid;grid-template-columns:repeat(4,minmax(0,1fr));gap:16px}
@media (max-width:1000px){.admin-stats{grid-template-columns:1fr 1fr}}
@media (max-width:640px){.admin-stats{grid-template-columns:1fr}}

.stat-card{background:var(--card);border:1px solid var(--border);border-radius:16px;padding:16px;box-shadow:0 10px 30px rgba(0,0,0,.25)}
.stat-header{display:flex;align-items:center;justify-content:space-between}
.stat-title{font-size:.9rem;color:var(--muted)}
.stat-icon{display:inline-flex;align-items:center;justify-content:center;width:40px;height:40px;border-radius:12px;background:linear-gradient(135deg,rgba(139,92,246,.18),rgba(6,182,212,.18));border:1px solid var(--border)}
.stat-value{font-size:1.6rem;font-weight:700}
.stat-desc{color:var(--muted);font-size:.9rem}
.trend.positive{color:#86efac}.trend.negative{color:#fca5a5}.trend.warning{color:#fcd34d}

.grid{display:grid;gap:16px}
.filters-grid{display:grid;gap:12px;grid-template-columns:repeat(4,minmax(0,1fr));margin:12px 0}
@media (max-width:1000px){.filters-grid{grid-template-columns:1fr 1fr}}
.filter-group{} .filter-label{font-size:.85rem;color:var(--muted);margin-bottom:6px;display:block}

.card{background:var(--card);border:1px solid var(--border);border-radius:16px;padding:16px;box-shadow:0 10px 30px rgba(0,0,0,.25)}
.card-header{display:flex;align-items:center;justify-content:space-between;margin-bottom:12px}
.card-title{margin:0;font-size:1.1rem}

.btn{display:inline-flex;align-items:center;gap:8px;padding:10px 14px;border-radius:12px;border:1px solid var(--border);background:#0f1218;color:#fff;text-decoration:none;cursor:pointer}
.btn:hover{background:#151922}
.btn-sm{padding:8px 10px;font-size:.9rem}
.btn-primary{border-color:rgba(139,92,246,.3);background:linear-gradient(135deg,rgba(139,92,246,.2),rgba(6,182,212,.2))}
.btn-outline{background:transparent}
.btn-icon{width:36px;height:36px;display:inline-flex;align-items:center;justify-content:center;border-radius:10px;border:1px solid var(--border)}

.input,.select,.form-input{width:100%;padding:10px 12px;border-radius:12px;border:1px solid var(--border);background:#0d1117;color:#fff;outline:none}
.form-group{display:grid;gap:6px}
.form-label{font-size:.85rem;color:var(--muted)}
.form-help{color:var(--muted);font-size:.8rem}

.table{width:100%;border-collapse:separate;border-spacing:0;border:1px solid var(--border);border-radius:12px;overflow:hidden}
.table th,.table td{padding:12px 14px;border-bottom:1px solid var(--border-light);text-align:left}
.table th{background:#0d1117;font-weight:600}
.table tr:hover{background:rgba(255,255,255,.03)}

.badge{padding:.25rem .5rem;border-radius:999px;border:1px solid var(--border-light);font-size:.75rem}
.badge.positive{background:rgba(34,197,94,.1);border-color:rgba(34,197,94,.3);color:#86efac}
.badge.warning{background:rgba(245,158,11,.1);border-color:rgba(245,158,11,.3);color:#fcd34d}
.badge.negative{background:rgba(239,68,68,.1);border-color:rgba(239,68,68,.3);color:#fca5a5}

.pagination{display:flex;gap:8px;align-items:center;justify-content:flex-end;margin-top:12px}
.pagination-button{border:1px solid var(--border);padding:8px 12px;border-radius:10px;background:#0f1218;color:#fff}
.pagination-button:hover{background:#151922}

.actions{display:flex;gap:8px;flex-wrap:wrap}
.modal{position:fixed;inset:0;display:none;align-items:center;justify-content:center;background:rgba(0,0,0,.55)}
.modal.show{display:flex}
.modal-card{background:var(--card);border:1px solid var(--border);border-radius:16px;padding:16px;width:96%;max-width:520px}
.modal-form-group{display:grid;gap:6px;margin:10px 0}
.modal-label{font-size:.85rem;color:var(--muted)}
.modal-input{width:100%;padding:10px 12px;border-radius:12px;border:1px solid var(--border);background:#0d1117;color:#fff}

</style>
<?php endif; ?>

</head>
<body>
  <div class="top-bleed"></div>
  <div class="wrap">
    <div class="top">
      <?php $homeHref = empty($_SESSION['user']) ? './' : './?r=dashboard'; ?>
      <a href="<?= $homeHref ?>" class="brand" title="Ir al inicio">
        <span class="dot"><i class="fas fa-asterisk"></i></span><span>Thirty</span>
      </a>
      
      <div class="nav-menu">
        <?php if(empty($_SESSION['user'])): ?>
          <a class="btn" href="./?r=login"><i class="fas fa-sign-in-alt"></i> Acceder</a>
          <a class="btn primary" href="./?r=register"><i class="fas fa-user-plus"></i> Crear cuenta</a>
        <?php else: ?>
          <a class="btn" href="./?r=dashboard"><i class="fas fa-home"></i> Inicio</a>
          <a class="btn" href="./?r=friends"><i class="fas fa-users"></i> Amigos</a>
          <a class="btn" href="./?r=ranking"><i class="fas fa-trophy"></i> Ranking</a>
          <a class="btn" href="./?r=invites"><i class="fas fa-ticket-alt"></i> Invitaciones</a>
          <a class="btn" href="./?r=posts"><i class="fas fa-image"></i> Mis posts</a>
          
          <div class="user-menu">
            <div class="notification-wrapper">
              <a class="btn" href="./?r=notifications" title="Notificaciones" id="notification-btn">
                <i class="fas fa-bell"></i>
                <?php 
                // Contador de notificaciones no leídas
                $unread_count = $_SESSION['unread_notifications'] ?? 0;
                if ($unread_count > 0): ?>
                  <span class="notification-badge <?php echo $unread_count > 0 ? 'pulse' : ''; ?>" id="notification-badge">
                    <?php echo $unread_count > 9 ? '9+' : $unread_count; ?>
                  </span>
                <?php endif; ?>
              </a>
            </div>
            
            <!-- Menú desplegable del avatar -->
            <div class="dropdown">
              <div class="user-avatar" title="Mi perfil" style="overflow:hidden;border-radius:50%;padding:0;background:none;">
                <?php
                $avatar = isset($_SESSION['user']['avatar_url']) ? $_SESSION['user']['avatar_url'] : '';
                if ($avatar && substr($avatar, 0, 9) === '/uploads/' && isset($__base) && $__base !== '' && $__base !== '/') {
                  $avatar = $__base . $avatar;
                }
                if ($avatar) {
                  if (!function_exists('h')) { function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); } }
                  echo '<img src="'.h($avatar).'" alt="Avatar" style="width:32px;height:32px;border-radius:50%;object-fit:cover;display:block;">';
                } else {
                  $initial = !empty($_SESSION['user']['username']) ? strtoupper(substr($_SESSION['user']['username'], 0, 1)) : 'U';
                  echo '<span style="width:32px;height:32px;border-radius:50%;display:inline-flex;align-items:center;justify-content:center;background:#333;color:#aaa;font-weight:700;">'.h($initial).'</span>';
                }
                ?></div>
              <div class="dropdown-content">
                <div class="dropdown-item">
                  <i class="fas fa-user"></i>
                  <span>@<?php echo $_SESSION['user']['username']; ?></span>
                </div>
                <div class="dropdown-divider"></div>
                <a href="./?r=profile" class="dropdown-item">
                  <i class="fas fa-user-circle"></i>
                  <span>Mi perfil</span>
                </a>
                
                <!-- Enlace al panel de administración en el menú desplegable CORREGIDO -->
                <?php if (!empty($_SESSION['user']['role']) && in_array($_SESSION['user']['role'], ['admin', 'moderator'])): ?>
                  <a href="./?r=admin/dashboard" class="dropdown-item" style="color: var(--accent3);">
                    <i class="fas fa-crown"></i>
                    <span>Panel de administración</span>
                  </a>
                <?php endif; ?>
                
                <div class="dropdown-divider"></div>
                <a href="./?r=logout" class="dropdown-item" style="color: var(--error);">
                  <i class="fas fa-sign-out-alt"></i>
                  <span>Cerrar sesión</span>
                </a>
              </div>
            </div>
          </div>
        <?php endif; ?>
      </div>
    </div>

    <!-- Mostrar mensajes flash -->
    <?php if ($error = flash('error')): ?>
      <div class="alert alert-error">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo h($error); ?>
      </div>
    <?php endif; ?>

    <?php if ($success = flash('success')): ?>
      <div class="alert alert-success">
        <i class="fas fa-check-circle"></i>
        <?php echo h($success); ?>
      </div>
    <?php endif; ?>