<?php if (!function_exists('avatar_img')) { @include_once '../helpers.php'; } ?>
  <div class="footer-bleed"></div>
  <footer class="footer">
      <div>
        <p>© 2025 Thirty - La red social de tus amigos de verdad</p>
        <div class="footer-links">
          <a href="#" class="footer-link">Privacidad</a>
          <a href="#" class="footer-link">Términos</a>
          <a href="#" class="footer-link">Soporte</a>
          <a href="#" class="footer-link">Acerca de</a>
        </div>
      </div>
    </footer>
  </div>
  <script>
    // Pequeñas interacciones para mejorar la UX
    document.addEventListener('DOMContentLoaded', function() {
      // Efecto de aparición escalonada para elementos
      const animatedElements = document.querySelectorAll('.animate');
      animatedElements.forEach(el => {
        el.style.opacity = '0';
      });
      
      setTimeout(() => {
        animatedElements.forEach(el => {
          el.style.opacity = '1';
        });
      }, 100);
      
      // Efecto hover en botones
      const buttons = document.querySelectorAll('.btn');
      buttons.forEach(btn => {
        btn.addEventListener('mouseenter', function() {
          this.style.transform = 'translateY(-2px)';
        });
        
        btn.addEventListener('mouseleave', function() {
          this.style.transform = 'translateY(0)';
        });
      });
    });
  </script>

<!-- SSE realtime notifications (placed in footer to guarantee execution) -->
<script>
(function(){
  let es = null;
  function $(sel){ return document.querySelector(sel); }
  function $all(sel){ return Array.from(document.querySelectorAll(sel)); }
  function updateTargets(count){
    const n = parseInt(count||0,10);
    const badge = document.getElementById('notification-badge');
    if (badge){
      if(n>0){ badge.textContent = n>9?'9+':String(n); badge.style.display='inline-flex'; }
      else { badge.textContent=''; badge.style.display='none'; }
    }
    const ctas = $all('a[href*="r=notifications"], button[data-notifications]');
    ctas.forEach(el=>{
      el.dataset.unread = n>0 ? '1' : '0';
      if(n>0){
        if(!el.querySelector('.notif-dot')){
          const dot=document.createElement('span');
          dot.className='notif-dot'; dot.style.marginLeft='8px';
          dot.style.width='8px'; dot.style.height='8px'; dot.style.display='inline-block';
          dot.style.borderRadius='999px'; dot.style.background='linear-gradient(135deg,#a78bfa,#22d3ee)';
          el.appendChild(dot);
        }
      }else{
        const d=el.querySelector('.notif-dot'); if(d) d.remove();
      }
    });
  }
  function connect(){
    if (typeof EventSource === 'undefined'){ backup(); setInterval(backup, 30000); return; }
    if(es){ es.close(); }
    es = new EventSource('./src/api/notifications/stream.php');
    es.onmessage = (e)=>{
      try { const data = JSON.parse(e.data||'{}'); updateTargets(data.count); if(window.refreshNotifsList) window.refreshNotifsList(); } catch(_){}
    };
    es.onerror = ()=>{ try{ es.close(); }catch(_){}; setTimeout(connect, 5000); };
    // safety: initial backup after 1s in case SSE tarda en abrir
    setTimeout(backup, 1000);
  }
  async function backup(){
    try{
      const r = await fetch('./?r=notifications/count&t=' + Date.now(), {headers:{'Cache-Control':'no-cache'}});
      const d = await r.json(); updateTargets(d.count);
    }catch(_){}
  }
  // start after full page load to avoid blocking onload
  window.addEventListener('load', connect);
  // also retry backup every 30s
  setInterval(backup, 30000);
  window.addEventListener('focus', backup);
  document.addEventListener('visibilitychange', ()=>{ if(document.visibilityState==='visible') backup(); });
})();
</script>

</body>
</html>