<?php
// SSE stream for notifications
require_once __DIR__ . '/../../helpers.php';
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../Database.php';

secure_session_start();
require_login();
// close session to avoid locking other requests
session_write_close();

// DB connection
$config = include __DIR__ . '/../../config.php';
$db = Database::getConnection($config);

// SSE headers
header('Content-Type: text/event-stream');
header('Cache-Control: no-cache');
header('Connection: keep-alive');
@ini_set('zlib.output_compression', 0);
@ini_set('output_buffering', 'off');
while (ob_get_level() > 0) { @ob_end_flush(); }

ignore_user_abort(true);
set_time_limit(0);

$user_id = $_SESSION['user']['id'];
$last = -1;
$start = time();

function sse_send($event, $data) {
    echo "event: {$event}\n";
    echo "data: " . json_encode($data, JSON_UNESCAPED_UNICODE) . "\n\n";
    @ob_flush(); @flush();
}

while (true) {
    if (connection_aborted()) { break; }
    if (time() - $start > 25) { // rotate each 60s
        sse_send('close', ['msg' => 'rotate']);
        break;
    }
    try {
        $stmt = $db->prepare("SELECT COUNT(*) FROM notifications WHERE user_id = ? AND is_read = 0");
        $stmt->execute([$user_id]);
        $count = (int)$stmt->fetchColumn();
        if ($count !== $last) {
            $last = $count;
            sse_send('message', ['count' => $count]);
        }
    } catch (Throwable $e) {
        sse_send('error', ['msg' => 'db_error']);
        break;
    }
    echo ":\n\n"; // heartbeat comment to keep connection alive
@ob_flush(); @flush();
sleep(2);
}
