-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Servidor: 127.0.0.1
-- Tiempo de generación: 13-10-2025 a las 12:54:20
-- Versión del servidor: 10.4.32-MariaDB
-- Versión de PHP: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de datos: `thirty`
--

DELIMITER $$
--
-- Procedimientos
--
CREATE DEFINER=`root`@`localhost` PROCEDURE `ensure_pk_bigint_ai` (IN `t` VARCHAR(64), IN `c` VARCHAR(64))   BEGIN
  IF NOT EXISTS (
    SELECT 1
    FROM information_schema.table_constraints
    WHERE table_schema = DATABASE()
      AND table_name = t
      AND constraint_type = 'PRIMARY KEY'
  ) THEN
    SET @sql = CONCAT('ALTER TABLE `', t, '` ',
                      'MODIFY `', c, '` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT, ',
                      'ADD PRIMARY KEY (`', c, '`)');
    PREPARE stmt FROM @sql; EXECUTE stmt; DEALLOCATE PREPARE stmt;
  END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `ensure_pk_uuid` (IN `t` VARCHAR(64), IN `c` VARCHAR(64))   BEGIN
  IF NOT EXISTS (
    SELECT 1
    FROM information_schema.table_constraints
    WHERE table_schema = DATABASE()
      AND table_name = t
      AND constraint_type = 'PRIMARY KEY'
  ) THEN
    SET @sql = CONCAT('ALTER TABLE `', t, '` ',
                      'MODIFY `', c, '` CHAR(36) NOT NULL, ',
                      'ADD PRIMARY KEY (`', c, '`)');
    PREPARE stmt FROM @sql; EXECUTE stmt; DEALLOCATE PREPARE stmt;
  END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `ensure_pk_varchar` (IN `t` VARCHAR(64), IN `c` VARCHAR(64))   BEGIN
  IF NOT EXISTS (
    SELECT 1
    FROM information_schema.table_constraints
    WHERE table_schema = DATABASE()
      AND table_name = t
      AND constraint_type = 'PRIMARY KEY'
  ) THEN
    SET @sql = CONCAT('ALTER TABLE `', t, '` ',
                      'MODIFY `', c, '` VARCHAR(36) NOT NULL, ',
                      'ADD PRIMARY KEY (`', c, '`)');
    PREPARE stmt FROM @sql; EXECUTE stmt; DEALLOCATE PREPARE stmt;
  END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `UpdateAdStatusAutomatically` ()   BEGIN
    -- Actualizar anuncios que han expirado
    UPDATE ads 
    SET status = 'expired' 
    WHERE status IN ('active', 'pending') 
    AND end_date < NOW();
    
    -- Activar anuncios programados
    UPDATE ads 
    SET status = 'active' 
    WHERE status = 'pending' 
    AND start_date <= NOW() 
    AND end_date > NOW();
    
    -- Pausar anuncios activos que han pasado su fecha de fin (por si acaso)
    UPDATE ads 
    SET status = 'paused' 
    WHERE status = 'active' 
    AND end_date < NOW();
END$$

--
-- Funciones
--
CREATE DEFINER=`root`@`localhost` FUNCTION `generate_conversation_id` (`user1` CHAR(36), `user2` CHAR(36)) RETURNS CHAR(73) CHARSET utf8mb4 COLLATE utf8mb4_general_ci DETERMINISTIC BEGIN
  IF user1 < user2 THEN
    RETURN CONCAT(user1, '-', user2);
  ELSE
    RETURN CONCAT(user2, '-', user1);
  END IF;
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `ads`
--

CREATE TABLE `ads` (
  `id` char(36) NOT NULL DEFAULT uuid(),
  `title` varchar(200) NOT NULL,
  `description` text DEFAULT NULL,
  `image_url` varchar(500) NOT NULL,
  `target_url` varchar(500) NOT NULL,
  `advertiser` varchar(100) NOT NULL,
  `budget` decimal(10,2) NOT NULL DEFAULT 0.00,
  `status` enum('pending','active','paused','expired') DEFAULT 'pending',
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `impressions` int(11) NOT NULL DEFAULT 0,
  `clicks` int(11) NOT NULL DEFAULT 0,
  `max_impressions` int(11) DEFAULT NULL,
  `target_audience` enum('all','friends','new_users','verified') DEFAULT 'all',
  `created_by` char(36) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `ads`
--

INSERT INTO `ads` (`id`, `title`, `description`, `image_url`, `target_url`, `advertiser`, `budget`, `status`, `start_date`, `end_date`, `impressions`, `clicks`, `max_impressions`, `target_audience`, `created_by`, `created_at`, `updated_at`) VALUES
('92ccb0a7-9baa-11f0-830d-0050565a1c59', 'Manoloo', 'dskdjaksjdka', '/uploads/ads/ad_68d7ee66be467_1758981734.png', 'https://www.marca.com/', 'ddd', 20.00, 'expired', '2025-09-24 22:00:00', '2025-10-01 22:00:00', 24, 3, 60, 'all', '8194d00a-8f3b-11f0-b588-0050565a1c59', '2025-09-27 14:02:14', '2025-10-03 00:42:06'),
('a0fcb0dd-9b9e-11f0-830d-0050565a1c59', 'Bievenido a Croke', 'SJKDjkajkdjk', '/uploads/ads/ad_68d7da5c9e591_1758976604.png', 'https://www.facebook.com/crokedocelaredo/', 'Croke', 10.00, 'expired', '2025-09-26 22:00:00', '2025-10-01 23:59:00', 30, 3, 30, 'all', '8194d00a-8f3b-11f0-b588-0050565a1c59', '2025-09-27 12:36:44', '2025-10-03 00:42:06');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `ad_impressions`
--

CREATE TABLE `ad_impressions` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `ad_id` char(36) NOT NULL,
  `user_id` char(36) DEFAULT NULL,
  `session_id` varchar(128) DEFAULT NULL,
  `placement` varchar(64) DEFAULT 'feed',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `comments`
--

CREATE TABLE `comments` (
  `id` char(36) NOT NULL,
  `parent_id` char(36) DEFAULT NULL,
  `post_id` char(36) NOT NULL,
  `user_id` char(36) NOT NULL,
  `comment` text NOT NULL,
  `reply_to` char(36) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `comments`
--

INSERT INTO `comments` (`id`, `parent_id`, `post_id`, `user_id`, `comment`, `reply_to`, `created_at`, `updated_at`) VALUES
('1fcf7707-95ce-4169-a553-b351f3d372df', NULL, '97ffaa45-1f47-4f4c-ae64-39214ad08ff9', '8194d00a-8f3b-11f0-b588-0050565a1c59', 'eee', '26151051-1902-4601-9194-42e8891d63a5', '2025-10-09 19:54:55', '2025-10-09 19:54:55'),
('26151051-1902-4601-9194-42e8891d63a5', NULL, '97ffaa45-1f47-4f4c-ae64-39214ad08ff9', '8194d00a-8f3b-11f0-b588-0050565a1c59', 'ee', NULL, '2025-10-09 19:54:31', '2025-10-09 21:54:31'),
('416a8324-f6d5-41e6-85c9-ed2b3a575b0b', NULL, 'dad8fe7d-716a-4086-916e-eb4e73ca1b0f', '8194d00a-8f3b-11f0-b588-0050565a1c59', 'ee', NULL, '2025-09-14 11:29:41', '2025-09-14 11:29:41'),
('503e9d55-6cbf-4247-a05d-0e54e7332e6a', NULL, 'be2131e2-80c6-4a32-b601-d1cb421b3e74', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', 'ee', '50ac977b-6d16-4581-b60f-ceb1c36ac2aa', '2025-09-14 12:37:24', '2025-09-14 12:37:24'),
('50ac977b-6d16-4581-b60f-ceb1c36ac2aa', NULL, 'be2131e2-80c6-4a32-b601-d1cb421b3e74', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', 'ee', NULL, '2025-09-14 12:37:19', '2025-09-14 12:37:19'),
('ac5bf2d1-5dd5-468e-8d3e-41336d31fb5f', NULL, '97ffaa45-1f47-4f4c-ae64-39214ad08ff9', '8194d00a-8f3b-11f0-b588-0050565a1c59', 'ee', '26151051-1902-4601-9194-42e8891d63a5', '2025-10-09 19:54:49', '2025-10-09 19:54:49'),
('e7198e3a-d9bf-4e31-939b-7290918deb39', NULL, 'ac4e89ca-50f5-41b8-a8dc-e15670f04c99', '8194d00a-8f3b-11f0-b588-0050565a1c59', 'ee', NULL, '2025-09-15 18:02:19', '2025-09-15 18:02:19');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `comment_replies`
--

CREATE TABLE `comment_replies` (
  `id` varchar(36) NOT NULL,
  `comment_id` varchar(36) NOT NULL,
  `user_id` varchar(36) NOT NULL,
  `content` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `email_verifications`
--

CREATE TABLE `email_verifications` (
  `id` char(36) NOT NULL,
  `user_id` char(36) NOT NULL,
  `token` char(64) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `expires_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `email_verifications`
--

INSERT INTO `email_verifications` (`id`, `user_id`, `token`, `created_at`, `expires_at`) VALUES
('c0b634c8-922c-11f0-87d2-0050565a1c59', 'c0b40277-922c-11f0-87d2-0050565a1c59', '0d0c20ab9ca421a896d2e865a209cbc9fd3f5004e3c2d84eee4d063ec951dade', '2025-09-15 12:08:55', '2025-09-16 14:08:55');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `friends`
--

CREATE TABLE `friends` (
  `id` varchar(36) NOT NULL DEFAULT uuid(),
  `user1_id` varchar(36) NOT NULL,
  `user2_id` varchar(36) NOT NULL,
  `status` enum('pending','accepted','rejected') DEFAULT 'pending',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `friends`
--

INSERT INTO `friends` (`id`, `user1_id`, `user2_id`, `status`, `created_at`, `updated_at`) VALUES
('93d565b1-a3cb-11f0-a405-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', 'accepted', '2025-10-07 22:18:39', '2025-10-07 22:18:44');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `friendships`
--

CREATE TABLE `friendships` (
  `id` char(36) NOT NULL,
  `a_id` char(36) NOT NULL,
  `b_id` char(36) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `interactions`
--

CREATE TABLE `interactions` (
  `id` char(36) NOT NULL,
  `user_id` char(36) NOT NULL,
  `target_id` char(36) NOT NULL,
  `type` enum('view','like','comment','share') NOT NULL,
  `weight` int(11) NOT NULL DEFAULT 1,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `invites`
--

CREATE TABLE `invites` (
  `id` char(36) NOT NULL,
  `code` varchar(100) NOT NULL,
  `issued_by` char(36) DEFAULT NULL,
  `used_by` char(36) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `used_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `invites`
--

INSERT INTO `invites` (`id`, `code`, `issued_by`, `used_by`, `created_at`, `used_at`) VALUES
('091ad672-8f37-11f0-b588-0050565a1c59', 'DEMO-INVITE-1234', NULL, '8194d00a-8f3b-11f0-b588-0050565a1c59', '2025-09-11 19:44:57', '2025-09-11 20:16:57'),
('bba56112-922c-11f0-87d2-0050565a1c59', 'INV-AA6A3EB3', '8194d00a-8f3b-11f0-b588-0050565a1c59', 'c0b40277-922c-11f0-87d2-0050565a1c59', '2025-09-15 12:08:46', '2025-09-15 12:08:55'),
('dc61189c-8f3e-11f0-b588-0050565a1c59', 'INV-35FD5D4F', '8194d00a-8f3b-11f0-b588-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '2025-09-11 20:40:58', '2025-09-12 00:09:09');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `likes`
--

CREATE TABLE `likes` (
  `id` char(36) NOT NULL,
  `post_id` char(36) NOT NULL,
  `user_id` char(36) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `likes`
--

INSERT INTO `likes` (`id`, `post_id`, `user_id`, `created_at`) VALUES
('031afb97-2293-47b6-813c-910830bbd711', 'dad8fe7d-716a-4086-916e-eb4e73ca1b0f', '8194d00a-8f3b-11f0-b588-0050565a1c59', '2025-10-08 00:56:38'),
('0c3b29a2-80a2-4b2d-a1d2-6e6206356605', '290dc57a-1d73-4047-b96e-c475617406e3', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '2025-09-13 11:01:11'),
('187fa036-f044-4c51-bdd0-0939af0cc0ed', 'ac4e89ca-50f5-41b8-a8dc-e15670f04c99', '8194d00a-8f3b-11f0-b588-0050565a1c59', '2025-09-21 18:17:58'),
('5c18eb20-851c-424a-8ef2-932ea3dc24ea', 'be2131e2-80c6-4a32-b601-d1cb421b3e74', '8194d00a-8f3b-11f0-b588-0050565a1c59', '2025-10-08 09:52:11'),
('a47acf27-2c57-4846-822d-95fa67c9ffaf', '290dc57a-1d73-4047-b96e-c475617406e3', '8194d00a-8f3b-11f0-b588-0050565a1c59', '2025-09-25 12:33:59'),
('a9f5bf90-3437-4ed9-bf59-d6f499d3158f', '97ffaa45-1f47-4f4c-ae64-39214ad08ff9', '8194d00a-8f3b-11f0-b588-0050565a1c59', '2025-10-09 19:37:53'),
('d0cdae85-5214-4c41-865d-0078d793985c', 'be2131e2-80c6-4a32-b601-d1cb421b3e74', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '2025-10-08 11:54:53'),
('e42b1554-1f25-42eb-a8bf-3b68ef498162', 'b3a48d67-52c5-4704-a32a-68edeecdde4e', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '2025-09-13 11:01:13');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `login_attempts`
--

CREATE TABLE `login_attempts` (
  `id` char(36) NOT NULL,
  `rate_key` varchar(191) NOT NULL,
  `attempts` int(11) NOT NULL DEFAULT 1,
  `first_attempt` datetime NOT NULL DEFAULT current_timestamp(),
  `last_attempt` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `locked_until` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `login_attempts`
--

INSERT INTO `login_attempts` (`id`, `rate_key`, `attempts`, `first_attempt`, `last_attempt`, `locked_until`) VALUES
('97a524ad-9986-11f0-87d2-0050565a1c59', 'user:contacto@entradasfresh.es', 3, '2025-09-24 20:39:34', '2025-10-08 09:54:36', NULL);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `messages`
--

CREATE TABLE `messages` (
  `id` char(36) NOT NULL,
  `from_id` char(36) NOT NULL,
  `to_id` char(36) NOT NULL,
  `text` text NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `notifications`
--

CREATE TABLE `notifications` (
  `id` char(36) NOT NULL,
  `user_id` char(36) NOT NULL,
  `type` enum('friend_request','friend_accept','message','tag','like','comment') NOT NULL,
  `related_user_id` char(36) DEFAULT NULL,
  `related_post_id` char(36) DEFAULT NULL,
  `message` text NOT NULL,
  `is_read` tinyint(1) DEFAULT 0,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `notifications`
--

INSERT INTO `notifications` (`id`, `user_id`, `type`, `related_user_id`, `related_post_id`, `message`, `is_read`, `created_at`) VALUES
('439e4c75-ed77-4467-a1f8-657dde23f0f9', '8194d00a-8f3b-11f0-b588-0050565a1c59', 'like', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', 'be2131e2-80c6-4a32-b601-d1cb421b3e74', 'Moleno25 dio like a tu publicación', 1, '2025-10-07 22:58:23'),
('44b588b2-6aa7-4a44-b700-370fed6ad8ec', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', 'like', '8194d00a-8f3b-11f0-b588-0050565a1c59', 'dad8fe7d-716a-4086-916e-eb4e73ca1b0f', 'Mortii25 dio like a tu publicación', 1, '2025-10-08 00:56:38'),
('5edd5e31-2bd3-4b96-a47d-ae9e591200be', '8194d00a-8f3b-11f0-b588-0050565a1c59', 'like', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', 'be2131e2-80c6-4a32-b601-d1cb421b3e74', 'Moleno25 dio like a tu publicación', 1, '2025-10-08 11:54:53'),
('91bf8afa-ab27-4ae7-9e3c-eb5522dd4acd', '8194d00a-8f3b-11f0-b588-0050565a1c59', 'like', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', 'be2131e2-80c6-4a32-b601-d1cb421b3e74', 'Moleno25 dio like a tu publicación', 1, '2025-10-07 22:46:58'),
('bd7987cf-1150-4866-8dae-2596be306120', '8194d00a-8f3b-11f0-b588-0050565a1c59', 'like', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', 'be2131e2-80c6-4a32-b601-d1cb421b3e74', 'Moleno25 dio like a tu publicación', 1, '2025-10-08 00:54:12'),
('e1fe8dec-d1b6-4a83-b061-3df65a1729db', '8194d00a-8f3b-11f0-b588-0050565a1c59', 'like', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', 'be2131e2-80c6-4a32-b601-d1cb421b3e74', 'Moleno25 dio like a tu publicación', 1, '2025-10-07 22:48:03'),
('f5773e55-ebf9-418f-9d2e-4ff7bb5b06e8', '8194d00a-8f3b-11f0-b588-0050565a1c59', 'like', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', 'be2131e2-80c6-4a32-b601-d1cb421b3e74', 'Moleno25 dio like a tu publicación', 1, '2025-10-07 22:35:51');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `password_resets`
--

CREATE TABLE `password_resets` (
  `id` char(36) NOT NULL,
  `user_id` char(36) NOT NULL,
  `token` char(64) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `expires_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `photos`
--

CREATE TABLE `photos` (
  `id` char(36) NOT NULL,
  `post_id` char(36) NOT NULL,
  `url` varchar(500) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `photos`
--

INSERT INTO `photos` (`id`, `post_id`, `url`, `created_at`) VALUES
('558d8227-755e-4e80-b1b6-e8d8a2c0683b', 'b3a48d67-52c5-4704-a32a-68edeecdde4e', 'https://www.entradasfresh.es/uploads/posts/post_8194d00a-8f3b-11f0-b588-0050565a1c59_1757726797.png', '2025-09-13 01:26:37'),
('698742c8-e897-485b-a5d7-d21b5072d845', 'ac4e89ca-50f5-41b8-a8dc-e15670f04c99', 'https://www.entradasfresh.es/uploads/posts/post_c0b40277-922c-11f0-87d2-0050565a1c59_1757953209_75eacf81325922b9.jpg', '2025-09-15 16:20:09'),
('8671e36c-6b14-44c3-9568-53ce37a0e80b', '290dc57a-1d73-4047-b96e-c475617406e3', 'https://www.entradasfresh.es/uploads/posts/post_8194d00a-8f3b-11f0-b588-0050565a1c59_1757726860.png', '2025-09-13 01:27:40'),
('8ed03ecd-3a74-43c2-93f8-f554c9e005e5', '97ffaa45-1f47-4f4c-ae64-39214ad08ff9', 'https://www.entradasfresh.es/uploads/posts/post_8194d00a-8f3b-11f0-b588-0050565a1c59_1760037231_8da4dfb59b742bdb.png', '2025-10-09 19:13:51'),
('8f48226f-dd17-4d89-957b-2584225a7083', 'be2131e2-80c6-4a32-b601-d1cb421b3e74', 'https://www.entradasfresh.es/uploads/posts/post_8194d00a-8f3b-11f0-b588-0050565a1c59_1757851290.png', '2025-09-14 12:01:30'),
('e83f0db8-180b-49b7-87be-80ed3f99b7e0', 'dad8fe7d-716a-4086-916e-eb4e73ca1b0f', 'https://www.entradasfresh.es/uploads/posts/post_f1da20b5-8f5b-11f0-b588-0050565a1c59_1757849194.jpg', '2025-09-14 11:26:34');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `posts`
--

CREATE TABLE `posts` (
  `id` char(36) NOT NULL,
  `author_id` char(36) NOT NULL,
  `caption` text DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `posts`
--

INSERT INTO `posts` (`id`, `author_id`, `caption`, `created_at`) VALUES
('290dc57a-1d73-4047-b96e-c475617406e3', '8194d00a-8f3b-11f0-b588-0050565a1c59', '', '2025-09-13 01:27:40'),
('97ffaa45-1f47-4f4c-ae64-39214ad08ff9', '8194d00a-8f3b-11f0-b588-0050565a1c59', 'tt dd rr dd', '2025-10-09 19:13:51'),
('ac4e89ca-50f5-41b8-a8dc-e15670f04c99', 'c0b40277-922c-11f0-87d2-0050565a1c59', 'EEEEE', '2025-09-15 16:20:09'),
('b3a48d67-52c5-4704-a32a-68edeecdde4e', '8194d00a-8f3b-11f0-b588-0050565a1c59', '', '2025-09-13 01:26:37'),
('be2131e2-80c6-4a32-b601-d1cb421b3e74', '8194d00a-8f3b-11f0-b588-0050565a1c59', '', '2025-09-14 12:01:30'),
('dad8fe7d-716a-4086-916e-eb4e73ca1b0f', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '', '2025-09-14 11:26:34');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `reports`
--

CREATE TABLE `reports` (
  `id` char(36) NOT NULL,
  `reporter_id` char(36) NOT NULL,
  `target_type` enum('post','comment','user') NOT NULL,
  `target_id` char(36) NOT NULL,
  `reason` enum('spam','harassment','inappropriate','other') NOT NULL,
  `description` text DEFAULT NULL,
  `status` enum('pending','reviewed','resolved') DEFAULT 'pending',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `reviewed_by` char(36) DEFAULT NULL,
  `reviewed_at` datetime DEFAULT NULL,
  `notes` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `reports`
--

INSERT INTO `reports` (`id`, `reporter_id`, `target_type`, `target_id`, `reason`, `description`, `status`, `created_at`, `reviewed_by`, `reviewed_at`, `notes`) VALUES
('11170a43-9487-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', 'post', 'ac4e89ca-50f5-41b8-a8dc-e15670f04c99', 'spam', 'Prueba', 'resolved', '2025-09-18 12:00:25', '8194d00a-8f3b-11f0-b588-0050565a1c59', '2025-09-21 20:04:05', 'ee'),
('556e2e6a-9717-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', 'post', 'ac4e89ca-50f5-41b8-a8dc-e15670f04c99', 'spam', 'ee', 'resolved', '2025-09-21 18:18:08', '8194d00a-8f3b-11f0-b588-0050565a1c59', '2025-09-23 21:20:34', 'sda'),
('a5df2d2e-9272-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', 'post', 'ac4e89ca-50f5-41b8-a8dc-e15670f04c99', 'spam', 'EEEE', 'resolved', '2025-09-15 20:29:14', '8194d00a-8f3b-11f0-b588-0050565a1c59', '2025-09-15 20:37:09', ''),
('af71e6d6-9273-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', 'post', 'dad8fe7d-716a-4086-916e-eb4e73ca1b0f', 'inappropriate', 'sss', 'resolved', '2025-09-15 20:36:40', '8194d00a-8f3b-11f0-b588-0050565a1c59', '2025-09-18 13:06:30', 'dd');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `security_logs`
--

CREATE TABLE `security_logs` (
  `id` char(36) NOT NULL,
  `user_id` char(36) DEFAULT NULL,
  `ip_address` varchar(45) NOT NULL,
  `user_agent` text DEFAULT NULL,
  `action` varchar(50) NOT NULL,
  `details` text DEFAULT NULL,
  `admin_reason` text DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `severity` enum('low','medium','high','critical') DEFAULT 'medium'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `security_logs`
--

INSERT INTO `security_logs` (`id`, `user_id`, `ip_address`, `user_agent`, `action`, `details`, `admin_reason`, `created_at`, `severity`) VALUES
('000cf97a-9983-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta dashboard: SQLSTATE[42S02]: Base table or view not found: 1146 Table \'thirty.ads\' doesn\'t exist', NULL, '2025-09-24 20:13:51', 'medium'),
('060b7ed1-98c3-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, nuevo estado: pending', '11', '2025-09-23 21:19:39', 'low'),
('1117d8e2-9487-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_created', 'Reporte creado: post/ac4e89ca-50f5-41b8-a8dc-e15670f04c99 - spam', NULL, '2025-09-18 14:00:25', 'medium'),
('1e10240c-922d-11f0-87d2-0050565a1c59', 'c0b40277-922c-11f0-87d2-0050565a1c59', '164.68.96.7', NULL, 'login_success', NULL, NULL, '2025-09-15 12:11:31', 'medium'),
('1fbd26f9-925e-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'new_comment', 'Nuevo comentario en publicación: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 18:02:19', 'medium'),
('26ab823b-922c-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', NULL, 'login_failed', 'Email no verificado: edgar_moreno@hotmail.es', NULL, '2025-09-15 12:04:36', 'medium'),
('272c0967-98c3-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_status_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, estado: pending → resolved', 'Cambio de estado a resolved', '2025-09-23 21:20:34', 'medium'),
('30e11110-9899-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'logout', NULL, NULL, '2025-09-23 18:20:12', 'medium'),
('34f0b77c-9278-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-15 21:09:02', 'medium'),
('35f6cb87-9899-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-23 18:20:20', 'medium'),
('39da88cf-98bb-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_status_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, estado: pending → pending', 'Cambio de estado a pending', '2025-09-23 22:23:50', 'medium'),
('44027224-92f7-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '80.29.230.143', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'login_success', NULL, NULL, '2025-09-16 14:18:33', 'medium'),
('486515a8-98bb-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_status_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, estado: pending → investigating', 'Cambio de estado a investigating', '2025-09-23 22:24:14', 'medium'),
('49293fbb-98b8-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, nuevo estado: pending', 'e', '2025-09-23 22:02:47', 'low'),
('4a886120-96f6-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_reviewed', 'Reporte reviewed: ID 11170a43-9487-11f0-87d2-0050565a1c59', 'rrrr', '2025-09-21 16:21:37', 'medium'),
('4b47b728-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:42:04', 'medium'),
('4cdf9749-96f6-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_reviewed', 'Reporte reviewed: ID 11170a43-9487-11f0-87d2-0050565a1c59', 'rrrr', '2025-09-21 16:21:41', 'medium'),
('4d5b7d62-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:42:08', 'medium'),
('4f5ad917-9717-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-21 18:17:58', 'medium'),
('4f7d913f-98bb-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_status_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, estado:  → investigating', 'Cambio de estado a investigating', '2025-09-23 22:24:26', 'medium'),
('556ffa03-9717-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_created', 'Reporte creado: post/ac4e89ca-50f5-41b8-a8dc-e15670f04c99 - spam', NULL, '2025-09-21 18:18:08', 'medium'),
('55ac4b29-9272-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'logout', NULL, NULL, '2025-09-15 20:27:00', 'medium'),
('58dac0a1-922c-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', NULL, 'login_failed', 'Email no verificado: edgar_moreno@hotmail.es', NULL, '2025-09-15 12:06:01', 'medium'),
('590be52f-9272-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-15 20:27:05', 'medium'),
('5f1047c0-9715-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado: ID 11170a43-9487-11f0-87d2-0050565a1c59, nuevo estado: resolved', 'ok', '2025-09-21 20:04:05', 'low'),
('62cdb072-947f-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado a resolved: ID af71e6d6-9273-11f0-87d2-0050565a1c59', 'fdsdfdsfsdfsdfffffff                    ffff', '2025-09-18 13:05:26', 'medium'),
('69615095-98bb-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta admin/users: SQLSTATE[HY093]: Invalid parameter number', NULL, '2025-09-23 22:25:09', 'medium'),
('699418c9-922c-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', NULL, 'login_success', NULL, NULL, '2025-09-15 12:06:29', 'medium'),
('6a6916ae-9714-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado: ID 11170a43-9487-11f0-87d2-0050565a1c59, nuevo estado: resolved', 'ok', '2025-09-21 19:57:15', 'low'),
('6c628e39-92ef-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '80.29.230.143', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'login_success', NULL, NULL, '2025-09-16 13:22:25', 'medium'),
('7a5e7f44-9986-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Binvenido Croker para Croker', NULL, '2025-09-24 22:38:45', 'low'),
('7a6a43d0-9278-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'login_success', NULL, NULL, '2025-09-15 21:10:58', 'medium'),
('7b679070-922c-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', NULL, 'logout', NULL, NULL, '2025-09-15 12:06:59', 'medium'),
('88cef54f-947f-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado a resolved: ID af71e6d6-9273-11f0-87d2-0050565a1c59', 'fdsdfdsfsdfsdfffffff                    ffff', '2025-09-18 13:06:30', 'medium'),
('91580af2-9278-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'login_success', NULL, NULL, '2025-09-15 21:11:37', 'medium'),
('97a58e30-9986-11f0-87d2-0050565a1c59', NULL, '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_failed', 'Usuario no encontrado: contacto@entradasfresh.es', NULL, '2025-09-24 20:39:34', 'medium'),
('9b3884bd-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:44:18', 'medium'),
('9c1c79cb-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:44:20', 'medium'),
('9d9cf57a-9986-11f0-87d2-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-24 20:39:44', 'medium'),
('9e0d8070-9278-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 21:11:58', 'medium'),
('9eccd66b-9278-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'post_unliked', 'Like eliminado: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 21:11:59', 'medium'),
('a5d60616-940b-11f0-87d2-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'user_manually_blocked', 'Usuario bloqueado manualmente por Mortii25', NULL, '2025-09-17 21:16:58', 'high'),
('a5e1dfce-9272-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_created', 'Reporte creado: post/ac4e89ca-50f5-41b8-a8dc-e15670f04c99 - spam', NULL, '2025-09-15 20:29:14', 'medium'),
('a7e97bb1-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:44:39', 'medium'),
('a86f99a0-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:44:40', 'medium'),
('af72715c-9273-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_created', 'Reporte creado: post/dad8fe7d-716a-4086-916e-eb4e73ca1b0f - inappropriate', NULL, '2025-09-15 20:36:40', 'medium'),
('afd398a5-98bb-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta admin/users: SQLSTATE[HY093]: Invalid parameter number', NULL, '2025-09-23 22:27:07', 'medium'),
('b82ef1b8-9712-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado: ID 11170a43-9487-11f0-87d2-0050565a1c59, nuevo estado: resolved', 'Limpio, permitido', '2025-09-21 19:45:06', 'low'),
('b9628eca-922c-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '79.117.222.29', NULL, 'login_success', NULL, NULL, '2025-09-15 12:08:43', 'medium'),
('bcffa69a-925a-11f0-87d2-0050565a1c59', 'c0b40277-922c-11f0-87d2-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'logout', NULL, NULL, '2025-09-15 17:38:05', 'medium'),
('c0b71858-922c-11f0-87d2-0050565a1c59', 'c0b40277-922c-11f0-87d2-0050565a1c59', '164.68.96.7', NULL, 'register_success', 'Usuario registrado: admin@eventos.com', NULL, '2025-09-15 12:08:55', 'medium'),
('c0f542d6-9273-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte resolved: a5df2d2e-9272-11f0-87d2-0050565a1c59', NULL, '2025-09-15 20:37:09', 'medium'),
('c119f84a-925a-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-15 17:38:12', 'medium'),
('cb02e84b-926f-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 20:08:48', 'medium'),
('ccc390c9-926f-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 20:08:51', 'medium'),
('ccd94a41-9273-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte reviewed: af71e6d6-9273-11f0-87d2-0050565a1c59', NULL, '2025-09-15 20:37:29', 'medium'),
('ceb80254-940a-11f0-87d2-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'user_manually_blocked', 'Usuario bloqueado manualmente por Mortii25', NULL, '2025-09-17 21:10:57', 'high'),
('d96c2974-924f-11f0-87d2-0050565a1c59', 'c0b40277-922c-11f0-87d2-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_created', 'Nueva publicación creada', NULL, '2025-09-15 16:20:09', 'medium'),
('dc24eac8-940a-11f0-87d2-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_blocked_account', 'Cuenta bloqueada: creador@eventos.com', NULL, '2025-09-17 21:11:19', 'medium'),
('e724c35a-9411-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_deleted', 'Publicación eliminada: ID 2bf5b9c2-bac8-4a8b-9c6d-090191e35240 del usuario Mortii25', 'ee', '2025-09-17 22:01:44', 'medium'),
('e8f883d3-98b9-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta admin/users: SQLSTATE[HY093]: Invalid parameter number', NULL, '2025-09-23 22:14:24', 'medium'),
('eb5a5f5b-940f-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'user_unblocked', 'Usuario desbloqueado: Moleno25 (ID: f1da20b5-8f5b-11f0-b588-0050565a1c59)', 'Prueba w', '2025-09-17 21:47:32', 'medium'),
('ff57201b-9982-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta dashboard: SQLSTATE[42S02]: Base table or view not found: 1146 Table \'thirty.ads\' doesn\'t exist', NULL, '2025-09-24 22:13:50', 'medium'),
('ffda3f08-9982-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta dashboard: SQLSTATE[42S02]: Base table or view not found: 1146 Table \'thirty.ads\' doesn\'t exist', NULL, '2025-09-24 20:13:51', 'medium'),
('fff055be-9982-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta dashboard: SQLSTATE[42S02]: Base table or view not found: 1146 Table \'thirty.ads\' doesn\'t exist', NULL, '2025-09-24 22:13:51', 'medium'),
('8d06bdfd-998e-11f0-87d2-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta profile/friend: SQLSTATE[42S22]: Column not found: 1054 Unknown column \'p.visibility\' in \'where clause\'', NULL, '2025-09-24 21:36:32', 'medium'),
('c7623ac2-99e9-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_updated', 'Anuncio actualizado: Binvenido Croker para Croker', NULL, '2025-09-25 08:29:34', 'low'),
('3abc5ac9-99ed-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_updated', 'Anuncio actualizado: Binvenido Croker para Croker', NULL, '2025-09-25 08:54:16', 'low'),
('f75b66a5-9a02-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_deleted', 'Anuncio eliminado: Binvenido Croker de Croker', 'Si', '2025-09-25 13:29:57', 'medium'),
('23ee025f-9a03-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Croke benvenidos para Croke', NULL, '2025-09-25 11:31:12', 'low'),
('e946b165-9a0b-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: 290dc57a-1d73-4047-b96e-c475617406e3', NULL, '2025-09-25 12:33:59', 'medium'),
('99ef8fda-9a3a-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-25 18:08:12', 'medium'),
('c5344a30-9a58-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_deleted', 'Anuncio eliminado: Croke benvenidos de Croke', 'dd', '2025-09-25 21:44:10', 'medium'),
('e6a21f50-9a58-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Croke para Corke', NULL, '2025-09-25 23:45:06', 'low'),
('7752f404-9a66-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-25 23:22:12', 'medium'),
('af3c1a4d-9a67-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Crokee para Croke', NULL, '2025-09-25 23:30:55', 'low'),
('b7730c55-9a67-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_deleted', 'Anuncio eliminado: Anuncio de Prueba de Empresa Ejemplo', 'aa', '2025-09-25 23:31:09', 'medium'),
('856a47e7-9a6c-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-26 00:05:33', 'medium'),
('f7125338-9a70-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_updated', 'Anuncio actualizado: Crokee para Croke (Estado: active)', NULL, '2025-09-26 00:37:21', 'low'),
('a506397a-9acc-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-26 11:33:37', 'medium'),
('a516a789-9acc-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-26 11:33:37', 'medium'),
('deb9156f-9ad2-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-26 14:18:11', 'medium'),
('75c41bac-9b97-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-09-27 11:45:25', 'medium'),
('763553cf-9b97-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-09-27 11:45:26', 'medium'),
('839e2016-9b9e-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_deleted', 'Anuncio eliminado: Crokee de Croke', 'ww', '2025-09-27 12:35:55', 'medium'),
('a0fd57cb-9b9e-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Bievenido a Croke para Croke (Estado: active)', NULL, '2025-09-27 12:36:44', 'low'),
('92cdb879-9baa-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Manoloo para ddd (Estado: active)', NULL, '2025-09-27 14:02:14', 'low'),
('dd1dbcfd-9bac-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_updated', 'Anuncio actualizado: Manoloo para ddd (Estado: active)', NULL, '2025-09-27 14:18:38', 'low'),
('56d6ce95-9bbc-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_deleted', 'Publicación eliminada: 44db3582-b68b-46ac-9a0c-d88654d291a4', NULL, '2025-09-27 18:09:25', 'medium'),
('000cf97a-9983-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta dashboard: SQLSTATE[42S02]: Base table or view not found: 1146 Table \'thirty.ads\' doesn\'t exist', NULL, '2025-09-24 20:13:51', 'medium'),
('060b7ed1-98c3-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, nuevo estado: pending', '11', '2025-09-23 21:19:39', 'low'),
('1117d8e2-9487-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_created', 'Reporte creado: post/ac4e89ca-50f5-41b8-a8dc-e15670f04c99 - spam', NULL, '2025-09-18 14:00:25', 'medium'),
('1e10240c-922d-11f0-87d2-0050565a1c59', 'c0b40277-922c-11f0-87d2-0050565a1c59', '164.68.96.7', NULL, 'login_success', NULL, NULL, '2025-09-15 12:11:31', 'medium'),
('1fbd26f9-925e-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'new_comment', 'Nuevo comentario en publicación: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 18:02:19', 'medium'),
('26ab823b-922c-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', NULL, 'login_failed', 'Email no verificado: edgar_moreno@hotmail.es', NULL, '2025-09-15 12:04:36', 'medium'),
('272c0967-98c3-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_status_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, estado: pending → resolved', 'Cambio de estado a resolved', '2025-09-23 21:20:34', 'medium'),
('30e11110-9899-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'logout', NULL, NULL, '2025-09-23 18:20:12', 'medium'),
('34f0b77c-9278-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-15 21:09:02', 'medium'),
('35f6cb87-9899-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-23 18:20:20', 'medium'),
('39da88cf-98bb-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_status_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, estado: pending → pending', 'Cambio de estado a pending', '2025-09-23 22:23:50', 'medium'),
('44027224-92f7-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '80.29.230.143', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'login_success', NULL, NULL, '2025-09-16 14:18:33', 'medium'),
('486515a8-98bb-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_status_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, estado: pending → investigating', 'Cambio de estado a investigating', '2025-09-23 22:24:14', 'medium'),
('49293fbb-98b8-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, nuevo estado: pending', 'e', '2025-09-23 22:02:47', 'low'),
('4a886120-96f6-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_reviewed', 'Reporte reviewed: ID 11170a43-9487-11f0-87d2-0050565a1c59', 'rrrr', '2025-09-21 16:21:37', 'medium'),
('4b47b728-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:42:04', 'medium'),
('4cdf9749-96f6-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_reviewed', 'Reporte reviewed: ID 11170a43-9487-11f0-87d2-0050565a1c59', 'rrrr', '2025-09-21 16:21:41', 'medium'),
('4d5b7d62-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:42:08', 'medium'),
('4f5ad917-9717-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-21 18:17:58', 'medium'),
('4f7d913f-98bb-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_status_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, estado:  → investigating', 'Cambio de estado a investigating', '2025-09-23 22:24:26', 'medium'),
('556ffa03-9717-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_created', 'Reporte creado: post/ac4e89ca-50f5-41b8-a8dc-e15670f04c99 - spam', NULL, '2025-09-21 18:18:08', 'medium'),
('55ac4b29-9272-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'logout', NULL, NULL, '2025-09-15 20:27:00', 'medium'),
('58dac0a1-922c-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', NULL, 'login_failed', 'Email no verificado: edgar_moreno@hotmail.es', NULL, '2025-09-15 12:06:01', 'medium'),
('590be52f-9272-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-15 20:27:05', 'medium'),
('5f1047c0-9715-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado: ID 11170a43-9487-11f0-87d2-0050565a1c59, nuevo estado: resolved', 'ok', '2025-09-21 20:04:05', 'low'),
('62cdb072-947f-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado a resolved: ID af71e6d6-9273-11f0-87d2-0050565a1c59', 'fdsdfdsfsdfsdfffffff                    ffff', '2025-09-18 13:05:26', 'medium'),
('69615095-98bb-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta admin/users: SQLSTATE[HY093]: Invalid parameter number', NULL, '2025-09-23 22:25:09', 'medium'),
('699418c9-922c-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', NULL, 'login_success', NULL, NULL, '2025-09-15 12:06:29', 'medium'),
('6a6916ae-9714-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado: ID 11170a43-9487-11f0-87d2-0050565a1c59, nuevo estado: resolved', 'ok', '2025-09-21 19:57:15', 'low'),
('6c628e39-92ef-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '80.29.230.143', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'login_success', NULL, NULL, '2025-09-16 13:22:25', 'medium'),
('7a5e7f44-9986-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Binvenido Croker para Croker', NULL, '2025-09-24 22:38:45', 'low'),
('7a6a43d0-9278-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'login_success', NULL, NULL, '2025-09-15 21:10:58', 'medium'),
('7b679070-922c-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', NULL, 'logout', NULL, NULL, '2025-09-15 12:06:59', 'medium'),
('88cef54f-947f-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado a resolved: ID af71e6d6-9273-11f0-87d2-0050565a1c59', 'fdsdfdsfsdfsdfffffff                    ffff', '2025-09-18 13:06:30', 'medium'),
('91580af2-9278-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'login_success', NULL, NULL, '2025-09-15 21:11:37', 'medium'),
('97a58e30-9986-11f0-87d2-0050565a1c59', NULL, '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_failed', 'Usuario no encontrado: contacto@entradasfresh.es', NULL, '2025-09-24 20:39:34', 'medium'),
('9b3884bd-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:44:18', 'medium'),
('9c1c79cb-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:44:20', 'medium'),
('9d9cf57a-9986-11f0-87d2-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-24 20:39:44', 'medium'),
('9e0d8070-9278-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 21:11:58', 'medium'),
('9eccd66b-9278-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'post_unliked', 'Like eliminado: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 21:11:59', 'medium'),
('a5d60616-940b-11f0-87d2-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'user_manually_blocked', 'Usuario bloqueado manualmente por Mortii25', NULL, '2025-09-17 21:16:58', 'high'),
('a5e1dfce-9272-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_created', 'Reporte creado: post/ac4e89ca-50f5-41b8-a8dc-e15670f04c99 - spam', NULL, '2025-09-15 20:29:14', 'medium'),
('a7e97bb1-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:44:39', 'medium'),
('a86f99a0-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:44:40', 'medium'),
('af72715c-9273-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_created', 'Reporte creado: post/dad8fe7d-716a-4086-916e-eb4e73ca1b0f - inappropriate', NULL, '2025-09-15 20:36:40', 'medium'),
('afd398a5-98bb-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta admin/users: SQLSTATE[HY093]: Invalid parameter number', NULL, '2025-09-23 22:27:07', 'medium'),
('b82ef1b8-9712-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado: ID 11170a43-9487-11f0-87d2-0050565a1c59, nuevo estado: resolved', 'Limpio, permitido', '2025-09-21 19:45:06', 'low'),
('b9628eca-922c-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '79.117.222.29', NULL, 'login_success', NULL, NULL, '2025-09-15 12:08:43', 'medium'),
('bcffa69a-925a-11f0-87d2-0050565a1c59', 'c0b40277-922c-11f0-87d2-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'logout', NULL, NULL, '2025-09-15 17:38:05', 'medium'),
('c0b71858-922c-11f0-87d2-0050565a1c59', 'c0b40277-922c-11f0-87d2-0050565a1c59', '164.68.96.7', NULL, 'register_success', 'Usuario registrado: admin@eventos.com', NULL, '2025-09-15 12:08:55', 'medium'),
('c0f542d6-9273-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte resolved: a5df2d2e-9272-11f0-87d2-0050565a1c59', NULL, '2025-09-15 20:37:09', 'medium'),
('c119f84a-925a-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-15 17:38:12', 'medium'),
('cb02e84b-926f-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 20:08:48', 'medium'),
('ccc390c9-926f-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 20:08:51', 'medium'),
('ccd94a41-9273-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte reviewed: af71e6d6-9273-11f0-87d2-0050565a1c59', NULL, '2025-09-15 20:37:29', 'medium'),
('ceb80254-940a-11f0-87d2-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'user_manually_blocked', 'Usuario bloqueado manualmente por Mortii25', NULL, '2025-09-17 21:10:57', 'high'),
('d96c2974-924f-11f0-87d2-0050565a1c59', 'c0b40277-922c-11f0-87d2-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_created', 'Nueva publicación creada', NULL, '2025-09-15 16:20:09', 'medium'),
('dc24eac8-940a-11f0-87d2-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_blocked_account', 'Cuenta bloqueada: creador@eventos.com', NULL, '2025-09-17 21:11:19', 'medium'),
('e724c35a-9411-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_deleted', 'Publicación eliminada: ID 2bf5b9c2-bac8-4a8b-9c6d-090191e35240 del usuario Mortii25', 'ee', '2025-09-17 22:01:44', 'medium'),
('e8f883d3-98b9-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta admin/users: SQLSTATE[HY093]: Invalid parameter number', NULL, '2025-09-23 22:14:24', 'medium'),
('eb5a5f5b-940f-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'user_unblocked', 'Usuario desbloqueado: Moleno25 (ID: f1da20b5-8f5b-11f0-b588-0050565a1c59)', 'Prueba w', '2025-09-17 21:47:32', 'medium'),
('ff57201b-9982-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta dashboard: SQLSTATE[42S02]: Base table or view not found: 1146 Table \'thirty.ads\' doesn\'t exist', NULL, '2025-09-24 22:13:50', 'medium'),
('ffda3f08-9982-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta dashboard: SQLSTATE[42S02]: Base table or view not found: 1146 Table \'thirty.ads\' doesn\'t exist', NULL, '2025-09-24 20:13:51', 'medium'),
('fff055be-9982-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta dashboard: SQLSTATE[42S02]: Base table or view not found: 1146 Table \'thirty.ads\' doesn\'t exist', NULL, '2025-09-24 22:13:51', 'medium'),
('8d06bdfd-998e-11f0-87d2-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta profile/friend: SQLSTATE[42S22]: Column not found: 1054 Unknown column \'p.visibility\' in \'where clause\'', NULL, '2025-09-24 21:36:32', 'medium'),
('c7623ac2-99e9-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_updated', 'Anuncio actualizado: Binvenido Croker para Croker', NULL, '2025-09-25 08:29:34', 'low'),
('3abc5ac9-99ed-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_updated', 'Anuncio actualizado: Binvenido Croker para Croker', NULL, '2025-09-25 08:54:16', 'low'),
('f75b66a5-9a02-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_deleted', 'Anuncio eliminado: Binvenido Croker de Croker', 'Si', '2025-09-25 13:29:57', 'medium'),
('23ee025f-9a03-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Croke benvenidos para Croke', NULL, '2025-09-25 11:31:12', 'low');
INSERT INTO `security_logs` (`id`, `user_id`, `ip_address`, `user_agent`, `action`, `details`, `admin_reason`, `created_at`, `severity`) VALUES
('e946b165-9a0b-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: 290dc57a-1d73-4047-b96e-c475617406e3', NULL, '2025-09-25 12:33:59', 'medium'),
('99ef8fda-9a3a-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-25 18:08:12', 'medium'),
('c5344a30-9a58-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_deleted', 'Anuncio eliminado: Croke benvenidos de Croke', 'dd', '2025-09-25 21:44:10', 'medium'),
('e6a21f50-9a58-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Croke para Corke', NULL, '2025-09-25 23:45:06', 'low'),
('7752f404-9a66-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-25 23:22:12', 'medium'),
('af3c1a4d-9a67-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Crokee para Croke', NULL, '2025-09-25 23:30:55', 'low'),
('b7730c55-9a67-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_deleted', 'Anuncio eliminado: Anuncio de Prueba de Empresa Ejemplo', 'aa', '2025-09-25 23:31:09', 'medium'),
('856a47e7-9a6c-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-26 00:05:33', 'medium'),
('f7125338-9a70-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_updated', 'Anuncio actualizado: Crokee para Croke (Estado: active)', NULL, '2025-09-26 00:37:21', 'low'),
('a506397a-9acc-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-26 11:33:37', 'medium'),
('a516a789-9acc-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-26 11:33:37', 'medium'),
('deb9156f-9ad2-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-26 14:18:11', 'medium'),
('75c41bac-9b97-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-09-27 11:45:25', 'medium'),
('763553cf-9b97-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-09-27 11:45:26', 'medium'),
('839e2016-9b9e-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_deleted', 'Anuncio eliminado: Crokee de Croke', 'ww', '2025-09-27 12:35:55', 'medium'),
('a0fd57cb-9b9e-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Bievenido a Croke para Croke (Estado: active)', NULL, '2025-09-27 12:36:44', 'low'),
('92cdb879-9baa-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Manoloo para ddd (Estado: active)', NULL, '2025-09-27 14:02:14', 'low'),
('dd1dbcfd-9bac-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_updated', 'Anuncio actualizado: Manoloo para ddd (Estado: active)', NULL, '2025-09-27 14:18:38', 'low'),
('56d6ce95-9bbc-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_deleted', 'Publicación eliminada: 44db3582-b68b-46ac-9a0c-d88654d291a4', NULL, '2025-09-27 18:09:25', 'medium'),
('fbe7bd26-9c64-11f0-b2f9-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-28 14:16:38', 'medium'),
('6e0ff0dd-9c9a-11f0-b2f9-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_updated', 'Anuncio actualizado: Bievenido a Croke para Croke (Estado: active)', NULL, '2025-09-28 18:39:13', 'low'),
('a8bcb12b-9ca3-11f0-b2f9-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'new_comment', 'Nuevo comentario en publicación: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-09-28 19:45:17', 'medium'),
('30cdf8bd-9de8-11f0-b2f9-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_failed', 'Contraseña incorrecta', NULL, '2025-09-30 12:28:21', 'medium'),
('345220c3-9de8-11f0-b2f9-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_failed', 'Contraseña incorrecta', NULL, '2025-09-30 12:28:27', 'medium'),
('37578d33-9de8-11f0-b2f9-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-30 12:28:32', 'medium'),
('4e89974b-9fe2-11f0-b328-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'logout', NULL, NULL, '2025-10-02 22:51:17', 'medium'),
('54cd1c6b-9fe2-11f0-b328-0050565a1c59', NULL, '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_failed', 'Usuario no encontrado: edgar_moreno@hotmail.es', NULL, '2025-10-02 22:51:28', 'medium'),
('000cf97a-9983-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta dashboard: SQLSTATE[42S02]: Base table or view not found: 1146 Table \'thirty.ads\' doesn\'t exist', NULL, '2025-09-24 20:13:51', 'medium'),
('060b7ed1-98c3-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, nuevo estado: pending', '11', '2025-09-23 21:19:39', 'low'),
('1117d8e2-9487-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_created', 'Reporte creado: post/ac4e89ca-50f5-41b8-a8dc-e15670f04c99 - spam', NULL, '2025-09-18 14:00:25', 'medium'),
('1e10240c-922d-11f0-87d2-0050565a1c59', 'c0b40277-922c-11f0-87d2-0050565a1c59', '164.68.96.7', NULL, 'login_success', NULL, NULL, '2025-09-15 12:11:31', 'medium'),
('1fbd26f9-925e-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'new_comment', 'Nuevo comentario en publicación: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 18:02:19', 'medium'),
('26ab823b-922c-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', NULL, 'login_failed', 'Email no verificado: edgar_moreno@hotmail.es', NULL, '2025-09-15 12:04:36', 'medium'),
('272c0967-98c3-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_status_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, estado: pending → resolved', 'Cambio de estado a resolved', '2025-09-23 21:20:34', 'medium'),
('30e11110-9899-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'logout', NULL, NULL, '2025-09-23 18:20:12', 'medium'),
('34f0b77c-9278-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-15 21:09:02', 'medium'),
('35f6cb87-9899-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-23 18:20:20', 'medium'),
('39da88cf-98bb-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_status_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, estado: pending → pending', 'Cambio de estado a pending', '2025-09-23 22:23:50', 'medium'),
('44027224-92f7-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '80.29.230.143', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'login_success', NULL, NULL, '2025-09-16 14:18:33', 'medium'),
('486515a8-98bb-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_status_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, estado: pending → investigating', 'Cambio de estado a investigating', '2025-09-23 22:24:14', 'medium'),
('49293fbb-98b8-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, nuevo estado: pending', 'e', '2025-09-23 22:02:47', 'low'),
('4a886120-96f6-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_reviewed', 'Reporte reviewed: ID 11170a43-9487-11f0-87d2-0050565a1c59', 'rrrr', '2025-09-21 16:21:37', 'medium'),
('4b47b728-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:42:04', 'medium'),
('4cdf9749-96f6-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_reviewed', 'Reporte reviewed: ID 11170a43-9487-11f0-87d2-0050565a1c59', 'rrrr', '2025-09-21 16:21:41', 'medium'),
('4d5b7d62-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:42:08', 'medium'),
('4f5ad917-9717-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-21 18:17:58', 'medium'),
('4f7d913f-98bb-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_status_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, estado:  → investigating', 'Cambio de estado a investigating', '2025-09-23 22:24:26', 'medium'),
('556ffa03-9717-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_created', 'Reporte creado: post/ac4e89ca-50f5-41b8-a8dc-e15670f04c99 - spam', NULL, '2025-09-21 18:18:08', 'medium'),
('55ac4b29-9272-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'logout', NULL, NULL, '2025-09-15 20:27:00', 'medium'),
('58dac0a1-922c-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', NULL, 'login_failed', 'Email no verificado: edgar_moreno@hotmail.es', NULL, '2025-09-15 12:06:01', 'medium'),
('590be52f-9272-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-15 20:27:05', 'medium'),
('5f1047c0-9715-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado: ID 11170a43-9487-11f0-87d2-0050565a1c59, nuevo estado: resolved', 'ok', '2025-09-21 20:04:05', 'low'),
('62cdb072-947f-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado a resolved: ID af71e6d6-9273-11f0-87d2-0050565a1c59', 'fdsdfdsfsdfsdfffffff                    ffff', '2025-09-18 13:05:26', 'medium'),
('69615095-98bb-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta admin/users: SQLSTATE[HY093]: Invalid parameter number', NULL, '2025-09-23 22:25:09', 'medium'),
('699418c9-922c-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', NULL, 'login_success', NULL, NULL, '2025-09-15 12:06:29', 'medium'),
('6a6916ae-9714-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado: ID 11170a43-9487-11f0-87d2-0050565a1c59, nuevo estado: resolved', 'ok', '2025-09-21 19:57:15', 'low'),
('6c628e39-92ef-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '80.29.230.143', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'login_success', NULL, NULL, '2025-09-16 13:22:25', 'medium'),
('7a5e7f44-9986-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Binvenido Croker para Croker', NULL, '2025-09-24 22:38:45', 'low'),
('7a6a43d0-9278-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'login_success', NULL, NULL, '2025-09-15 21:10:58', 'medium'),
('7b679070-922c-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', NULL, 'logout', NULL, NULL, '2025-09-15 12:06:59', 'medium'),
('88cef54f-947f-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado a resolved: ID af71e6d6-9273-11f0-87d2-0050565a1c59', 'fdsdfdsfsdfsdfffffff                    ffff', '2025-09-18 13:06:30', 'medium'),
('91580af2-9278-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'login_success', NULL, NULL, '2025-09-15 21:11:37', 'medium'),
('97a58e30-9986-11f0-87d2-0050565a1c59', NULL, '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_failed', 'Usuario no encontrado: contacto@entradasfresh.es', NULL, '2025-09-24 20:39:34', 'medium'),
('9b3884bd-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:44:18', 'medium'),
('9c1c79cb-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:44:20', 'medium'),
('9d9cf57a-9986-11f0-87d2-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-24 20:39:44', 'medium'),
('9e0d8070-9278-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 21:11:58', 'medium'),
('9eccd66b-9278-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'post_unliked', 'Like eliminado: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 21:11:59', 'medium'),
('a5d60616-940b-11f0-87d2-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'user_manually_blocked', 'Usuario bloqueado manualmente por Mortii25', NULL, '2025-09-17 21:16:58', 'high'),
('a5e1dfce-9272-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_created', 'Reporte creado: post/ac4e89ca-50f5-41b8-a8dc-e15670f04c99 - spam', NULL, '2025-09-15 20:29:14', 'medium'),
('a7e97bb1-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:44:39', 'medium'),
('a86f99a0-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:44:40', 'medium'),
('af72715c-9273-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_created', 'Reporte creado: post/dad8fe7d-716a-4086-916e-eb4e73ca1b0f - inappropriate', NULL, '2025-09-15 20:36:40', 'medium'),
('afd398a5-98bb-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta admin/users: SQLSTATE[HY093]: Invalid parameter number', NULL, '2025-09-23 22:27:07', 'medium'),
('b82ef1b8-9712-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado: ID 11170a43-9487-11f0-87d2-0050565a1c59, nuevo estado: resolved', 'Limpio, permitido', '2025-09-21 19:45:06', 'low'),
('b9628eca-922c-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '79.117.222.29', NULL, 'login_success', NULL, NULL, '2025-09-15 12:08:43', 'medium'),
('bcffa69a-925a-11f0-87d2-0050565a1c59', 'c0b40277-922c-11f0-87d2-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'logout', NULL, NULL, '2025-09-15 17:38:05', 'medium'),
('c0b71858-922c-11f0-87d2-0050565a1c59', 'c0b40277-922c-11f0-87d2-0050565a1c59', '164.68.96.7', NULL, 'register_success', 'Usuario registrado: admin@eventos.com', NULL, '2025-09-15 12:08:55', 'medium'),
('c0f542d6-9273-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte resolved: a5df2d2e-9272-11f0-87d2-0050565a1c59', NULL, '2025-09-15 20:37:09', 'medium'),
('c119f84a-925a-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-15 17:38:12', 'medium'),
('cb02e84b-926f-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 20:08:48', 'medium'),
('ccc390c9-926f-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 20:08:51', 'medium'),
('ccd94a41-9273-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte reviewed: af71e6d6-9273-11f0-87d2-0050565a1c59', NULL, '2025-09-15 20:37:29', 'medium'),
('ceb80254-940a-11f0-87d2-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'user_manually_blocked', 'Usuario bloqueado manualmente por Mortii25', NULL, '2025-09-17 21:10:57', 'high'),
('d96c2974-924f-11f0-87d2-0050565a1c59', 'c0b40277-922c-11f0-87d2-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_created', 'Nueva publicación creada', NULL, '2025-09-15 16:20:09', 'medium'),
('dc24eac8-940a-11f0-87d2-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_blocked_account', 'Cuenta bloqueada: creador@eventos.com', NULL, '2025-09-17 21:11:19', 'medium'),
('e724c35a-9411-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_deleted', 'Publicación eliminada: ID 2bf5b9c2-bac8-4a8b-9c6d-090191e35240 del usuario Mortii25', 'ee', '2025-09-17 22:01:44', 'medium'),
('e8f883d3-98b9-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta admin/users: SQLSTATE[HY093]: Invalid parameter number', NULL, '2025-09-23 22:14:24', 'medium'),
('eb5a5f5b-940f-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'user_unblocked', 'Usuario desbloqueado: Moleno25 (ID: f1da20b5-8f5b-11f0-b588-0050565a1c59)', 'Prueba w', '2025-09-17 21:47:32', 'medium'),
('ff57201b-9982-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta dashboard: SQLSTATE[42S02]: Base table or view not found: 1146 Table \'thirty.ads\' doesn\'t exist', NULL, '2025-09-24 22:13:50', 'medium'),
('ffda3f08-9982-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta dashboard: SQLSTATE[42S02]: Base table or view not found: 1146 Table \'thirty.ads\' doesn\'t exist', NULL, '2025-09-24 20:13:51', 'medium'),
('fff055be-9982-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta dashboard: SQLSTATE[42S02]: Base table or view not found: 1146 Table \'thirty.ads\' doesn\'t exist', NULL, '2025-09-24 22:13:51', 'medium'),
('8d06bdfd-998e-11f0-87d2-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta profile/friend: SQLSTATE[42S22]: Column not found: 1054 Unknown column \'p.visibility\' in \'where clause\'', NULL, '2025-09-24 21:36:32', 'medium'),
('c7623ac2-99e9-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_updated', 'Anuncio actualizado: Binvenido Croker para Croker', NULL, '2025-09-25 08:29:34', 'low'),
('3abc5ac9-99ed-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_updated', 'Anuncio actualizado: Binvenido Croker para Croker', NULL, '2025-09-25 08:54:16', 'low'),
('f75b66a5-9a02-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_deleted', 'Anuncio eliminado: Binvenido Croker de Croker', 'Si', '2025-09-25 13:29:57', 'medium'),
('23ee025f-9a03-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Croke benvenidos para Croke', NULL, '2025-09-25 11:31:12', 'low'),
('e946b165-9a0b-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: 290dc57a-1d73-4047-b96e-c475617406e3', NULL, '2025-09-25 12:33:59', 'medium'),
('99ef8fda-9a3a-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-25 18:08:12', 'medium'),
('c5344a30-9a58-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_deleted', 'Anuncio eliminado: Croke benvenidos de Croke', 'dd', '2025-09-25 21:44:10', 'medium'),
('e6a21f50-9a58-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Croke para Corke', NULL, '2025-09-25 23:45:06', 'low'),
('7752f404-9a66-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-25 23:22:12', 'medium'),
('af3c1a4d-9a67-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Crokee para Croke', NULL, '2025-09-25 23:30:55', 'low'),
('b7730c55-9a67-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_deleted', 'Anuncio eliminado: Anuncio de Prueba de Empresa Ejemplo', 'aa', '2025-09-25 23:31:09', 'medium'),
('856a47e7-9a6c-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-26 00:05:33', 'medium'),
('f7125338-9a70-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_updated', 'Anuncio actualizado: Crokee para Croke (Estado: active)', NULL, '2025-09-26 00:37:21', 'low'),
('a506397a-9acc-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-26 11:33:37', 'medium'),
('a516a789-9acc-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-26 11:33:37', 'medium'),
('deb9156f-9ad2-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-26 14:18:11', 'medium'),
('75c41bac-9b97-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-09-27 11:45:25', 'medium'),
('763553cf-9b97-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-09-27 11:45:26', 'medium'),
('839e2016-9b9e-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_deleted', 'Anuncio eliminado: Crokee de Croke', 'ww', '2025-09-27 12:35:55', 'medium'),
('a0fd57cb-9b9e-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Bievenido a Croke para Croke (Estado: active)', NULL, '2025-09-27 12:36:44', 'low'),
('92cdb879-9baa-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Manoloo para ddd (Estado: active)', NULL, '2025-09-27 14:02:14', 'low'),
('dd1dbcfd-9bac-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_updated', 'Anuncio actualizado: Manoloo para ddd (Estado: active)', NULL, '2025-09-27 14:18:38', 'low'),
('56d6ce95-9bbc-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_deleted', 'Publicación eliminada: 44db3582-b68b-46ac-9a0c-d88654d291a4', NULL, '2025-09-27 18:09:25', 'medium'),
('000cf97a-9983-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta dashboard: SQLSTATE[42S02]: Base table or view not found: 1146 Table \'thirty.ads\' doesn\'t exist', NULL, '2025-09-24 20:13:51', 'medium'),
('060b7ed1-98c3-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, nuevo estado: pending', '11', '2025-09-23 21:19:39', 'low'),
('1117d8e2-9487-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_created', 'Reporte creado: post/ac4e89ca-50f5-41b8-a8dc-e15670f04c99 - spam', NULL, '2025-09-18 14:00:25', 'medium'),
('1e10240c-922d-11f0-87d2-0050565a1c59', 'c0b40277-922c-11f0-87d2-0050565a1c59', '164.68.96.7', NULL, 'login_success', NULL, NULL, '2025-09-15 12:11:31', 'medium'),
('1fbd26f9-925e-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'new_comment', 'Nuevo comentario en publicación: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 18:02:19', 'medium'),
('26ab823b-922c-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', NULL, 'login_failed', 'Email no verificado: edgar_moreno@hotmail.es', NULL, '2025-09-15 12:04:36', 'medium'),
('272c0967-98c3-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_status_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, estado: pending → resolved', 'Cambio de estado a resolved', '2025-09-23 21:20:34', 'medium'),
('30e11110-9899-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'logout', NULL, NULL, '2025-09-23 18:20:12', 'medium'),
('34f0b77c-9278-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-15 21:09:02', 'medium'),
('35f6cb87-9899-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-23 18:20:20', 'medium'),
('39da88cf-98bb-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_status_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, estado: pending → pending', 'Cambio de estado a pending', '2025-09-23 22:23:50', 'medium'),
('44027224-92f7-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '80.29.230.143', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'login_success', NULL, NULL, '2025-09-16 14:18:33', 'medium'),
('486515a8-98bb-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_status_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, estado: pending → investigating', 'Cambio de estado a investigating', '2025-09-23 22:24:14', 'medium'),
('49293fbb-98b8-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, nuevo estado: pending', 'e', '2025-09-23 22:02:47', 'low'),
('4a886120-96f6-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_reviewed', 'Reporte reviewed: ID 11170a43-9487-11f0-87d2-0050565a1c59', 'rrrr', '2025-09-21 16:21:37', 'medium'),
('4b47b728-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:42:04', 'medium'),
('4cdf9749-96f6-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_reviewed', 'Reporte reviewed: ID 11170a43-9487-11f0-87d2-0050565a1c59', 'rrrr', '2025-09-21 16:21:41', 'medium'),
('4d5b7d62-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:42:08', 'medium'),
('4f5ad917-9717-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-21 18:17:58', 'medium'),
('4f7d913f-98bb-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_status_updated', 'Reporte actualizado: ID 556e2e6a-9717-11f0-87d2-0050565a1c59, estado:  → investigating', 'Cambio de estado a investigating', '2025-09-23 22:24:26', 'medium'),
('556ffa03-9717-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_created', 'Reporte creado: post/ac4e89ca-50f5-41b8-a8dc-e15670f04c99 - spam', NULL, '2025-09-21 18:18:08', 'medium'),
('55ac4b29-9272-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'logout', NULL, NULL, '2025-09-15 20:27:00', 'medium'),
('58dac0a1-922c-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', NULL, 'login_failed', 'Email no verificado: edgar_moreno@hotmail.es', NULL, '2025-09-15 12:06:01', 'medium'),
('590be52f-9272-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-15 20:27:05', 'medium'),
('5f1047c0-9715-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado: ID 11170a43-9487-11f0-87d2-0050565a1c59, nuevo estado: resolved', 'ok', '2025-09-21 20:04:05', 'low'),
('62cdb072-947f-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado a resolved: ID af71e6d6-9273-11f0-87d2-0050565a1c59', 'fdsdfdsfsdfsdfffffff                    ffff', '2025-09-18 13:05:26', 'medium'),
('69615095-98bb-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta admin/users: SQLSTATE[HY093]: Invalid parameter number', NULL, '2025-09-23 22:25:09', 'medium'),
('699418c9-922c-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', NULL, 'login_success', NULL, NULL, '2025-09-15 12:06:29', 'medium'),
('6a6916ae-9714-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado: ID 11170a43-9487-11f0-87d2-0050565a1c59, nuevo estado: resolved', 'ok', '2025-09-21 19:57:15', 'low'),
('6c628e39-92ef-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '80.29.230.143', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'login_success', NULL, NULL, '2025-09-16 13:22:25', 'medium'),
('7a5e7f44-9986-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Binvenido Croker para Croker', NULL, '2025-09-24 22:38:45', 'low'),
('7a6a43d0-9278-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'login_success', NULL, NULL, '2025-09-15 21:10:58', 'medium'),
('7b679070-922c-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', NULL, 'logout', NULL, NULL, '2025-09-15 12:06:59', 'medium'),
('88cef54f-947f-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado a resolved: ID af71e6d6-9273-11f0-87d2-0050565a1c59', 'fdsdfdsfsdfsdfffffff                    ffff', '2025-09-18 13:06:30', 'medium'),
('91580af2-9278-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'login_success', NULL, NULL, '2025-09-15 21:11:37', 'medium'),
('97a58e30-9986-11f0-87d2-0050565a1c59', NULL, '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_failed', 'Usuario no encontrado: contacto@entradasfresh.es', NULL, '2025-09-24 20:39:34', 'medium'),
('9b3884bd-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:44:18', 'medium'),
('9c1c79cb-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:44:20', 'medium'),
('9d9cf57a-9986-11f0-87d2-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-24 20:39:44', 'medium'),
('9e0d8070-9278-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 21:11:58', 'medium'),
('9eccd66b-9278-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0 Mobile/15E148 Safari/604.1', 'post_unliked', 'Like eliminado: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 21:11:59', 'medium'),
('a5d60616-940b-11f0-87d2-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'user_manually_blocked', 'Usuario bloqueado manualmente por Mortii25', NULL, '2025-09-17 21:16:58', 'high'),
('a5e1dfce-9272-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_created', 'Reporte creado: post/ac4e89ca-50f5-41b8-a8dc-e15670f04c99 - spam', NULL, '2025-09-15 20:29:14', 'medium'),
('a7e97bb1-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:44:39', 'medium'),
('a86f99a0-925b-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 17:44:40', 'medium');
INSERT INTO `security_logs` (`id`, `user_id`, `ip_address`, `user_agent`, `action`, `details`, `admin_reason`, `created_at`, `severity`) VALUES
('af72715c-9273-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_created', 'Reporte creado: post/dad8fe7d-716a-4086-916e-eb4e73ca1b0f - inappropriate', NULL, '2025-09-15 20:36:40', 'medium'),
('afd398a5-98bb-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta admin/users: SQLSTATE[HY093]: Invalid parameter number', NULL, '2025-09-23 22:27:07', 'medium'),
('b82ef1b8-9712-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte actualizado: ID 11170a43-9487-11f0-87d2-0050565a1c59, nuevo estado: resolved', 'Limpio, permitido', '2025-09-21 19:45:06', 'low'),
('b9628eca-922c-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '79.117.222.29', NULL, 'login_success', NULL, NULL, '2025-09-15 12:08:43', 'medium'),
('bcffa69a-925a-11f0-87d2-0050565a1c59', 'c0b40277-922c-11f0-87d2-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'logout', NULL, NULL, '2025-09-15 17:38:05', 'medium'),
('c0b71858-922c-11f0-87d2-0050565a1c59', 'c0b40277-922c-11f0-87d2-0050565a1c59', '164.68.96.7', NULL, 'register_success', 'Usuario registrado: admin@eventos.com', NULL, '2025-09-15 12:08:55', 'medium'),
('c0f542d6-9273-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte resolved: a5df2d2e-9272-11f0-87d2-0050565a1c59', NULL, '2025-09-15 20:37:09', 'medium'),
('c119f84a-925a-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-15 17:38:12', 'medium'),
('cb02e84b-926f-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 20:08:48', 'medium'),
('ccc390c9-926f-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: ac4e89ca-50f5-41b8-a8dc-e15670f04c99', NULL, '2025-09-15 20:08:51', 'medium'),
('ccd94a41-9273-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'report_updated', 'Reporte reviewed: af71e6d6-9273-11f0-87d2-0050565a1c59', NULL, '2025-09-15 20:37:29', 'medium'),
('ceb80254-940a-11f0-87d2-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'user_manually_blocked', 'Usuario bloqueado manualmente por Mortii25', NULL, '2025-09-17 21:10:57', 'high'),
('d96c2974-924f-11f0-87d2-0050565a1c59', 'c0b40277-922c-11f0-87d2-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_created', 'Nueva publicación creada', NULL, '2025-09-15 16:20:09', 'medium'),
('dc24eac8-940a-11f0-87d2-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_blocked_account', 'Cuenta bloqueada: creador@eventos.com', NULL, '2025-09-17 21:11:19', 'medium'),
('e724c35a-9411-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_deleted', 'Publicación eliminada: ID 2bf5b9c2-bac8-4a8b-9c6d-090191e35240 del usuario Mortii25', 'ee', '2025-09-17 22:01:44', 'medium'),
('e8f883d3-98b9-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta admin/users: SQLSTATE[HY093]: Invalid parameter number', NULL, '2025-09-23 22:14:24', 'medium'),
('eb5a5f5b-940f-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'user_unblocked', 'Usuario desbloqueado: Moleno25 (ID: f1da20b5-8f5b-11f0-b588-0050565a1c59)', 'Prueba w', '2025-09-17 21:47:32', 'medium'),
('ff57201b-9982-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta dashboard: SQLSTATE[42S02]: Base table or view not found: 1146 Table \'thirty.ads\' doesn\'t exist', NULL, '2025-09-24 22:13:50', 'medium'),
('ffda3f08-9982-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta dashboard: SQLSTATE[42S02]: Base table or view not found: 1146 Table \'thirty.ads\' doesn\'t exist', NULL, '2025-09-24 20:13:51', 'medium'),
('fff055be-9982-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta dashboard: SQLSTATE[42S02]: Base table or view not found: 1146 Table \'thirty.ads\' doesn\'t exist', NULL, '2025-09-24 22:13:51', 'medium'),
('8d06bdfd-998e-11f0-87d2-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta profile/friend: SQLSTATE[42S22]: Column not found: 1054 Unknown column \'p.visibility\' in \'where clause\'', NULL, '2025-09-24 21:36:32', 'medium'),
('c7623ac2-99e9-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_updated', 'Anuncio actualizado: Binvenido Croker para Croker', NULL, '2025-09-25 08:29:34', 'low'),
('3abc5ac9-99ed-11f0-87d2-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_updated', 'Anuncio actualizado: Binvenido Croker para Croker', NULL, '2025-09-25 08:54:16', 'low'),
('f75b66a5-9a02-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_deleted', 'Anuncio eliminado: Binvenido Croker de Croker', 'Si', '2025-09-25 13:29:57', 'medium'),
('23ee025f-9a03-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Croke benvenidos para Croke', NULL, '2025-09-25 11:31:12', 'low'),
('e946b165-9a0b-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: 290dc57a-1d73-4047-b96e-c475617406e3', NULL, '2025-09-25 12:33:59', 'medium'),
('99ef8fda-9a3a-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-25 18:08:12', 'medium'),
('c5344a30-9a58-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_deleted', 'Anuncio eliminado: Croke benvenidos de Croke', 'dd', '2025-09-25 21:44:10', 'medium'),
('e6a21f50-9a58-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Croke para Corke', NULL, '2025-09-25 23:45:06', 'low'),
('7752f404-9a66-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-25 23:22:12', 'medium'),
('af3c1a4d-9a67-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Crokee para Croke', NULL, '2025-09-25 23:30:55', 'low'),
('b7730c55-9a67-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_deleted', 'Anuncio eliminado: Anuncio de Prueba de Empresa Ejemplo', 'aa', '2025-09-25 23:31:09', 'medium'),
('856a47e7-9a6c-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-26 00:05:33', 'medium'),
('f7125338-9a70-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_updated', 'Anuncio actualizado: Crokee para Croke (Estado: active)', NULL, '2025-09-26 00:37:21', 'low'),
('a506397a-9acc-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-26 11:33:37', 'medium'),
('a516a789-9acc-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-26 11:33:37', 'medium'),
('deb9156f-9ad2-11f0-830d-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-26 14:18:11', 'medium'),
('75c41bac-9b97-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-09-27 11:45:25', 'medium'),
('763553cf-9b97-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-09-27 11:45:26', 'medium'),
('839e2016-9b9e-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_deleted', 'Anuncio eliminado: Crokee de Croke', 'ww', '2025-09-27 12:35:55', 'medium'),
('a0fd57cb-9b9e-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Bievenido a Croke para Croke (Estado: active)', NULL, '2025-09-27 12:36:44', 'low'),
('92cdb879-9baa-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_created', 'Anuncio creado: Manoloo para ddd (Estado: active)', NULL, '2025-09-27 14:02:14', 'low'),
('dd1dbcfd-9bac-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_updated', 'Anuncio actualizado: Manoloo para ddd (Estado: active)', NULL, '2025-09-27 14:18:38', 'low'),
('56d6ce95-9bbc-11f0-830d-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_deleted', 'Publicación eliminada: 44db3582-b68b-46ac-9a0c-d88654d291a4', NULL, '2025-09-27 18:09:25', 'medium'),
('fbe7bd26-9c64-11f0-b2f9-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-28 14:16:38', 'medium'),
('6e0ff0dd-9c9a-11f0-b2f9-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'ad_updated', 'Anuncio actualizado: Bievenido a Croke para Croke (Estado: active)', NULL, '2025-09-28 18:39:13', 'low'),
('a8bcb12b-9ca3-11f0-b2f9-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'new_comment', 'Nuevo comentario en publicación: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-09-28 19:45:17', 'medium'),
('30cdf8bd-9de8-11f0-b2f9-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_failed', 'Contraseña incorrecta', NULL, '2025-09-30 12:28:21', 'medium'),
('345220c3-9de8-11f0-b2f9-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_failed', 'Contraseña incorrecta', NULL, '2025-09-30 12:28:27', 'medium'),
('37578d33-9de8-11f0-b2f9-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-09-30 12:28:32', 'medium'),
('c37afbdd-9fe2-11f0-b328-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-10-03 00:54:33', 'medium'),
('994c9c75-a21d-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_failed', 'Contraseña incorrecta', NULL, '2025-10-05 21:00:45', 'medium'),
('9c5d4f41-a21d-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-10-05 21:00:50', 'medium'),
('39409b00-a2f1-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_failed', 'Contraseña incorrecta', NULL, '2025-10-06 22:15:37', 'medium'),
('3e776dd2-a2f1-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-10-06 22:15:46', 'medium'),
('7e7f8dfb-a3a9-11f0-a405-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-10-07 20:14:40', 'medium'),
('2c99fdea-a3c9-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta notifications/mark-all-read: SQLSTATE[42S22]: Column not found: 1054 Unknown column \'updated_at\' in \'field list\'', NULL, '2025-10-07 22:01:27', 'medium'),
('30010ae4-a3c9-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'logout', NULL, NULL, '2025-10-07 22:01:32', 'medium'),
('3402c725-a3c9-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-10-07 22:01:39', 'medium'),
('83c71ee4-a3c9-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta friends/remove: SQLSTATE[42S22]: Column not found: 1054 Unknown column \'status\' in \'field list\'', NULL, '2025-10-07 22:03:53', 'medium'),
('a3258a68-a3c9-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta friends/accept: SQLSTATE[42S22]: Column not found: 1054 Unknown column \'status\' in \'field list\'', NULL, '2025-10-07 22:04:45', 'medium'),
('c62b183c-a3c9-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta notifications/mark-all-read: SQLSTATE[42S22]: Column not found: 1054 Unknown column \'updated_at\' in \'field list\'', NULL, '2025-10-07 22:05:44', 'medium'),
('c6b06ccc-a3c9-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta notifications/mark-all-read: SQLSTATE[42S22]: Column not found: 1054 Unknown column \'updated_at\' in \'field list\'', NULL, '2025-10-07 22:05:45', 'medium'),
('c6dfcbfd-a3c9-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta notifications/mark-all-read: SQLSTATE[42S22]: Column not found: 1054 Unknown column \'updated_at\' in \'field list\'', NULL, '2025-10-07 22:05:45', 'medium'),
('c6f8ae96-a3c9-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta notifications/mark-all-read: SQLSTATE[42S22]: Column not found: 1054 Unknown column \'updated_at\' in \'field list\'', NULL, '2025-10-07 22:05:46', 'medium'),
('2cbcc754-a3ca-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta friends/remove: SQLSTATE[42S22]: Column not found: 1054 Unknown column \'updated_at\' in \'field list\'', NULL, '2025-10-07 22:08:36', 'medium'),
('3a67786f-a3ca-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta friends/accept: SQLSTATE[42S22]: Column not found: 1054 Unknown column \'updated_at\' in \'field list\'', NULL, '2025-10-07 22:08:59', 'medium'),
('0d01ac2a-a3cd-11f0-a405-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-10-07 22:29:12', 'medium'),
('10857b8d-a3cd-11f0-a405-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-10-07 22:29:17', 'medium'),
('10d5b81a-a3cd-11f0-a405-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-10-07 22:29:18', 'medium'),
('1aacf086-a3cd-11f0-a405-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-10-07 22:29:34', 'medium'),
('1c9444b4-a3cd-11f0-a405-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-10-07 22:29:38', 'medium'),
('fa20e700-a3cd-11f0-a405-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-10-07 22:35:49', 'medium'),
('fb1ffcfe-a3cd-11f0-a405-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-10-07 22:35:51', 'medium'),
('87d74d46-a3cf-11f0-a405-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-10-07 22:46:57', 'medium'),
('88752e40-a3cf-11f0-a405-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-10-07 22:46:58', 'medium'),
('ae506481-a3cf-11f0-a405-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-10-07 22:48:01', 'medium'),
('af97f075-a3cf-11f0-a405-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-10-07 22:48:03', 'medium'),
('3fc4e1f7-a3d0-11f0-a405-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-10-07 22:52:05', 'medium'),
('68924b54-a3d0-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-10-08 00:53:14', 'medium'),
('8b863578-a3d0-11f0-a405-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-10-08 00:54:12', 'medium'),
('e0898166-a3d0-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: dad8fe7d-716a-4086-916e-eb4e73ca1b0f', NULL, '2025-10-08 00:56:35', 'medium'),
('e21e560b-a3d0-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: dad8fe7d-716a-4086-916e-eb4e73ca1b0f', NULL, '2025-10-08 00:56:38', 'medium'),
('1c0b73f1-a3d1-11f0-a405-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-10-07 22:58:15', 'medium'),
('20ddb0c7-a3d1-11f0-a405-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-10-07 22:58:23', 'medium'),
('72c24769-a42c-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-10-08 11:52:04', 'medium'),
('769e26fb-a42c-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-10-08 09:52:11', 'medium'),
('c8276de6-a42c-11f0-a405-0050565a1c59', NULL, '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_failed', 'Usuario no encontrado: contacto@entradasfresh.es', NULL, '2025-10-08 09:54:27', 'medium'),
('cd3b72b6-a42c-11f0-a405-0050565a1c59', NULL, '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_failed', 'Usuario no encontrado: contacto@entradasfresh.es', NULL, '2025-10-08 09:54:36', 'medium'),
('d457c7b1-a42c-11f0-a405-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-10-08 09:54:48', 'medium'),
('d64a4d20-a42c-11f0-a405-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-10-08 11:54:51', 'medium'),
('d773c4aa-a42c-11f0-a405-0050565a1c59', 'f1da20b5-8f5b-11f0-b588-0050565a1c59', '79.117.222.29', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: be2131e2-80c6-4a32-b601-d1cb421b3e74', NULL, '2025-10-08 11:54:53', 'medium'),
('a6f7328c-a45e-11f0-a405-0050565a1c59', NULL, '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta login: CSRF token inválido.', NULL, '2025-10-08 15:51:26', 'medium'),
('abfb4206-a45e-11f0-a405-0050565a1c59', NULL, '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta login: CSRF token inválido.', NULL, '2025-10-08 15:51:35', 'medium'),
('be952068-a45f-11f0-a405-0050565a1c59', NULL, '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta login: CSRF token inválido.', NULL, '2025-10-08 15:59:16', 'medium'),
('c3db7bf1-a45f-11f0-a405-0050565a1c59', NULL, '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta login: CSRF token inválido.', NULL, '2025-10-08 15:59:24', 'medium'),
('16e0df85-a464-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-10-08 16:30:22', 'medium'),
('4682677a-a53e-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-10-09 18:32:11', 'medium'),
('77274406-a53e-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_failed', 'Contraseña incorrecta', NULL, '2025-10-09 20:33:33', 'medium'),
('79be2103-a53e-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-10-09 20:33:37', 'medium'),
('01f0eebd-a541-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_created', 'Nueva publicación creada', NULL, '2025-10-09 20:51:45', 'medium'),
('07d767c7-a541-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: 51a0eee8-63e5-4b81-abc1-23c8202edc36', NULL, '2025-10-09 18:51:55', 'medium'),
('0f240177-a541-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'user_tagged', 'Usuario etiquetado: Mortii25', NULL, '2025-10-09 20:52:07', 'medium'),
('124f7c2e-a541-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'new_comment', 'Nuevo comentario en publicación: 51a0eee8-63e5-4b81-abc1-23c8202edc36', NULL, '2025-10-09 18:52:12', 'medium'),
('626055de-a541-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '86.127.225.97', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-10-09 20:54:27', 'medium'),
('b2a1bc05-a541-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'logout', NULL, NULL, '2025-10-09 20:56:41', 'medium'),
('e9630a3e-a541-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'login_success', NULL, NULL, '2025-10-09 18:58:13', 'medium'),
('ef2430e3-a541-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'unauthorized_delete_attempt', 'Intento de eliminar publicación ajena: 51a0eee8-63e5-4b81-abc1-23c8202edc36&lt;input type=', NULL, '2025-10-09 18:58:23', 'medium'),
('f96928d7-a541-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_deleted', 'Publicación eliminada: 51a0eee8-63e5-4b81-abc1-23c8202edc36', NULL, '2025-10-09 20:58:40', 'medium'),
('02c5f6ac-a542-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_created', 'Nueva publicación creada', NULL, '2025-10-09 20:58:56', 'medium'),
('6390220e-a542-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_deleted', 'Publicación eliminada: bdf2c41b-69b5-4537-898d-48bc7a147ad8', NULL, '2025-10-09 21:01:38', 'medium'),
('c82c22f2-a542-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '86.127.225.97', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'logout', NULL, NULL, '2025-10-09 19:04:27', 'medium'),
('1876c0a0-a544-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_created', 'Nueva publicación creada', NULL, '2025-10-09 19:13:51', 'medium'),
('1c05beb1-a544-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: 97ffaa45-1f47-4f4c-ae64-39214ad08ff9', NULL, '2025-10-09 19:13:57', 'medium'),
('773076d6-a546-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'user_tagged', 'Usuario etiquetado: Mortii25', NULL, '2025-10-09 19:30:49', 'medium'),
('7a3c92fa-a546-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'caption_updated', 'Descripción actualizada: 97ffaa45-1f47-4f4c-ae64-39214ad08ff9', NULL, '2025-10-09 19:30:54', 'medium'),
('217098d6-a547-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'system_error', 'Error en ruta posts/like: SQLSTATE[23000]: Integrity constraint violation: 1062 Duplicate entry \'97ffaa45-1f47-4f4c-ae64-39214ad08ff9-8194d00a-8f3b-11f0-b588-...\' for key \'unique_like\'', NULL, '2025-10-09 19:35:35', 'medium'),
('6e9e8c0e-a547-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: 97ffaa45-1f47-4f4c-ae64-39214ad08ff9', NULL, '2025-10-09 19:37:44', 'medium'),
('6fdd9052-a547-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: 97ffaa45-1f47-4f4c-ae64-39214ad08ff9', NULL, '2025-10-09 19:37:46', 'medium'),
('71154d60-a547-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: 97ffaa45-1f47-4f4c-ae64-39214ad08ff9', NULL, '2025-10-09 19:37:48', 'medium'),
('721705f0-a547-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: 97ffaa45-1f47-4f4c-ae64-39214ad08ff9', NULL, '2025-10-09 19:37:50', 'medium'),
('730ca8b4-a547-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_unliked', 'Like eliminado: 97ffaa45-1f47-4f4c-ae64-39214ad08ff9', NULL, '2025-10-09 19:37:52', 'medium'),
('73b708df-a547-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'post_liked', 'Like añadido: 97ffaa45-1f47-4f4c-ae64-39214ad08ff9', NULL, '2025-10-09 19:37:53', 'medium'),
('a9edf00a-a547-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'caption_updated', 'Descripción actualizada: 97ffaa45-1f47-4f4c-ae64-39214ad08ff9', NULL, '2025-10-09 19:39:24', 'medium'),
('c6889b22-a549-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'new_comment', 'Nuevo comentario en publicación: 97ffaa45-1f47-4f4c-ae64-39214ad08ff9', NULL, '2025-10-09 21:54:31', 'medium'),
('d1704550-a549-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'comment_reply', 'Respuesta a comentario: 26151051-1902-4601-9194-42e8891d63a5', NULL, '2025-10-09 19:54:49', 'medium'),
('d4fcb079-a549-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'comment_reply', 'Respuesta a comentario: 26151051-1902-4601-9194-42e8891d63a5', NULL, '2025-10-09 19:54:55', 'medium'),
('da4cb072-a549-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'caption_updated', 'Descripción actualizada: 97ffaa45-1f47-4f4c-ae64-39214ad08ff9', NULL, '2025-10-09 21:55:04', 'medium'),
('1790b864-a557-11f0-a405-0050565a1c59', '8194d00a-8f3b-11f0-b588-0050565a1c59', '164.68.96.7', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'logout', NULL, NULL, '2025-10-09 23:29:50', 'medium');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `site_policies`
--

CREATE TABLE `site_policies` (
  `id` int(11) NOT NULL,
  `terms_content` longtext DEFAULT NULL,
  `privacy_content` longtext DEFAULT NULL,
  `cookies_content` longtext DEFAULT NULL,
  `community_guidelines` longtext DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `site_policies`
--

INSERT INTO `site_policies` (`id`, `terms_content`, `privacy_content`, `cookies_content`, `community_guidelines`, `created_at`, `updated_at`) VALUES
(1, NULL, NULL, NULL, NULL, '2025-09-30 23:00:07', '2025-09-30 23:00:07');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `system_config`
--

CREATE TABLE `system_config` (
  `id` int(11) NOT NULL,
  `site_name` varchar(255) NOT NULL DEFAULT 'Thirty',
  `site_description` text DEFAULT NULL,
  `maintenance_mode` tinyint(1) DEFAULT 0,
  `maintenance_message` text DEFAULT NULL,
  `allow_registrations` tinyint(1) DEFAULT 1,
  `max_login_attempts` int(11) DEFAULT 5,
  `session_timeout` int(11) DEFAULT 7200,
  `cookie_lifetime` int(11) DEFAULT 86400,
  `ad_cookie_duration` int(11) DEFAULT 86400,
  `birthday_panel_duration` int(11) DEFAULT 3600,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `system_config`
--

INSERT INTO `system_config` (`id`, `site_name`, `site_description`, `maintenance_mode`, `maintenance_message`, `allow_registrations`, `max_login_attempts`, `session_timeout`, `cookie_lifetime`, `ad_cookie_duration`, `birthday_panel_duration`, `created_at`, `updated_at`) VALUES
(1, 'Thirty', 'La red social de tus amigos de verdad', 0, NULL, 1, 5, 7200, 86400, 86400, 3600, '2025-09-30 23:00:07', '2025-09-30 23:00:07');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tags`
--

CREATE TABLE `tags` (
  `id` char(36) NOT NULL,
  `post_id` char(36) NOT NULL,
  `x` decimal(6,2) NOT NULL,
  `y` decimal(6,2) NOT NULL,
  `name` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `tags`
--

INSERT INTO `tags` (`id`, `post_id`, `x`, `y`, `name`) VALUES
('2ecf39ed-db86-430a-91ac-0a30e602a29d', '97ffaa45-1f47-4f4c-ae64-39214ad08ff9', 50.00, 50.00, 'Mortii25');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `users`
--

CREATE TABLE `users` (
  `id` char(36) NOT NULL,
  `username` varchar(50) NOT NULL,
  `email` varchar(190) NOT NULL,
  `email_verified` tinyint(1) NOT NULL DEFAULT 0,
  `verified_at` datetime DEFAULT NULL,
  `birth_date` date NOT NULL,
  `date_of_birth` date DEFAULT NULL,
  `bio` text DEFAULT NULL,
  `password_hash` varchar(255) NOT NULL,
  `role` enum('user','admin','moderator') DEFAULT 'user',
  `invites_left` int(11) NOT NULL DEFAULT 5,
  `failed_attempts` int(11) NOT NULL DEFAULT 0,
  `locked_until` datetime DEFAULT NULL,
  `last_active` datetime DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `profile_image` varchar(500) DEFAULT NULL,
  `avatar_url` varchar(255) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL,
  `gender` varchar(20) DEFAULT NULL,
  `country_code` varchar(2) DEFAULT NULL,
  `region` varchar(80) DEFAULT NULL,
  `city` varchar(120) DEFAULT NULL,
  `postal_code` varchar(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `users`
--

INSERT INTO `users` (`id`, `username`, `email`, `email_verified`, `verified_at`, `birth_date`, `date_of_birth`, `bio`, `password_hash`, `role`, `invites_left`, `failed_attempts`, `locked_until`, `last_active`, `last_login`, `profile_image`, `avatar_url`, `created_at`, `updated_at`, `gender`, `country_code`, `region`, `city`, `postal_code`) VALUES
('8194d00a-8f3b-11f0-b588-0050565a1c59', 'Mortii25', 'edgar_moreno@hotmail.es', 1, '2025-09-15 14:05:44', '1994-09-25', NULL, 'www', '$2y$10$JvYqR2nr1Vu.9R00GrGeauHIfTEzYOlNr5.3GPZk4m.ztLsqnB5Ru', 'admin', 3, 0, NULL, '2025-10-09 23:29:50', '2025-10-09 18:58:13', NULL, '/uploads/avatars/u8194d00a-8f3b-11f0-b588-0050565a1c59_1759274096_e42e3918.png', '2025-09-11 20:16:57', '2025-09-30 23:14:56', 'male', 'ES', 'Comunidad de Madrid', 'Madrid', NULL),
('c0b40277-922c-11f0-87d2-0050565a1c59', 'Manolo', 'admin@eventos.com', 1, '2025-09-15 14:11:10', '2009-09-15', '2009-09-15', NULL, '$2y$10$3VyZQdhyuKw9Eol7/OMlN.vSCRg/l0/.XO7fl4VPLIHj4QgvFb11W', 'user', 5, 0, NULL, '2025-09-15 17:38:05', '2025-09-15 12:11:31', NULL, NULL, '2025-09-15 12:08:55', NULL, NULL, NULL, NULL, NULL, NULL),
('f1da20b5-8f5b-11f0-b588-0050565a1c59', 'Moleno25', 'creador@eventos.com', 1, '2025-09-15 14:11:16', '1994-09-15', NULL, NULL, '$2y$10$tDyoZDv4gXhIxW3yQS9VI.RcvIT2Ux1XmB4KviD3668dPf6jVge1W', 'user', 5, 0, NULL, '2025-10-08 09:54:48', '2025-10-08 09:54:48', NULL, '/uploads/avatars/uf1da20b5-8f5b-11f0-b588-0050565a1c59_1759876292_03fd99fc.png', '2025-09-12 00:09:09', '2025-10-07 22:31:32', NULL, NULL, NULL, NULL, NULL);

--
-- Índices para tablas volcadas
--

--
-- Indices de la tabla `ads`
--
ALTER TABLE `ads`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `idx_dates` (`start_date`,`end_date`),
  ADD KEY `idx_advertiser` (`advertiser`),
  ADD KEY `fk_ads_created_by` (`created_by`);

--
-- Indices de la tabla `ad_impressions`
--
ALTER TABLE `ad_impressions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_ad_day` (`ad_id`,`created_at`),
  ADD KEY `idx_user_day` (`user_id`,`created_at`),
  ADD KEY `idx_session_day` (`session_id`,`created_at`),
  ADD KEY `idx_adimpressions_ad` (`ad_id`),
  ADD KEY `idx_adimpressions_user` (`user_id`),
  ADD KEY `idx_adimpressions_session` (`session_id`);

--
-- Indices de la tabla `comments`
--
ALTER TABLE `comments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `post_id` (`post_id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `fk_comment_reply` (`reply_to`),
  ADD KEY `idx_comments_post` (`post_id`),
  ADD KEY `idx_comments_user` (`user_id`);

--
-- Indices de la tabla `comment_replies`
--
ALTER TABLE `comment_replies`
  ADD PRIMARY KEY (`id`),
  ADD KEY `comment_id` (`comment_id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `idx_comment_replies_comment` (`comment_id`),
  ADD KEY `idx_comment_replies_user` (`user_id`);

--
-- Indices de la tabla `email_verifications`
--
ALTER TABLE `email_verifications`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `token` (`token`),
  ADD UNIQUE KEY `uniq_email_verifications_token` (`token`),
  ADD KEY `idx_token` (`token`),
  ADD KEY `idx_user_id` (`user_id`),
  ADD KEY `idx_email_verifications_user` (`user_id`);

--
-- Indices de la tabla `friends`
--
ALTER TABLE `friends`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_friendship` (`user1_id`,`user2_id`),
  ADD KEY `user2_id` (`user2_id`),
  ADD KEY `idx_friends_user1` (`user1_id`),
  ADD KEY `idx_friends_user2` (`user2_id`),
  ADD KEY `idx_friends_pair` (`user1_id`,`user2_id`);

--
-- Indices de la tabla `friendships`
--
ALTER TABLE `friendships`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_pair` (`a_id`,`b_id`);

--
-- Indices de la tabla `interactions`
--
ALTER TABLE `interactions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_interaction` (`user_id`,`target_id`,`type`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `target_id` (`target_id`),
  ADD KEY `type` (`type`),
  ADD KEY `created_at` (`created_at`),
  ADD KEY `idx_interactions_user` (`user_id`),
  ADD KEY `idx_interactions_target` (`target_id`);

--
-- Indices de la tabla `invites`
--
ALTER TABLE `invites`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `code` (`code`),
  ADD UNIQUE KEY `uniq_invites_code` (`code`),
  ADD UNIQUE KEY `used_by` (`used_by`),
  ADD KEY `issued_by` (`issued_by`),
  ADD KEY `used_by_2` (`used_by`);

--
-- Indices de la tabla `likes`
--
ALTER TABLE `likes`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_like` (`post_id`,`user_id`),
  ADD KEY `idx_likes_post` (`post_id`),
  ADD KEY `idx_likes_user` (`user_id`);

--
-- Indices de la tabla `login_attempts`
--
ALTER TABLE `login_attempts`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `messages`
--
ALTER TABLE `messages`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `notifications`
--
ALTER TABLE `notifications`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_notifications_user_read` (`user_id`,`is_read`,`created_at`);

--
-- Indices de la tabla `password_resets`
--
ALTER TABLE `password_resets`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `photos`
--
ALTER TABLE `photos`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `posts`
--
ALTER TABLE `posts`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `reports`
--
ALTER TABLE `reports`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `site_policies`
--
ALTER TABLE `site_policies`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `system_config`
--
ALTER TABLE `system_config`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`),
  ADD UNIQUE KEY `email` (`email`);

--
-- AUTO_INCREMENT de las tablas volcadas
--

--
-- AUTO_INCREMENT de la tabla `site_policies`
--
ALTER TABLE `site_policies`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT de la tabla `system_config`
--
ALTER TABLE `system_config`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

DELIMITER $$
--
-- Eventos
--
CREATE DEFINER=`root`@`localhost` EVENT `auto_update_ad_status` ON SCHEDULE EVERY 1 HOUR STARTS '2025-09-25 23:30:11' ON COMPLETION NOT PRESERVE ENABLE DO CALL UpdateAdStatusAutomatically()$$

DELIMITER ;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
